/**
 * FehlerDialog.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.helpanderror;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.view.GitterBeutelBeschraenkungen;
import eu.gronos.kostenrechner.view.KostenJDialog;

/**
 * Eine Klasse, die Fehlermeldungen ausführlicher darstellt.
 *
 * @author Peter Schuster (setrok)
 * @date 26.08.2014
 *
 */
public class FehlerDialog extends /* HinzufuegenDialog<Boolean> */ KostenJDialog {

	private static final long serialVersionUID = 306283812188663774L;
	public static final String FEHLER_BLANKO = "Fehler";
	/**
	 * Das Info-Fenster soll maximal 7 Zeilen enthalten
	 */
	private static final int MAX_ZEILEN_TRACE = 11;
	/**
	 * Die eigentliche Fehlermeldung soll nur zwei Zeilen haben.
	 */
	private static final int FEHLER_ZEILEN = 2;

	private final FehlerHelper feHelper;

	/**
	 * Der Konstruktor initialisiert den Dialog und gibt eine StackTrace aus.
	 * 
	 * @param feHelper  den {@link FehlerHelper}
	 * @param throwable das {@link Throwable} (Oberklasse von {@link Exception}),
	 *                  das geworfen wurde.
	 */
	public FehlerDialog(String meldung, FehlerHelper feHelper) {
		super(Kostenrechner.getInstance(), ((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(72000)));
//		try {
//			super.setAlwaysOnTop(true);
//		} catch (SecurityException e) {
//			e.printStackTrace();
//		}
		this.feHelper = feHelper;
		// super.setOkButtonToBeFocussed(true);
	}

//	@Override
//	public boolean parseEingabe() {
//		return true;
//	}

	/**
	 * Die Methode füllt das contentPane mit einem Icon-Label, einer JTextArea für
	 * die eigentliche Meldung und einer JTextArea im JScrollPane für den
	 * StackTrace.
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#fuelleContentPane()
	 */
	@Override
	protected void fuelleContentPane() {
		JPanel meldungPane = new JPanel();
		meldungPane.setLayout(new FlowLayout(FlowLayout.LEFT));
		Border schwarz = BorderFactory
				.createLineBorder(UIManager.getLookAndFeel().getDefaults().getColor("Button.shadow"));
		meldungPane.setBorder(BorderFactory.createTitledBorder(schwarz));
		beschrifter.beschrifte(meldungPane, NameContainerSammlung.BESCHRIFTUNGEN.get(72100));

		JLabel lblIcon = (JLabel) beschrifter.beschrifte(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(72102));

		JTextArea jtaMeldung = (JTextArea) beschrifter.beschrifte(new JTextArea(feHelper.getMeldung()),
				NameContainerSammlung.BESCHRIFTUNGEN.get(72101));

		// meldung
		jtaMeldung.setRows(FEHLER_ZEILEN);
		jtaMeldung.setEditable(false);
		jtaMeldung.setOpaque(false);

		JScrollPane scpStackTrace = baueStackTracePane();

		meldungPane.add(lblIcon);
		meldungPane.add(jtaMeldung);
		contentPanel.add(meldungPane,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		contentPanel.add(scpStackTrace,
				GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1, GridBagConstraints.BOTH, true));

		getButtonPane().add((feHelper.getEmailAktion()).toButton());
		addToRootInputMap(feHelper.getEmailAktion());
	}

//	@Override
//	protected Boolean baueRueckgabewert() {
//		return Boolean.TRUE;
//	}
	// BildOhneTitel beschrIcon = new BildOhneTitel();beschrIcon
	// beschrIcon.setId("72102");
	// beschrIcon.setImage("resources/rechnerhammer-rot.png");
	// beschrIcon.setRef((Beschriftung)
	// NameContainerSammlung.BESCHRIFTUNGEN.get(72100));
	// new JLabel(RechnerhammerIcons.getRechnerhammerRot());


	/**
	 * Die Methode baut zu debug-Zwecken eine {@link JScrollPane} mit einem über
	 * {@link FehlerHelper#baueFehlerXmlString(boolean)} in XML konvertierten
	 * {@link Throwable#getStackTrace()}.
	 * 
	 * Wenn {@link Kostenrechner#debug} nicht aktiv ist, gibt baut sie nur eine
	 * leere {@link JScrollPane}.
	 * 
	 * @return die {@link JScrollPane}
	 */
	private JScrollPane baueStackTracePane() {
		JScrollPane scpStackTrace = (JScrollPane) beschrifter.beschrifte(new JScrollPane(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(72200));
		scpStackTrace.setVisible(Kostenrechner.debug);

		// Wenn kein debug, reicht das schon.
		if (!Kostenrechner.debug) {
			return scpStackTrace;
		}

		// Sonst geht es jetzt los
		JTextArea jtaStackTrace = (JTextArea) beschrifter.beschrifte(new JTextArea(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(72201));

		jtaStackTrace.setText(feHelper.baueFehlerXmlString(true));
		jtaStackTrace.setForeground(Color.RED);
		//jtaStackTrace.setBackground(Color.BLACK);
		jtaStackTrace.setRows(MAX_ZEILEN_TRACE);
		jtaStackTrace.setCaretPosition(0);
		jtaStackTrace.setEditable(false);
		scpStackTrace.setViewportView(jtaStackTrace);

		return scpStackTrace;
	}

}
// private String meldung;
// private Throwable throwable;
// private final StackTraceElement stack;

// "Beim Autor beschweren","e-mail", , KeyEvent.VK_E
// "Öffnet das Standard-E-Mail-Programm,\n" + "um eine E-Mail an den
// Programmierer zu verfassen",
// new JButton(emailSchreibenFehler));
//final FontHelferForWindow fhfw = new FontHelferForWindow(this);
//StringBuffer sb = f_helper.getFehlerText();
//JTextArea jtaStackTrace = new JTextArea();
//jtaStackTrace.setText(sb.toString());

// fufHelfer.setPreferredSizeFromAttributeSet(doc.getStyle("base"),
// FontHelfer.MAX_SPALTEN, FontHelfer.MAX_ZEILEN// );
// jtaStackTrace.setPreferredSize(calculatePreferredSizeFrom
// , fhfc.getCharDimension(fhfc.getFontMetrics(attrib)),
// jtaStackTrace.getMaximumSize(),
// jtaStackTrace.getPreferredSize()));
//jtaStackTrace.setRows(7);

/*
 * Der Konstruktor initialisiert den Dialog und gibt eine StackTrace aus.
 * 
 * @param title den Titel des Dialogs
 * 
 * @param meldung die Fehlermeldung
 * 
 * @param throwable das {@link Throwable} (Oberklasse von {@link Exception}),
 * das geworfen wurde. private FehlerDialog(String title, String meldung,
 * Throwable throwable) { super(Kostenrechner.getInstance(), ((Beschriftung)
 * NameContainerSammlung.BESCHRIFTUNGEN.get(72000)).setTitle(title));
 * this.meldung = meldung; this.throwable = throwable;
 * super.setOkButtonToBeFocussed(true); this.stack =
 * throwable.getStackTrace()[0]; String klasse = stack.getClassName(); String
 * methode = stack.getMethodName();
 * Kostenrechner.getLogger().logp(Level.WARNING, klasse, methode, meldung,
 * throwable); emailSchreibenFehler = new SchreibeEmailFehler(
 * (LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(72045),
 * this.throwable); }
 */
// , Throwable throwable
// this.meldung = meldung;
// this.throwable = throwable;
//	this.stack = throwable.getStackTrace()[0];
//	String klasse = stack.getClassName();
//	String methode = stack.getMethodName();
//	Kostenrechner.getLogger().logp(Level.WARNING, klasse, methode, meldung, throwable);
// this.throwable
// .getThrowable()// , throwable
// feHelper.writeHTML(doc, (HTMLEditorKit) tpnStackTrace.getEditorKit());
// throwable.printStackTrace();
//private final AbstractAction emailSchreibenFehler;
//emailSchreibenFehler = new SchreibeEmailFehler(
//		(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(72045), feHelper);
//getButtonPane().add(((BeschriebeneAktion) emailSchreibenFehler).toButton());
//addToRootInputMap(emailSchreibenFehler);
// JScrollPane jScrollPane = new JScrollPane();
// jScrollPane.setVisible(Kostenrechner.debug);
// jtaStackTrace
// JTextPane tpnStackTrace = (JTextPane)
// new JTextPane());
// final FontHelferForComponent fhfc = new
// FontHelferForComponent(tpnStackTrace);
// HtmlHelper helper = new HtmlHelper();
// helper.setzeKitUndDocument(tpnStackTrace);
// final HTMLDocument doc = (HTMLDocument) tpnStackTrace.getStyledDocument();
// fhfc.createBoldStyle(doc, fhfc.createBaseStyle(doc));
// try {
// baueFehlerText(doc);
// } catch (BadLocationException | IOException e) {
// System.err.println(e.getLocalizedMessage());
// e.printStackTrace();
// }
// fhfc.setPreferredSizeFromAttributeSet(doc.getStyle("base"),
// FontHelfer.MAX_SPALTEN, MAX_ZEILEN_TRACE);
// tpnStackTrace.setCaretPosition(0);
// tpnStackTrace.setForeground(Color.RED);
// tpnStackTrace.setEditable(false);
// tpnStackTrace//.toString()