/**
 * LizenzAkzeptanzHinzufuegen.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.helpanderror;

import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;

import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.ComponentBeschrifter;
import eu.gronos.kostenrechner.controller.files.MausLogHorcher;
import eu.gronos.kostenrechner.controller.system.GplAnzeigenToggleAction;
import eu.gronos.kostenrechner.interfaces.Vorsorgend;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangVorsorgeBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.beschriftungen.UnBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.VorsorgendeBeschriftung;
import eu.gronos.kostenrechner.view.GitterBeutelBeschraenkungen;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.KostenJDialog;

/**
 * Ein {@link HinzufuegenDialog}, der beim ersten Programmstart die Annahme der
 * Lizenzbedingungen abwartet.
 *
 * @author Peter Schuster (setrok)
 * @date 03.12.2014
 *
 */
public class LizenzZustimmungDialog extends AkzeptanzDialog<Boolean> {

	private static final String LIZENZ_HTML = "resources/lizenz.html";
	private static final long serialVersionUID = -774138389489802048L;
	private final Action gplAnzeigenAktion = new GplAnzeigenToggleAction(
			(LangVorsorgeBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73055), this);

	/**
	 * Konstruktor: erzeugt eine Instanz des {@link LizenzZustimmungDialog}.
	 * 
	 * @param owner ein {@link JFrame}
	 * @throws HeadlessException
	 */
	public LizenzZustimmungDialog(JFrame owner) throws HeadlessException {
		this(owner, true);
	}

	/**
	 * Konstruktor: erzeugt eine Instanz der {@link LizenzZustimmungDialog}.
	 * 
	 * @param owner            ein {@link JFrame}
	 * @param zustimmungNoetig wenn <code>true</code>, dann wird der OK-Button in
	 *                         "Ja, ich stimme zu!" umbenannt.
	 * @throws HeadlessException
	 */
	public LizenzZustimmungDialog(JFrame owner, boolean zustimmungNoetig) throws HeadlessException {
		super(owner, (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73000));
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		if (zustimmungNoetig) {
			beschrifter.beschrifte(super.getOkButton(), NameContainerSammlung.BESCHRIFTUNGEN.get(73051));
		} else {
			beschrifter.changeTo(((Vorsorgend<?>) super.getBeschriftung()), 1);
			// .applyTo
			beschrifter.beschrifte(this, super.getBeschriftung());
			infoPanelErgaenzen();
		}
		super.setOkButtonToBeFocussed(true);
	}

	/**
	 * @return {@link Boolean#TRUE} - wenn Ok gedrückt wird, ist alles gut.
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override //
	protected Boolean baueRueckgabewert() {
		return Boolean.TRUE;
	}

	@Override
	protected void fuelleContentPane() {
		baueTextPane(LIZENZ_HTML);
		super.getButtonPane().add(((BeschriebeneAktion) gplAnzeigenAktion).toButton());
	}

	/**
	 * Die Methode ergänzt das {@link KostenJDialog#contentPanel} um eine Info übers
	 * Programm.
	 */
	private void infoPanelErgaenzen() {
		JPanel infoPanel = new JPanel();
		final GridBagLayout gbl_infoPanel = new GridBagLayout();

		Border schwarz = BorderFactory
				.createLineBorder(UIManager.getLookAndFeel().getDefaults().getColor("Button.shadow"));
		TitledBorder brdr = BorderFactory.createTitledBorder(schwarz);
		infoPanel.setBorder(brdr);
		infoPanel.setLayout(gbl_infoPanel);
		beschrifter.beschrifte(infoPanel, NameContainerSammlung.BESCHRIFTUNGEN.get(73100));

		UnBeschriftung nameBeschriftung = (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73110);
		JLabel lblName = (JLabel) beschrifter.beschrifte(new JLabel(), nameBeschriftung);
		lblName.setText(nameBeschriftung.getRef().getTitle());

		JLabel lblCopy = (JLabel) beschrifter.beschrifte(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(73120));
		Beschriftung logBeschriftung = (Beschriftung) beschrifter.changeTo(
				(VorsorgendeBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73130), 0,
				Kostenrechner.getLogFileName());
		JLabel lblLog = (JLabel) beschrifter.beschrifte(new JLabel(), logBeschriftung);
		// Link aufs Logfile ergänzen
		lblLog.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		lblLog.addMouseListener(new MausLogHorcher());

		// Rechnerhammer (BildOhneTitel)
		JLabel lblBild = (JLabel) beschrifter.beschrifte(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(73140));

		infoPanel.add(lblBild, GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 3, GridBagConstraints.BOTH, false));
		infoPanel.add(lblName,
				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		infoPanel.add(lblCopy,
				GitterBeutelBeschraenkungen.getInstance(1, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
		infoPanel.add(lblLog,
				GitterBeutelBeschraenkungen.getInstance(1, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));

		contentPanel.add(infoPanel,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 3, 1, GridBagConstraints.HORIZONTAL, false));
	}
	// infoPanel.setBorder(BORDER);
	// Beschriftung
	// tabbedPane = new JTabbedPane();
	// getContentPane().add(tabbedPane, BorderLayout.CENTER);
	// getContentPane().remove(contentPanel);
	// contentPanel.setBorder(BORDER);
	// final GridBagLayout gbl_contentPanel = new GridBagLayout();
	// contentPanel.setLayout(gbl_contentPanel);
	// nameBeschriftung.setTitle(nameBeschriftung.getTitle() + " " +
	// Kostenrechner.KOSTENRECHNER_VERSION);
	// nameBeschriftung.applyTo(lblName);
	// TabbedPaneFactory.intoTabbedPane(tabbedPane, infoPanel,
	// (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73100));
	// TabbedPaneFactory.intoTabbedPane(tabbedPane, contentPanel,
	// (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73005));
}
//private static final String TITLE = "Lizenzvereinbarung";
//TITLE
// AbstractAction ok = super.getOkAction();
// ok.putValue(Action.NAME, "Ja, ich stimme zu!");
// ok.putValue(Action.MNEMONIC_KEY, KeyEvent.VK_J);
// ok.putValue(Action.SHORT_DESCRIPTION, "Den Lizenzbedingungen zustimmen");
// new JButton(
//  Beschriftung
//beschrBild = new BildOhneTitel();
//beschrBild.setId("73140");
//beschrBild.setRef((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73100));
//beschrBild.setImage("resources/rechnerhammer-128.png");
// new JLabel(RechnerhammerIcons.getRechnerhammer128());// 64 //
// lblBild.setName("73140");
// Beschriftung logBeschriftung = (Beschriftung)
// NameContainerSammlung.BESCHRIFTUNGEN.get(73130);
// logBeschriftung.setTitle(logBeschriftung.getTitle() + " " +
// Kostenrechner.getLogFileName());
// ((Beschriftung)