/**
 * AktionenJMenu.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.menus;

import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.ComponentBeschrifter;
import eu.gronos.kostenrechner.controller.system.BooleanConfigOptionHorcher;
import eu.gronos.kostenrechner.controller.system.InfoAction;
import eu.gronos.kostenrechner.controller.system.SchreibeEmailAllgemein;
import eu.gronos.kostenrechner.controller.system.SchreibeEmailXml;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.beschriftungen.SchluesselBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.Allgemein;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Das Menü Extras enthält die Aktionen für alle möglichen Menüpunkte
 *
 * @author Peter Schuster (setrok)
 * @date 20.06.2018
 *
 */
public class ExtrasJMenu extends KostenJMenu implements WerteLesbar<Allgemein> {

	private static final long serialVersionUID = 7935405681482100256L;
	private static final ExtrasJMenu instance = new ExtrasJMenu();
	//private Kostenrechner kostenrechner;
	private AbstractAction ueberAction = new InfoAction(
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(62081));
	// private final Action lizenzAnzeigenAktion = new LizenzAnzeigenAktion(
	// (LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(62091), this);
	private final AbstractAction emailSchreibenXML = new SchreibeEmailXml(
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(62101));
	private final AbstractAction emailSchreibenAllgemein = new SchreibeEmailAllgemein(
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(62111));
	public JCheckBoxMenuItem mi92;

	/**
	 * Der private Konstruktor hat keine Parameter
	 * 
	 */
	private ExtrasJMenu() {
		super();
	}

	/**
	 * Die Methode dient dazu, das Menü Aktionen mit Menüpunkten zu füllen
	 * 
	 */
	public void buildMenu() {
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		beschrifter.beschrifte(this, NameContainerSammlung.BESCHRIFTUNGEN.get(62000));
		// TODO Tastenkürzel doppelt?
		// mi92 = (JCheckBoxMenuItem)
		// NameContainerSammlung.BESCHRIFTUNGEN.get(62011).applyTo(new
		// JCheckBoxMenuItem());
		// mi92.addItemListener(new BooleanConfigOptionHorcher("p92iiZPO", true, mi92));
		mi92 = (JCheckBoxMenuItem) new BooleanConfigOptionHorcher(
				// new BooleanConfigSchluessel("p92iiZPO", true), (LangBeschriftung)
				(SchluesselBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(62011)).toMenuItem();
		add(mi92);
		addSeparator();
		
		add(((BeschriebeneAktion) StreitgenossenPanel.getInstance().baumbachAssistentAction).toMenuItem());
		// TODO schon in neue Klasse?
		add(((BeschriebeneAktion) StreitgenossenPanel.getInstance().gesamtschuldnerschaftExtrahierenAction)
				.toMenuItem());
		add(((BeschriebeneAktion) StreitgenossenPanel.getInstance().gesamtschuldnerschaftDwbkExtrahierenAction)
				.toMenuItem());
		// TODO ab hier nicht mehr neue Klasse
		
		addSeparator();
		add(((BeschriebeneAktion) ueberAction).toMenuItem());
		// add(((BeschriebeneAktion) lizenzAnzeigenAktion).toMenuItem());
		JMenu kontaktMenu = (JMenu) beschrifter.beschrifte(new JMenu(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(62100));
		kontaktMenu.add(((BeschriebeneAktion) emailSchreibenAllgemein).toMenuItem());
		kontaktMenu.add(((BeschriebeneAktion) emailSchreibenXML).toMenuItem());
		add(kontaktMenu);

	}

	/**
	 * @return gibt {@link #instance} als AktionenJMenu zurück.
	 */
	public static ExtrasJMenu getInstance() {
		return instance;
	}

	
	/**
	 * Die Methode dient dazu, die Oberflächenelemente des Panels mit Werten zu
	 * füllen, hier mit allgemeinen Programmeinstellungen, die nicht vom Container
	 * selbst gesetzt werden.
	 * 
	 * @param container
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#setzeWerte(Streitgenossen,
	 *      eu.gronos.kostenrechner.controller.UnterContainerKlasse)
	 */
	@Override
	public void setzeWerte(Allgemein container) {
		mi92.setSelected(container.b92ii);
		getKostenrechner().getTabbedPane().setSelectedIndex(container.selectedPanel);
	}

	/**
	 * Die Methode dient dazu, allgemeine Programmeinstellungen, die nicht vom
	 * Container selbst gesetzt werden, in einen Container zu packen.
	 * 
	 * @return eine {@link UnterContainerKlasse}: {@link Allgemein}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#baueRueckgabewert()
	 */
	@Override
	public Allgemein baueRueckgabewert() {
		Allgemein container = new Allgemein();
		container.aktenzeichen = "k.A.";
		container.b92ii = mi92.isSelected();
		container.selectedPanel = getKostenrechner().getTabbedPane().getSelectedIndex();
		return container;
	}

	/**
	 * Wenn der leereWerte()-Befehl kommt, setzt die Klasse nur {@link #mi92} wieder
	 * auf <code>true</code>.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#leereWerte()
	 */
	@Override
	public void leereWerte() {
		mi92.setSelected(true);
	}

	/**
	 * @return gibt {@link #ueberAction} als {@link AbstractAction} zurück.
	 */
	public AbstractAction getUeberAction() {
		return ueberAction;
	}

}
//, KeyEvent.VK_L// , KeyEvent.VK_T
//, KeyEvent.getExtendedKeyCodeForChar('Ü')
// setMnemonic(KeyEvent.VK_A);// "Aktionen"
// "Über " + Kostenrechner.KOSTENRECHNER_TITLE, "Zeigt Informationen über das
// Programm an.", , "about"
// "Fehlermeldung an Autor", "<html>Öffnet den Standard-E-Mail-Programm,<br>um
// eine E-Mail mit Fehlerbehebungsdaten an den Programmierer zu
// verfassen</html>",
// , "e-mail-plus"
// "E-Mail an Autor","e-mail",
// "<html>Öffnet den Standard-E-Mail-Programm,<br>um eine E-Mail an den
// Programmierer zu verfassen</html>",
// , "Lizenz", "Zeigt die Kurzform der Lizenzbedingungen an."
//		mi92 = new JCheckBoxMenuItem("§ 92 Abs. 2 ZPO anwenden", true);
//		mi92.setToolTipText("Verhältnismäßig geringe Kostenquoten (unter 10%) werden nach § 92 II ZPO ignoriert und den anderen Beteiligten auferlegt.");
// mi92.setMnemonic(KeyEvent.VK_9);
// new
// JMenuItem(TeilklageruecknahmePanel.getInstance().klageruecknahmeTerminAction));
// new JMenuItem(StreitgenossenPanel.getInstance().baumbachAssistentAction));
// new
// JMenuItem(StreitgenossenPanel.getInstance().gesamtschuldnerschaftExtrahierenAction));
// new
// JMenuItem(StreitgenossenPanel.getInstance().gesamtschuldnerschaftDwbkExtrahierenAction));
// new
// JMenuItem(GebuehrenBerechnungPanel.getInstance().saeumnisGebuehrenAction));
// new
// JMenuItem(GebuehrenBerechnungPanel.getInstance().anerkenntnisGebuehrenAction));
// new
// JMenuItem(GebuehrenBerechnungPanel.getInstance().normaleGebuehrenAction));
// new JMenuItem(ueberAction));
// new JMenuItem(lizenzAnzeigenAktion));
// new JMenu("Kontakt");
// new JMenuItem(emailSchreibenXML));
// new JMenuItem(emailSchreibenAllgemein));
