/*
 * PopUpMenuBuilder.java
 * eu.gronos.kostenrechner.view.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.menus;

import java.util.Arrays;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.ComponentBeschrifter;
import eu.gronos.kostenrechner.controller.KontextMouseListener;
import eu.gronos.kostenrechner.interfaces.HorcherWandelbar;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;

/**
 * Die Klasse baut {@link JPopupMenu}s aus {@link BeschriebeneAktion}en.
 *
 * @author Peter Schuster (setrok)
 * @date 12.08.2019
 *
 */
public class PopupMenuBuilder {

	/**
	 * Die Methode baut ein {@link JPopupMenu} aus {@link BeschriebeneAktion}en.
	 * 
	 * @param beschriftung die {@link Beschriftung} für das Menu selbst und den
	 *                     ersten Eintrag mit dem Titel
	 * @param comp         die {@link JComponent}, {@link JTable} oder
	 *                     {@link JEditorPane}, zu dem das Kontextmenu gehört
	 * @param seperators   ein Array mit den Positionen der Trennstriche
	 * @param listeners    ein varArg aus {@link HorcherWandelbar}, die in der
	 *                     übergegebenen Reihenfolge MenuItems des Kontextmenü
	 *                     werden sollen.
	 * @return ein {@link JPopupMenu}
	 */ // BeschriebeneAktion... actions {@link BeschriebeneAktion}
	public JPopupMenu build(Beschriftung beschriftung, JComponent comp, Integer[] seperators,
			HorcherWandelbar... listeners) {
		JPopupMenu pop = new JPopupMenu(beschriftung.getTitle());
		final JMenuItem menuItem = new JMenuItem();
		if (beschriftung == null || beschriftung.getTitle() == null) {
			System.out.println("Beschriftung null!");
		}
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		//.applyTo
		//beschriftung.applyTo(, beschrifter);
		beschrifter.beschrifte(pop, beschriftung);
		beschrifter.beschrifte(menuItem, beschriftung);
		pop.add(menuItem);
		for (int index = 0; index < listeners.length; index++) {
			if (Arrays.asList(seperators).contains(Integer.valueOf(index + 1)))
				pop.addSeparator();
			// BeschriebeneAktion action = listeners[index];
			HorcherWandelbar listener = listeners[index];
			pop.add(listener.toMenuItem());
			// action.toMenuItem());
			if (comp.getActionMap() != null && listener instanceof BeschriebeneAktion) {
				BeschriebeneAktion action = (BeschriebeneAktion) listener;
				final LangBeschriftung langBeschriftung = action.getBeschriftung();
				final String actionCommandKey = langBeschriftung.getActionCommandKey();
				comp.getActionMap().put(actionCommandKey, action);
				if (comp.getInputMap() != null && langBeschriftung.getAcceleratorKey() != null) {
					comp.getInputMap().put(langBeschriftung.getAcceleratorKey().toKeyStroke(), actionCommandKey);
				}
			} else
				System.out.println("ActionMap ist null!");
		}
		/* MouseListener listener, */// listener);
		if (comp instanceof JTable)
			comp.addMouseListener(new KontextMouseListener((JTable) comp, pop));
		else
			comp.addMouseListener(new KontextMouseListener(pop));
		// printActionMap(comp);
		// System.out.println(new AllesBeschrifter().beschreibeComponents(pop));
		return pop;
	}

	public void printActionMap(JComponent comp) {
		if (comp.getActionMap() != null) {
			ActionMap map = comp.getActionMap();
			for (Object o : map.allKeys()) {
				Action a = map.get(o);
				// LangBeschriftung b = NameContainerMap.buildFrom(a);
				System.out.println(String.format("Key: %s; Action: %s", o.toString(), a.toString()));
			}
		}
	}

}