/**
 * FontUndFensterHelfer.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.result;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

import eu.gronos.kostenrechner.view.FontHelfer;

/**
 * Die Klasse erweitert {@link FontHelfer} um Abfragen aus einem {@link Window}.
 * Das ist die gemeinsame Oberklasse für {@link JFrame} und {@link JDialog}. Man
 * kann Fonts suchen und die Fenstergröße nach Schriftgröße setzen.
 *
 * @author Peter Schuster (setrok)
 * @date 15.08.2018
 *
 */
public class FontHelferForWindow extends FontHelfer {
//	private final JDialog dialog;
	private final Window window;

	/**
	 * Der Konstruktor braucht den {@link JDialog}, um daran die Größe usw. setzen
	 * zu können.
	 * 
	 */
	public FontHelferForWindow(Window window) {
		// JDialog dialog
		this.window = window;
	}

	/**
	 * Die Methode ermittelt die bevorzugte Größe des {@link JDialog}s, indem die
	 * Größe der Ränder hinzugerechnet wird.
	 * 
	 * @param insets {@link Insets} des {@link JDialog}s
	 * @return eine {@link java.awt.Dimension} mit der vergrößerten bevorzugten
	 *         Größe
	 * 
	 * @see java.awt.Container#getPreferredSize()
	 * @see java.awt.Container#getMinimumSize()
	 */
	public Dimension calculatePreferredSizeWith(Insets insets) {
		final Dimension minimum = window.getMinimumSize();// super
		final Dimension preferred = window.getPreferredSize();// super
		return calculatePreferredSizeWith(insets, minimum, preferred);
//		Dimension ps = new Dimension();
//		ps.setSize(width + rand, height + rand);//ps;
	}

	/**
	 * Zusehen, dass das Fenster nicht breiter als maxSpalten Zeichen und nicht
	 * höher als maxZeilen Zeilen wird.
	 * 
	 * @param attrib     ein {@link AttributeSet}
	 * @param maxSpalten Spaltenzahl für die Berechnung
	 * @param maxZeilen  Zeilenanzahl für die Berechnung
	 */
	public void setPreferredSizeFromAttributeSet(AttributeSet attrib, int maxSpalten, int maxZeilen) {
		Dimension maximumSize = window.getMaximumSize();
		Dimension preferredSize = window.getPreferredSize();
		calculatePreferredSizeFrom(maxSpalten, maxZeilen, getCharDimension(attrib), maximumSize, preferredSize);
		window.setPreferredSize(preferredSize);
	}

	/**
	 * Die Methode definiert erstmal den grundlegenden Style ("base"), wobei diese
	 * direkt ins übergebene {@link StyledDocument} geschrieben werden. Zusätzlich
	 * wird der Style noch zurückgegeben.
	 * 
	 * @param doc ein {@link StyledDocument}
	 * @return ein {@link Style} mit den grundlegenden Formatierungen
	 * @see #createBaseStyle(StyledDocument)
	 */
	// public Style createBaseStyle(StyledDocument doc) {
	// return createBaseStyle(doc, baseFont());
	// }
	// final Font font = window.getFont();
	// setFontSize(baseStyle);

	/**
	 * Die Methode ermittelt den Standard-{@link Font} des {@link #window}
	 * 
	 * @return den {@link Component#getFont()} als {@link Font}
	 */
	public Font baseFont() {
		return window.getFont();
	}

	/**
	 * Die Methode dient dazu, die Breite eines Zeichens ('n') und die
	 * Standardzeilenhöhe zu ermitteln
	 * 
	 * @param attrib ein {@link AttributeSet}
	 * @return Zeichenbreite und Zeilenhöhe in Pixeln als {@link Dimension}
	 */
	private Dimension getCharDimension(AttributeSet attrib) {
		FontMetrics fontMetrics = window.getFontMetrics(getFontForName(StyleConstants.getFontFamily(attrib)));
		return getCharDimension(fontMetrics);
	}
}
