/**
 * NachkommastellenRenderer.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.result;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

import eu.gronos.kostenrechner.view.KostenTableRenderer;

/**
 * Ein Renderer, der alle Double-Werte mit zwei Nachkommastellen darstellt.
 *
 * @author Peter Schuster (setrok)
 * @date 20.10.2014
 *
 */
public class NachkommastellenRenderer extends KostenTableRenderer implements TableCellRenderer {

	private static final long serialVersionUID = 3549827829628144504L;
	private final String format;// = "%,.2f";

	/**
	 * Konstruktor mit Formatierungsstring
	 * 
	 * @param format
	 *            Der Formatierungs-String für
	 *            {@link String#format(String, Object...)}, z.B. "%,.2f"
	 */
	NachkommastellenRenderer(String format) {
		super();
		this.format = format;
	}
	
	/**
	 * Konstruktor ohne Formatierungsstring, formatiert alles mit "%,.2f"
	 * 
	 */
	public NachkommastellenRenderer() {
		this("%,.2f");
	}

	@Override
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		if (value != null)
			if (value instanceof Double) {
				setText(String.format(format, value));
			} else if (value instanceof Number) {
				final double doubleValue = ((Number) value).doubleValue();
				setText(String.format(format, doubleValue));
			} else
				setText(value.toString());
		else
			setText("");
		setHorizontalAlignment(SwingConstants.RIGHT);
		setSelected(isSelected);
		if (table.isPaintingForPrint()) {
			setText(getText() + "\t ");
		}
		return this;
	}

//	if (isSelected) {
//		/*
//		 * Wenn die Zeile ausgewählt ist, müssen die Farben entsprechend
//		 * gesetzt werden.
//		 */
//		setBackground(table.getSelectionBackground());
//		setForeground(table.getSelectionForeground());
//		setOpaque(true);
//	} else {/* sonst nicht */
//		setBackground(table.getBackground());
//		setForeground(table.getForeground());
//	}
}
