/**
 * TenorDialog.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.result;

import java.awt.GridBagConstraints;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.TenorBegruendungAction;
import eu.gronos.kostenrechner.controller.TenorierendAdapter;
import eu.gronos.kostenrechner.controller.files.RtfWerkzeugKasten;
import eu.gronos.kostenrechner.controller.files.RtfZwischenablageAction;
import eu.gronos.kostenrechner.controller.files.SpeichereRtfAction;
import eu.gronos.kostenrechner.controller.system.BooleanConfigOptionHorcher;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.controller.system.PreferencesConfigOption;
import eu.gronos.kostenrechner.controller.system.SchreibeEmailTenorFalsch;
import eu.gronos.kostenrechner.interfaces.Begruendend;
import eu.gronos.kostenrechner.interfaces.Tenorierend;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.beschriftungen.SchluesselBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.view.FontHelfer;
import eu.gronos.kostenrechner.view.GitterBeutelBeschraenkungen;
import eu.gronos.kostenrechner.view.KostenJDialog;
import eu.gronos.kostenrechner.view.menus.PopupMenuBuilder;

/**
 * Ein JDialog, der einen Tenor anzeigt und diesen auf Wunsch als RTF speichert
 * und diesen auch in die Zwischenablage kopieren kann.
 * 
 * @author Peter Schuster (setrok)
 * @date 15.06.2014
 */
public class TenorDialog extends /* HinzufuegenDialog<Void> */ KostenJDialog {

	private static final long serialVersionUID = -7570808761464484864L;
	private JScrollPane scpKostentenor;
	JTextPane textPane;
	Tenorierend tenorierend;
	final VerfahrensDatenContainer container;
	// private RtfDocHelper docHelper;
	private final FontHelferForWindow helper = new FontHelferForWindow(this);
	private final AbstractAction tenorInZwischenablage = new RtfZwischenablageAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71011));

	private final AbstractAction tenorSpeichern;
	private final AbstractAction begruendungEinfuegen = new TenorBegruendungAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71041));
	private BooleanConfigOptionHorcher liXml = new BooleanConfigOptionHorcher(
			(SchluesselBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71051));
	// new BooleanConfigSchluessel("xmlTenor", false),
	// (LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71051));
	private final AbstractAction emailSchreibenTenorFalsch;

	/**
	 * bereitsGruendeDa speichert, ob die Begründung bereits eingefügt wurde, als
	 * boolean
	 */
	private boolean bereitsGruendeDa = false;
	// private JCheckBoxMenuItem miXml;
	private final RtfWerkzeugKasten kit = new RtfWerkzeugKasten();

	/**
	 * Der Konstruktor verwendet statt eines {@link Tenorierend} jetzt einen
	 * {@link TenorDatenContainer}.
	 * 
	 * @param owner               der JFrame, der den JDialog aufruft
	 * @param tenorDatenContainer der {@link TenorDatenContainer} mit den Daten für
	 *                            den Tenor
	 * @param container           ein VerfahrensDatenContainer
	 */
	public TenorDialog(JFrame owner, TenorDatenContainer container) {
		super(owner,
				((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71000)).setTitle(container.berechnungsTyp));
		this.tenorierend = new TenorierendAdapter(container);
		this.container = container;
		// super.setOkButtonToBeFocussed(true);
		emailSchreibenTenorFalsch = new SchreibeEmailTenorFalsch(
				(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71031), container);

		tenorSpeichern = new SpeichereRtfAction(this, container,
				(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71021));

	}

	/*
	 * Die Methode holt das StyledDocument aus der JTextPane
	 * 
	 * @return the model public StyledDocument getDocument() { return
	 * txtpnKostentenor.getStyledDocument(); }
	 */

	/**
	 * Die Methode dient dazu, an den Tenortext Gründe anzuhängen, falls es sich
	 * beim {@link #tenorierend} um ein {@link Begruendend} handelt und die Gründe
	 * nicht bereits angehängt wurden.
	 * 
	 */
	public void setBegruendungText() {
		if (tenorierend instanceof Begruendend && !bereitsGruendeDa) {
			final String gruende = ((Begruendend) tenorierend).getGruende();
			try {
				// DefaultStyledDocument doc = (DefaultStyledDocument) kit.getDocument();

				int caret = textPane.getCaretPosition();

				kit.insertString(gruende, tenorierend, textPane.getPreferredSize());
				Kostenrechner.getLogger().info(String.format("caret: %04d; ", caret));

				textPane.setCaretPosition(caret);
				bereitsGruendeDa = true;
			} catch (BadLocationException ble) {
				FehlerHelper.zeigeFehler(ble.getLocalizedMessage(), ble);
			}
		}
	}
	// createDefaultDocument();
	// getDocument();
	// doc, doc.getStyle("base"),
	// if (istTenorierendTabulierend()) {
	// createTableStyle(doc, doc.getStyle("base"));
	// }
	// int nachUeberschrift =
//				int anfang = doc.getLength();
//				doc.insertString(anfang, TenorTexter.GRUENDE_UEBERSCHRIFT, doc.getStyle("bold"));
//				
//				int nachUeberschrift = doc.getLength();
//				doc.insertString(nachUeberschrift, gruende, doc.getStyle("base"));
	// Kostenrechner.getLogger().info(
	// String.format("caret: %04d; doc.Length()-anfang: %04d", caret,
	// (doc.getLength() - anfang)));

	/**
	 * @return gibt {@link #docHelper} als {@link RtfDocHelper} zurück.
	 */
	public RtfWerkzeugKasten getKit() {
		return kit;
	}

	/*
	 * @param kit d. {@link #kit}, d. gesetzt werden soll als {@link
	 * RtfWerkzeugKasten}
	 */
	// public void setDocHelper(RtfWerkzeugKasten kit) {
	// this.kit = kit;
	// }

	/**
	 * Die Methode dient dazu, {@link SpeichereRtfAction} mitzuteilen, ob
	 * strukturierte Tenordaten zusätzlich zu der RTF-Datei gespeichert werden
	 * sollen. soll {@link Kostenrechner#debug} durch
	 * {@link PreferencesConfigOption} ersetzen.
	 * 
	 * @return true, wenn {@link JCheckBoxMenuItem#isSelected()}
	 */
	public boolean isXmlSelected() {
		if (liXml != null)
			return liXml.getValue();
		else
			return false;
	}
//		if (miXml != null)
//			return miXml.isSelected();
//		else
//			return false;

	/**
	 * Die Methode fuellt das ContentPane mit einer {@link JTextPane} für den
	 * Tenortext des {@link Begruendend} in einer {@link JScrollPane}. Zudem setzt
	 * sie ein paar mehr {@link JButton Schaltflächen}
	 * 
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#fuelleContentPane()
	 */
	@Override
	protected void fuelleContentPane() {
		textPane = (JTextPane) beschrifter.beschrifte(new JTextPane(), NameContainerSammlung.BESCHRIFTUNGEN.get(71111));
		textPane.setEditorKit(getKit());

		scpKostentenor = (JScrollPane) beschrifter.beschrifte(new JScrollPane(textPane),
				NameContainerSammlung.BESCHRIFTUNGEN.get(71110));
		contentPanel.add(scpKostentenor,
				GitterBeutelBeschraenkungen.getInstance(0, 0, 3, 1, GridBagConstraints.BOTH, true));

		getButtonPane().add(((BeschriebeneAktion) tenorInZwischenablage).toButton());
		addToRootInputMap(tenorInZwischenablage);
		getButtonPane().add(((BeschriebeneAktion) tenorSpeichern).toButton());
		addToRootInputMap(tenorSpeichern);
		getButtonPane().add(((BeschriebeneAktion) emailSchreibenTenorFalsch).toButton());
		addToRootInputMap(emailSchreibenTenorFalsch);

		DefaultStyledDocument doc = setKostentenorText();
		helper.setPreferredSizeFromAttributeSet(doc.getStyle("base"), FontHelfer.MAX_SPALTEN, FontHelfer.MAX_ZEILEN);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

		new PopupMenuBuilder().build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71050), textPane,
				new Integer[] { 1 }, (BeschriebeneAktion) tenorSpeichern, liXml,
				(BeschriebeneAktion) tenorInZwischenablage, (BeschriebeneAktion) begruendungEinfuegen);
		/*
		 * Das Einfügen von Begründungen geht nur bei Klassen, die UrteilsTenorierend
		 * implementieren; sonst fehlt die entsprechende Methode
		 */
		if (tenorierend instanceof Begruendend)
			begruendungEinfuegen.setEnabled(true);
		else
			begruendungEinfuegen.setEnabled(false);
	}

	// txtpnKostentenor.setEditorKit(getKit());
	// new RTFEditorKit());
	// txtpnKostentenor.setEditable(false);

	//kit.install(textPane);
	// setDocHelper(new RtfDocHelper((RTFEditorKit) txtpnKostentenor.getEditorKit(),
	// getDocument()));

	/**
	 * Die Methode setKostentenorText dient dazu, den Tenor der übergegebenen
	 * Tenorklasse im JTextPane mit der passenden Schriftart und Formatierungen zu
	 * setzen. Als Dialogtitel wird die Tenorbeschreibung des Tenorierend gesetzt.
	 * 
	 * @param tenorierend die Tenor erzeugende Klasseninstanz, die "Tenorierend"
	 *                    implementiert.
	 * 
	 * @see javax.swing.text.Document#insertString(int,String,AttributeSet)
	 */
	private DefaultStyledDocument setKostentenorText() {
		final String tenor = tenorierend.erzeugeTenor();
		DefaultStyledDocument doc = kit.getDefaultStyledDocument();
		// Beschreibung vom "Tenorierend" holen
		try {

			//kit.createStyles();
			kit.insertString(tenor, tenorierend.getTenorBeschreibung(), !(tenorierend instanceof Begruendend));

		} catch (BadLocationException ble) {
			FehlerHelper.zeigeFehler(ble.getLocalizedMessage(), ble);
			return null;
		}
		return doc;
	}

}
// (DefaultStyledDocument) getDocument();
// kit.createDefaultDocument(txtpnKostentenor);
// (DefaultStyledDocument) kit.getDocument();
// doc.remove(0, doc.getLength());
// doc.insertString(0, tenor, doc.getStyle("base"));
// // Die Beschreibung auch beim Speichern als Titel setzen
// doc.putProperty(Document.TitleProperty, tenorierend.getTenorBeschreibung());
// hier war die Stelle Style baseStyle =
// kit.applyStyles(helper, textPane, !(tenorierend instanceof Begruendend));

/* , Style style */

// range[0], range[1]
// range[0] + 1, range[1]
// range[0]
// int[]// range[1] - range[0];

/*
 * @return true, sofern das übergebene {@link Tenorierend} auch das Interface
 * {@link Tabulierend} implementiert
 */
// private boolean istTenorierendTabulierend() {
// return tenorierend instanceof Tabulierend;
// }
// private static final String POPUPLABEL_TENORTEXT = "Tenortext...";
//			"Tenor in Zwischenablage kopieren", "Kopiert den gesamten Tenortext in die Zwischenablage.", 
//			"copy", 
//			"Fügt die hinterlegte Begründung für den generierten Tenor an.", "Begründung hinzufügen",
//	= new SpeichereRtfAction(this, tenorDatenContainer, "Tenor speichern", "Speichert den Tenortext im Rich Text Format (RTF)", KeyEvent.VK_S, "save", KeyStroke.getKeyStroke(KeyEvent.VK_S, Kostenrechner.ctrlMask)); 
//				"Tenor falsch","e-mail", 
//				"<html>Öffnet den Standard-E-Mail-Programm,<br>um eine E-Mail an den Programmierer zu verfassen</html>",
//				"Tenor speichern", "Speichert den Tenortext im Rich Text Format (RTF)", "save",
// tenorDatenContainer, this. KeyEvent.VK_E,
// , KeyEvent.VK_S,KeyStroke.getKeyStroke(KeyEvent.VK_S, Kostenrechner.ctrlMask)
// , VerfahrensDatenContainer container
// tenorDatenContainer tenorDatenContainer
// new JMenuItem(tenorSpeichern));
// new JMenuItem(tenorInZwischenablage));
// new JMenuItem(begruendungEinfuegen));
//				new JCheckBoxMenuItem("Strukturierte XML-Daten mit Tenor speichern", false);
//		miXml.setToolTipText("Wenn Sie den Tenor speichern, speichere ich strukturierte XML-Daten mit.");
// txtpnKostentenor.setContentType("text/rtf; charset=8859_1");
// new JButton(tenorInZwischenablage)
// new JButton(tenorSpeichern)
// new JButton(emailSchreibenTenorFalsch));
// miXml.setMnemonic(KeyEvent.VK_X);
// new JPopupMenu(POPUPLABEL_TENORTEXT);
// pmTenortext.add(new JMenuItem(POPUPLABEL_TENORTEXT));
// pmTenortext.addSeparator();
// pmTenortext.add(((BeschriebeneAktion) tenorSpeichern).toMenuItem());
// pmTenortext.add(((BeschriebeneAktion) tenorInZwischenablage).toMenuItem());
// pmTenortext.add(((BeschriebeneAktion) begruendungEinfuegen).toMenuItem());
// txtpnKostentenor.addMouseListener(new KontextMouseListener(pmTenortext));

/*
 * Die Methode dient der Kompatibilität zur Oberklasse und tut nichts.
 * 
 * @return null
 * 
 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
 */
//@Override
//protected Void baueRueckgabewert() {
//	return null;
//}

/*
 * Die Methode dient der Kompatibilität zur Oberklasse und liefert immer true
 * 
 * @return true
 * 
 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#parseEingabe()
 */
//@Override
//public boolean parseEingabe() {
//	return true;
//}
// container.berechnungsTyp
// tenorDatenContainer// tenorDatenContainer
// miXml = (JCheckBoxMenuItem)
// NameContainerSammlung.BESCHRIFTUNGEN.get(71051).applyTo(new
// JCheckBoxMenuItem());
// miXml.addItemListener(new BooleanConfigOptionHorcher("xmlTenor", false,
// miXml));
// JPopupMenu pmTenortext =
// miXml = (JCheckBoxMenuItem) liXml.getButton();
// miXml = (JCheckBoxMenuItem) liXml.toMenuItem();
// pmTenortext.add(miXml);