/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.beschriftungen.model;

import eu.gronos.beschriftungen.model.VKAdapter;
import eu.gronos.kostenrechner.Kostenrechner;
import javax.swing.KeyStroke;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class TastenKombination {
    private boolean altModifier = false;
    private boolean ctrlModifier = false;
    private boolean shiftModifier = false;
    private Integer keyCode = 0;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TastenKombination [");
        builder.append("keyCode=");
        builder.append(this.keyCode);
        if (this.shiftModifier) {
            builder.append(", shiftModifier");
        }
        if (this.ctrlModifier) {
            builder.append(", ctrlModifier");
        }
        if (this.altModifier) {
            builder.append(", altModifier");
        }
        builder.append("]");
        return builder.toString();
    }

    public void setAllModifiers(int modifiers) {
        if ((modifiers & 0x40) != 0) {
            this.setShiftModifier(true);
        } else {
            this.setShiftModifier(false);
        }
        if ((modifiers & 0x80) != 0 || (modifiers & 0x100) != 0) {
            this.setCtrlModifier(true);
        } else {
            this.setCtrlModifier(false);
        }
        if ((modifiers & 0x200) != 0) {
            this.setAltModifier(true);
        } else {
            this.setAltModifier(false);
        }
    }

    public int modifierIntValue() {
        int ctrlMask = Kostenrechner.ctrlMask;
        if (ctrlMask == 2) {
            ctrlMask = 128;
        }
        int modifiers = 0;
        if (this.isShiftModifier()) {
            modifiers += 64;
        }
        if (this.isCtrlModifier()) {
            modifiers += ctrlMask;
        }
        if (this.isAltModifier()) {
            modifiers += 512;
        }
        return modifiers;
    }

    public KeyStroke toKeyStroke() {
        return KeyStroke.getKeyStroke(this.getKeyCode(), this.modifierIntValue());
    }

    public boolean hasKeyCode() {
        return this.getKeyCode() != 0;
    }

    @XmlAttribute(name="taste")
    @XmlJavaTypeAdapter(value=VKAdapter.class)
    public Integer getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(Integer keyCode) {
        this.keyCode = keyCode;
    }

    @XmlAttribute(name="shift")
    public boolean isShiftModifier() {
        return this.shiftModifier;
    }

    public void setShiftModifier(boolean shiftModifier) {
        this.shiftModifier = shiftModifier;
    }

    @XmlAttribute(name="ctrl")
    public boolean isCtrlModifier() {
        return this.ctrlModifier;
    }

    public void setCtrlModifier(boolean ctrlModifier) {
        this.ctrlModifier = ctrlModifier;
    }

    @XmlAttribute(name="alt")
    public boolean isAltModifier() {
        return this.altModifier;
    }

    public void setAltModifier(boolean altModifier) {
        this.altModifier = altModifier;
    }
}

