/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.beschriftungen.view;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeiFocusMarkierenHorcher;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.controller.DialogFensterSchliessenHorcher;
import eu.gronos.beschriftungen.controller.HinzufuegenAbbrechenAction;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.LangVorsorgeBeschriftung;
import eu.gronos.beschriftungen.model.NameContainer;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.view.FontHelferForWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.WindowAdapter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public abstract class BeschrifteterJDialog
extends JDialog {
    private static final long serialVersionUID = -520050986950014909L;
    private final BeschriebeneAktion cancelAction = new HinzufuegenAbbrechenAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(76061));
    protected final WindowAdapter fensterSchliesser = new DialogFensterSchliessenHorcher(this);
    public static final FocusAdapter BEI_FOCUS_MARKIEREN = new BeiFocusMarkierenHorcher();
    protected static final EmptyBorder BORDER = new EmptyBorder(5, 5, 5, 5);
    protected final FontHelferForWindow fufhelfer = new FontHelferForWindow(this);
    protected final JPanel contentPanel = new JPanel();
    private JPanel buttonPane;
    private final Beschriftung beschriftung;
    protected final ComponentBeschrifter beschrifter = new ComponentBeschrifter();

    public BeschrifteterJDialog(Window owner, Beschriftung beschriftung) {
        super(owner);
        this.beschriftung = beschriftung;
        this.beschrifter.beschrifte(this, beschriftung);
        this.setContentPanel();
        this.setButtonPane();
        super.setModal(true);
    }

    @Override
    public void pack() {
        this.setLocationByPlatform(true);
        this.setSize(this.fufhelfer.calculatePreferredSizeWith(BORDER.getBorderInsets()));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.fensterSchliesser);
        super.pack();
    }

    public void showDialog() {
        this.fuelleContentPane();
        this.pack();
        this.setVisible(true);
    }

    public void fensterSchliessenBeiAbbruch() {
        this.setVisible(false);
        this.dispose();
    }

    public Beschriftung getBeschriftung() {
        return this.beschriftung;
    }

    public BeschriebeneAktion getCancelAction() {
        return this.cancelAction;
    }

    public JPanel getButtonPane() {
        return this.buttonPane;
    }

    protected Component toContentPanel(Component das, NameContainer damit) {
        return this.beschrifter.beschrifteVergittert(das, damit, this.contentPanel);
    }

    protected Component togetherToContentPanel(Component das, UnBeschriftung damit) {
        return this.beschrifter.beschrifteGemeinsam(das, damit, this.contentPanel);
    }

    protected Component toContentPanel(JLabel dasLabel, Component das, UnBeschriftung damit) {
        return this.beschrifter.beschrifteGemeinsam(dasLabel, das, damit, this.contentPanel);
    }

    protected Component toButtonPanel(BeschriebeneAktion das) {
        this.addToRootInputMap(das);
        return this.beschrifter.add(das, (Container)this.buttonPane);
    }

    protected void setButtonPane() {
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)this.buttonPane, "South");
        JButton cancelButton = this.getCancelAction().toButton();
        this.changeCancelBeschriftung(1);
        this.buttonPane.add(cancelButton);
        this.addToRootInputMap(this.getCancelAction());
        this.getRootPane().setDefaultButton(cancelButton);
    }

    protected void changeCancelBeschriftung(int index) {
        LangVorsorgeBeschriftung beschriftung = (LangVorsorgeBeschriftung)this.getCancelAction().getBeschriftung();
        this.beschrifter.changeTo(beschriftung, index);
        this.beschrifter.beschrifte(this.getCancelAction(), beschriftung);
    }

    protected abstract void fuelleContentPane();

    protected void setContentPanel() {
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        this.contentPanel.setBorder(BORDER);
        this.contentPanel.setLayout(gbl_contentPanel);
        this.getContentPane().add((Component)this.contentPanel, "Center");
    }

    protected void addToRootInputMap(Action action) {
        JRootPane rp = this.getRootPane();
        rp.getActionMap().put(action.getValue("ActionCommandKey"), action);
        rp.getInputMap(2).put((KeyStroke)action.getValue("AcceleratorKey"), action.getValue("ActionCommandKey"));
    }

    protected void removeFromInputMap(Action action) {
        JRootPane rp = this.getRootPane();
        rp.getInputMap(2).remove((KeyStroke)action.getValue("AcceleratorKey"));
        rp.getActionMap().remove(action.getValue("ActionCommandKey"));
    }

    protected void caretVisible(JTextComponent textComponent) {
        textComponent.getCaret().setVisible(true);
    }

    protected void setEnterAction(JTextField field, AbstractAction action) {
        if (action != null) {
            field.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), action.getValue("ActionCommandKey"));
            field.getActionMap().put(action.getValue("ActionCommandKey"), action);
        }
        field.setHorizontalAlignment(4);
        field.addFocusListener(BEI_FOCUS_MARKIEREN);
    }
}

