/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.view.RechnerhammerIcons;
import java.awt.Component;
import java.awt.HeadlessException;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public abstract class KleinDialogAction
extends BeschriebeneAktion
implements AbfrageLieferant<JDialog> {
    private static final long serialVersionUID = -5606764523838104402L;
    private JDialog dialog = null;

    public KleinDialogAction(LangBeschriftung beschriftung) {
        super(beschriftung);
    }

    @Override
    public JDialog getDialog() {
        return this.dialog;
    }

    protected int showDialog(Beschriftung beschriftung, String message, int optionType, int messageType) {
        JOptionPane pane = this.createPane(Kostenrechner.getInstance(), message, optionType, messageType, RechnerhammerIcons.getRechnerhammer64());
        this.setDialog(this.createDialog(Kostenrechner.getInstance(), pane, beschriftung));
        int antwort = this.show(pane, this.getDialog());
        this.setDialog(null);
        return antwort;
    }

    protected void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    private JDialog createDialog(Component parentComponent, JOptionPane pane, Beschriftung beschriftung) throws HeadlessException {
        JDialog dialog = pane.createDialog(parentComponent, "");
        ComponentBeschrifter beschrifter = new ComponentBeschrifter();
        beschrifter.beschrifte(dialog, beschriftung);
        pane.selectInitialValue();
        return dialog;
    }

    private JOptionPane createPane(Component parentComponent, String message, int optionType, int messageType, Icon icon) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, null, null);
        pane.setInitialValue(null);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        return pane;
    }

    private int show(JOptionPane pane, JDialog dialog) {
        dialog.setVisible(true);
        dialog.dispose();
        Object value = pane.getValue();
        if (value == null) {
            return -1;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return -1;
    }
}

