/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class KontextMouseListener
implements MouseListener {
    private JPopupMenu kontextMenu;
    private JTable tabelle;

    public KontextMouseListener(JPopupMenu kontextMenu) {
        this.kontextMenu = kontextMenu;
        this.tabelle = null;
    }

    public KontextMouseListener(JTable tabelle, JPopupMenu kontextMenu) {
        this(kontextMenu);
        this.tabelle = tabelle;
        tabelle.setFillsViewportHeight(true);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.mouseReleased(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.mousePressedOrReleased(me);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.mousePressedOrReleased(me);
        }
    }

    private void mousePressedOrReleased(MouseEvent me) {
        int i;
        if (this.tabelle != null && (i = this.tabelle.rowAtPoint(me.getPoint())) > -1) {
            this.tabelle.changeSelection(i, 1, false, false);
        }
        this.kontextMenu.show(me.getComponent(), me.getX(), me.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public JPopupMenu getKontextMenu() {
        return this.kontextMenu;
    }
}

