/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SprungmarkenHorcher
implements HyperlinkListener {
    final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hle) {
        if (hle.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !this.isNull(hle) && !this.interneSprungmarke(hle) && hle.getURL() != null) {
            this.launchBrowser(hle.getURL());
        }
    }

    private boolean isNull(HyperlinkEvent hle) {
        if (hle.getDescription() == null) {
            Kostenrechner.getLogger().info("Keine Linkbeschreibung");
            return true;
        }
        return this.desktop == null;
    }

    private boolean interneSprungmarke(HyperlinkEvent hle) {
        String desc = hle.getDescription();
        if (!desc.startsWith("#")) {
            Kostenrechner.getLogger().info(String.format("Externer Link: %s", desc));
            return false;
        }
        Kostenrechner.getLogger().info(String.format("Interner Link: %s", desc));
        desc = desc.substring(1);
        if (hle.getSource() instanceof JEditorPane) {
            JEditorPane ep = (JEditorPane)hle.getSource();
            ep.scrollToReference(desc);
        } else {
            Kostenrechner.getLogger().info("Kein Editorpane");
        }
        return true;
    }

    private void launchBrowser(URL url) {
        try {
            this.launchBrowser(url.toURI());
            Kostenrechner.getLogger().info(String.format("URL: %s", url.toString()));
        }
        catch (URISyntaxException use) {
            FehlerHelper.zeigeFehler("Der ausgew\u00e4hlte Link enth\u00e4lt einen Syntaxfehler!", use);
            use.printStackTrace();
        }
    }

    private void launchBrowser(URI uri) {
        if (this.desktop != null && this.desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                this.desktop.browse(uri);
            }
            catch (IllegalArgumentException | NullPointerException iae) {
                FehlerHelper.zeigeFehler("URI konnte nicht ge\u00f6ffnet werden oder Link ist NULL", iae);
            }
            catch (SecurityException se) {
                FehlerHelper.zeigeFehler("Sicherheitsverletzung beim Start des Browsers.", se);
            }
            catch (IOException ioe) {
                FehlerHelper.zeigeFehler("Browser konnte nicht gestartet werden. Kein Standardbrowser definiert, definierter Standardbrowser nicht gefunden oder das System konnte ihn nicht starten.", ioe);
            }
            catch (Exception e) {
                FehlerHelper.zeigeFehler("Sonstiger Fehler beim Starten des Browsers", e);
            }
        }
    }
}

