/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.XmlTransferHandler;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.view.result.TenorDialog;
import java.awt.event.ActionEvent;

public abstract class TenorAction
extends BeschriebeneAktion
implements AbfrageLieferant<TenorDialog> {
    private static final long serialVersionUID = 5202806129481793793L;
    private TenorDialog dialog = null;

    public TenorAction(LangBeschriftung beschriftung) {
        super(beschriftung);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            this.allesOk();
            VerfahrensDatenContainer container = new XmlTransferHandler().liesAlleWertefuerContainer();
            TenorDatenContainer tenorDaten = this.tenorDaten(container);
            this.setDialog(new TenorDialog(Kostenrechner.getInstance(), tenorDaten)).showDialog();
            this.setDialog(null);
        }
        catch (NumberFormatException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public TenorDialog getDialog() {
        return this.dialog;
    }

    protected abstract boolean allesOk() throws IllegalArgumentException;

    protected abstract TenorDatenContainer tenorDaten(VerfahrensDatenContainer var1) throws IllegalArgumentException;

    private TenorDialog setDialog(TenorDialog dialog) {
        this.dialog = dialog;
        return dialog;
    }
}

