/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenAssistentParser;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.view.baumbach.BaumbachAssistentDialog;
import java.awt.event.ActionEvent;

public class AssistentWeiterAction
extends BeschriebeneAktion {
    private final BaumbachAssistentDialog dialog;
    private StreitgenossenAssistentParser pruefer;
    private static final long serialVersionUID = -1432886554037727631L;

    public AssistentWeiterAction(BaumbachAssistentDialog dialog, LangBeschriftung beschriftung, ParsendUndBauend<Streitgenossen> pruefer) {
        super(beschriftung);
        this.dialog = dialog;
        this.pruefer = (StreitgenossenAssistentParser)pruefer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.parseEingabe(this.pruefer.getZustand())) {
            return;
        }
        if (this.pruefer.getZustand() >= this.pruefer.getHoechsterZustand() - 1) {
            this.dialog.performOkAction(e);
        } else {
            this.pruefer.setZustand(this.pruefer.getZustand() + 1);
            Kostenrechner.getLogger().info(String.format("Zustand: %d, \u00fcberspringbar: %s!%n", this.pruefer.getZustand(), this.pruefer.isUeberspringbar(this.pruefer.getZustand())));
            while (this.pruefer.isUeberspringbar(this.pruefer.getZustand())) {
                this.pruefer.setZustand(this.pruefer.getZustand() + 1);
            }
            this.pruefer.setzeWerte(this.pruefer.getZustand());
            this.dialog.zustandAnzeigen(this.pruefer.getZustand());
            if (this.pruefer.focusComponent != null) {
                this.pruefer.focusComponent.requestFocusInWindow();
                this.pruefer.focusComponent.requestFocus();
            }
        }
    }

    public boolean parseEingabe(int tab) {
        boolean boole = false;
        this.pruefer.leseComponents(this.dialog.getComponents());
        try {
            boole = this.pruefer.parseEingabe(tab);
        }
        catch (IllegalArgumentException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
            boole = false;
        }
        catch (NullPointerException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
            boole = false;
        }
        return boole;
    }
}

