/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.util.baumbach.BeteiligtenPruefer;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

public class BeteiligtenParser
implements ParsendUndBauend<BaumbachBeteiligter> {
    private BaumbachBeteiligter rueckgabewert;
    private JComboBox<Beteiligter> cmbTypGenusNumerus;
    private JCheckBox cbAnWiderklageBeteiligt;
    private JFormattedTextField ftfUnterliegen;
    private JFormattedTextField ftfStreitwert;

    @Override
    public ParsendUndBauend<BaumbachBeteiligter> leseComponents(Component ... components) {
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                JComponent component = (JComponent)comp;
                if ("35005".equals(component.getName())) {
                    this.cmbTypGenusNumerus = (JComboBox)component;
                } else if ("35011".equals(component.getName())) {
                    this.cbAnWiderklageBeteiligt = (JCheckBox)component;
                } else if ("35035".equals(component.getName())) {
                    this.ftfUnterliegen = (JFormattedTextField)component;
                } else if ("35025".equals(component.getName())) {
                    this.ftfStreitwert = (JFormattedTextField)component;
                } else {
                    System.out.println("Komisch: " + component.getName());
                }
                ++n2;
            }
        }
        return this;
    }

    @Override
    public boolean parseEingabe() {
        try {
            this.rueckgabewert = this.leseFelder();
            return this.parseEingabe(this.rueckgabewert);
        }
        catch (IllegalArgumentException | NullPointerException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
    }

    @Override
    public boolean parseEingabe(BaumbachBeteiligter beteiligter) throws IllegalArgumentException, NullPointerException {
        this.rueckgabewert = beteiligter;
        return new BeteiligtenPruefer().pruefeEingabe(this.rueckgabewert);
    }

    @Override
    public BaumbachBeteiligter getRueckgabewert() {
        return this.rueckgabewert;
    }

    private BaumbachBeteiligter leseFelder() throws IllegalArgumentException, NullPointerException {
        boolean anWiderklageBeteiligt = this.cbAnWiderklageBeteiligt.isVisible() && this.cbAnWiderklageBeteiligt.isSelected();
        double unterliegen = new NumberExtractor(this.ftfUnterliegen, this.ftfUnterliegen.getAccessibleContext().getAccessibleName()).extractDouble();
        double streitwert = new NumberExtractor(this.ftfStreitwert, this.ftfStreitwert.getAccessibleContext().getAccessibleName()).extractDouble();
        this.rueckgabewert = new BaumbachBeteiligter(this.getSelectedItem(), Euro.ofEuros(streitwert), Euro.ofEuros(unterliegen), anWiderklageBeteiligt);
        return this.rueckgabewert;
    }

    private Beteiligter getSelectedItem() {
        return (Beteiligter)this.cmbTypGenusNumerus.getModel().getElementAt(this.cmbTypGenusNumerus.getSelectedIndex());
    }
}

