/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenListModel;
import eu.gronos.kostenrechner.util.baumbach.GesamtschuldPruefer;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JList;

public class GesamtschuldParser
implements ParsendUndBauend<BaumbachGesamtschuldnerschaft> {
    private BaumbachGesamtschuldnerschaft rueckgabewert;
    private JList<BaumbachBeteiligter> beteiligtenAuswahlListe;
    private JFormattedTextField ftfUnterliegen;
    private BaumbachBeteiligtenListe baumbachBeteiligtenListe;

    @Override
    public ParsendUndBauend<BaumbachGesamtschuldnerschaft> leseComponents(Component ... components) {
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                JComponent component = (JComponent)comp;
                if ("36011".equals(component.getName())) {
                    this.beteiligtenAuswahlListe = (JList)component;
                    this.baumbachBeteiligtenListe = ((BeteiligtenListModel)this.beteiligtenAuswahlListe.getModel()).getValues();
                } else if ("36025".equals(component.getName())) {
                    this.ftfUnterliegen = (JFormattedTextField)component;
                }
                ++n2;
            }
        }
        return this;
    }

    @Override
    public boolean parseEingabe() {
        try {
            this.rueckgabewert = this.leseFelder();
            return this.parseEingabe(this.rueckgabewert);
        }
        catch (IllegalArgumentException | NullPointerException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
    }

    @Override
    public boolean parseEingabe(BaumbachGesamtschuldnerschaft gesamtschuld) throws IllegalArgumentException, NullPointerException {
        this.rueckgabewert = gesamtschuld;
        return new GesamtschuldPruefer().pruefeEingabe(this.rueckgabewert);
    }

    @Override
    public BaumbachGesamtschuldnerschaft getRueckgabewert() {
        return this.rueckgabewert;
    }

    private BaumbachGesamtschuldnerschaft leseFelder() throws IllegalArgumentException, NullPointerException {
        NumberExtractor extractor = new NumberExtractor(this.ftfUnterliegen, this.ftfUnterliegen.getAccessibleContext().getAccessibleName());
        Beteiligter.BeteiligtenTyp typ = this.getLetztenBeteiligten().getTyp();
        if (typ == Beteiligter.BeteiligtenTyp.KLAEGER) {
            typ = Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE;
        }
        int[] indices = this.beteiligtenAuswahlListe.getSelectedIndices();
        Beteiligter.GenusNumerus genusNumerus = this.getLetztenBeteiligten().getGenusNumerus();
        if (genusNumerus.getNumerus() == Beteiligter.GenusNumerus.Numerus.SINGULAR) {
            genusNumerus = Beteiligter.GenusNumerus.of(genusNumerus.getGenus(), Beteiligter.GenusNumerus.Numerus.PLURAL);
        }
        boolean anWiderklageBeteiligt = this.baumbachBeteiligtenListe.enthaeltAnWiderklageBeteiligte() && typ != Beteiligter.BeteiligtenTyp.BEKLAGTE;
        double unterliegen = extractor.extractDouble();
        return new BaumbachGesamtschuldnerschaft(typ, genusNumerus, Euro.ofEuros(unterliegen), anWiderklageBeteiligt, indices, this.baumbachBeteiligtenListe);
    }

    private Beteiligter getLetztenBeteiligten() {
        return this.beteiligtenAuswahlListe.getModel().getElementAt(this.beteiligtenAuswahlListe.getModel().getSize() - 1);
    }
}

