/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenParser;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.baumbach.ProtoBeteiligtenWerte;
import eu.gronos.kostenrechner.model.baumbach.ScalableBeteiligtenTableModel;
import eu.gronos.kostenrechner.view.baumbach.SimpleBeteiligtenTable;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;

public class StreitgenossenAssistentParser
extends StreitgenossenParser {
    private ProtoBeteiligtenWerte primitives;
    private int zustand;
    public static final int HOECHSTER_ZUSTAND_OHNE_WIDERKLAGE = 6;
    public static final int HOECHSTER_ZUSTAND = 11;
    private Streitgenossen rueckgabewert;
    private JSpinner spiKlaegerZahl;
    private JSpinner spiBeklagtenZahl;
    private JTable tabKlaegerGenus;
    private JTable tabBeklagtenGenus;
    private JFormattedTextField ftfBkStreitwert;
    private JTable tabBeklagtenSw;
    private JCheckBox chbBkSwEinheitlich;
    private JList<Beteiligter> liBkGesamtschuldner;
    private JFormattedTextField ftfBkGesamtUnterliegen;
    private SimpleBeteiligtenTable tbBkUnt;
    private JCheckBox chBkGesamtschuldner;
    private JList<Beteiligter> liBkWk;
    private JSpinner spiDwbkAnz;
    private JCheckBox chbKlWk;
    private SimpleBeteiligtenTable tbDwbkGenus;
    private SimpleBeteiligtenTable tabDwbkSw;
    private SimpleBeteiligtenTable tabKlSw;
    private JCheckBox chbWkEinheitlich;
    private JFormattedTextField ftfWkSw;
    private JList<Beteiligter> liWkGesamtschuldner;
    private JCheckBox chbWkGesamtschuld;
    private JFormattedTextField ftfWkUnterliegen;
    private SimpleBeteiligtenTable tbKlDarueber;
    private SimpleBeteiligtenTable tbDwbkDarueber;
    private ScalableBeteiligtenTableModel btmKl;
    private ScalableBeteiligtenTableModel btmBk;
    private ScalableBeteiligtenTableModel btmDwbk;
    public Component focusComponent;

    public StreitgenossenAssistentParser() {
        super(true);
    }

    @Override
    public ParsendUndBauend<Streitgenossen> leseComponents(Component ... components) {
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                String compName = comp.getName() == null ? "" : comp.getName();
                if ("38025".equals(compName)) {
                    this.spiKlaegerZahl = (JSpinner)comp;
                } else if ("38035".equals(compName)) {
                    this.spiBeklagtenZahl = (JSpinner)comp;
                } else if ("38111".equals(compName)) {
                    this.tabKlaegerGenus = (JTable)comp;
                } else if ("38131".equals(compName)) {
                    this.tabBeklagtenGenus = (JTable)comp;
                } else if ("38215".equals(compName)) {
                    this.ftfBkStreitwert = (JFormattedTextField)comp;
                } else if ("38221".equals(compName)) {
                    this.tabBeklagtenSw = (JTable)comp;
                } else if ("38201".equals(compName)) {
                    this.chbBkSwEinheitlich = (JCheckBox)comp;
                } else if ("38321".equals(compName)) {
                    this.liBkGesamtschuldner = (JList)comp;
                } else if ("38335".equals(compName)) {
                    this.ftfBkGesamtUnterliegen = (JFormattedTextField)comp;
                } else if ("38411".equals(compName)) {
                    this.tbBkUnt = (SimpleBeteiligtenTable)comp;
                } else if ("38301".equals(compName)) {
                    this.chBkGesamtschuldner = (JCheckBox)comp;
                } else if ("38511".equals(compName)) {
                    this.liBkWk = (JList)comp;
                } else if ("38525".equals(compName)) {
                    this.spiDwbkAnz = (JSpinner)comp;
                } else if ("38531".equals(compName)) {
                    this.chbKlWk = (JCheckBox)comp;
                } else if ("38611".equals(compName)) {
                    this.tbDwbkGenus = (SimpleBeteiligtenTable)comp;
                } else if ("38751".equals(compName)) {
                    this.tabDwbkSw = (SimpleBeteiligtenTable)comp;
                } else if ("38731".equals(compName)) {
                    this.tabKlSw = (SimpleBeteiligtenTable)comp;
                } else if ("38701".equals(compName)) {
                    this.chbWkEinheitlich = (JCheckBox)comp;
                } else if ("38715".equals(compName)) {
                    this.ftfWkSw = (JFormattedTextField)comp;
                } else if ("38821".equals(compName)) {
                    this.liWkGesamtschuldner = (JList)comp;
                } else if ("38801".equals(compName)) {
                    this.chbWkGesamtschuld = (JCheckBox)comp;
                } else if ("38835".equals(compName)) {
                    this.ftfWkUnterliegen = (JFormattedTextField)comp;
                } else if ("38911".equals(compName)) {
                    this.tbKlDarueber = (SimpleBeteiligtenTable)comp;
                } else if ("38931".equals(compName)) {
                    this.tbDwbkDarueber = (SimpleBeteiligtenTable)comp;
                } else if (comp instanceof JComponent && ((Container)comp).getComponents() != null && ((Container)comp).getComponents().length > 0) {
                    this.leseComponents(((Container)comp).getComponents());
                }
                ++n2;
            }
        }
        return this;
    }

    public void setPrimitives(ProtoBeteiligtenWerte primitives) {
        this.primitives = primitives;
        Kostenrechner.getLogger().info(primitives.toString());
    }

    @Override
    public boolean parseEingabe() throws IllegalArgumentException, NumberFormatException, NullPointerException {
        boolean boole = false;
        try {
            this.rueckgabewert = this.leseFelder();
            if (this.primitives.mitWiderklage) {
                boole = this.getZustand() == 10 && this.parseEingabe(10);
            } else {
                boolean bl = boole = this.getZustand() == 5 && this.parseEingabe(5);
            }
            if (boole) {
                boole = this.parseEingabe(this.rueckgabewert);
            }
        }
        catch (NullPointerException | NumberFormatException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
        return boole;
    }

    @Override
    public boolean parseEingabe(int tab) throws IllegalArgumentException, NumberFormatException, NullPointerException {
        boolean boole = false;
        this.rueckgabewert = this.leseFelder();
        switch (tab) {
            case 0: {
                boole = true;
                break;
            }
            case 1: {
                if (this.primitives.klaegerZahl == 1 && this.primitives.beklagtenZahl > 0) {
                    boole = true;
                    break;
                }
                boole = false;
                break;
            }
            case 2: {
                boole = true;
                break;
            }
            case 3: {
                if (this.primitives.bkStreitwert.greaterThan(Euro.ZERO_CENTS)) {
                    boole = true;
                    break;
                }
                boole = false;
                throw new IllegalArgumentException("Der Streitwert muss \u00fcber 0 sein.");
            }
            case 4: {
                if (this.primitives.bkGesamt) {
                    if (this.primitives.bkGesamtIndices != null && this.primitives.bkGesamtIndices.length > 1 && this.primitives.bkGesamtUnterliegen.greaterThanOrEqualTo(Euro.ZERO_CENTS) && this.primitives.bkGesamtUnterliegen.lessThanOrEqualTo(this.primitives.bkStreitwert)) {
                        boole = true;
                        break;
                    }
                    throw new IllegalArgumentException("Wenn Sie gesamtschuldnerische Verurteilung aktivieren, muss mehr als ein Beklagter markiert sein, die H\u00f6he der Verurteilung > 0 sein, aber maximal so hoch wie der Streitwert sein.");
                }
                boole = true;
                break;
            }
            case 5: {
                boole = true;
                int row = 0;
                while (row < this.primitives.beklagtenZahl) {
                    Euro d = ((BaumbachBeteiligter)this.rueckgabewert.beklagte.get(row)).getErfolg();
                    if (d.greaterThan(this.primitives.bkStreitwert)) {
                        boole = false;
                    }
                    if (this.chBkGesamtschuldner.isSelected() && this.contains(this.primitives.bkGesamtIndices, row) && d.add(this.primitives.bkGesamtUnterliegen).greaterThan(this.primitives.bkStreitwert)) {
                        boole = false;
                    }
                    ++row;
                }
                if (boole) break;
                throw new IllegalArgumentException("Das Unterliegen darf nicht h\u00f6her als der Streitwert sein! Bei Gesamtschuldnern wird das gesamtschuldnerische Unterliegen mit ber\u00fccksichtigt.");
            }
            case 6: {
                if (this.primitives.bkWiderklaegerIndex > -1 && this.primitives.dwbkZahl > -1 && (this.primitives.klWk || this.primitives.dwbkZahl > 0)) {
                    boole = true;
                    break;
                }
                boole = false;
                throw new IllegalArgumentException("Kein widerklagender Beklagter oder kein Widerbeklagter asugew\u00e4hlt!");
            }
            case 7: {
                boole = true;
                break;
            }
            case 8: {
                this.ftfWkSw.setText(this.primitives.wkStreitwert.toString());
                if (this.primitives.wkStreitwert.lessThanOrEqualTo(Euro.ZERO_CENTS)) {
                    boole = false;
                    throw new IllegalArgumentException("Bei einer Widerklage muss der Streitwert > 0 sein.");
                }
                boole = true;
                this.ftfWkUnterliegen.setText(this.primitives.wkGesamtUnterliegen.toString());
                break;
            }
            case 9: {
                if (this.primitives.wkGesamt) {
                    if (this.primitives.wkGesamtIndices == null || this.primitives.wkGesamtIndices.length <= 1 || !this.primitives.wkGesamtUnterliegen.greaterThan(Euro.ZERO_CENTS) || !this.primitives.wkGesamtUnterliegen.lessThanOrEqualTo(this.primitives.wkStreitwert)) {
                        boole = false;
                        throw new IllegalArgumentException("Wenn Sie gesamtschuldnerische Verurteilung aktivieren, muss mehr als ein Widerbeklagter markiert sein, die H\u00f6he der Verurteilung > 0 sein, aber maximal so hoch wie der Streitwert sein.");
                    }
                    boole = true;
                    if (this.primitives.klWk || !this.contains(this.primitives.wkGesamtIndices, 0)) break;
                    boole = false;
                    throw new IllegalArgumentException("Der ausgew\u00e4hlte Kl\u00e4ger ist nicht widerbeklagt.");
                }
                boole = true;
                break;
            }
            case 10: {
                int row;
                boole = true;
                if (this.primitives.klWk) {
                    row = 0;
                    while (row < this.tbKlDarueber.getModel().getRowCount()) {
                        Euro d = Euro.ofEuros((Double)this.tbKlDarueber.getModel().getValueAt(row, 3));
                        if (d.greaterThan(this.primitives.wkStreitwert)) {
                            boole = false;
                        } else if (this.chbWkGesamtschuld.isSelected() && this.contains(this.primitives.wkGesamtIndices, row) && d.add(this.primitives.wkGesamtUnterliegen).greaterThan(this.primitives.wkStreitwert)) {
                            boole = false;
                        }
                        ++row;
                    }
                }
                if (this.primitives.dwbkZahl > 0) {
                    row = 0;
                    while (row < this.tbDwbkDarueber.getModel().getRowCount()) {
                        int absRow = row + this.primitives.klaegerZahl;
                        Euro d = Euro.ofEuros((Double)this.tbDwbkDarueber.getModel().getValueAt(row, 3));
                        if (d.greaterThan(this.primitives.wkStreitwert)) {
                            boole = false;
                        } else if (this.chbWkGesamtschuld.isSelected() && this.contains(this.primitives.wkGesamtIndices, absRow) && d.add(this.primitives.wkGesamtUnterliegen).greaterThan(this.primitives.wkStreitwert)) {
                            boole = false;
                        }
                        ++row;
                    }
                }
                if (boole) break;
                throw new IllegalArgumentException("Das Unterliegen darf nicht h\u00f6her als der Streitwert sein! Bei Gesamtschuldnern wird das gesamtschuldnerische Unterliegen mit ber\u00fccksichtigt.");
            }
            default: {
                boole = false;
            }
        }
        return boole;
    }

    public void setzeWerte(int tab) {
        switch (tab) {
            case 0: {
                this.focusComponent = null;
                break;
            }
            case 1: {
                this.spiKlaegerZahl.setModel(new SpinnerNumberModel(this.primitives.klaegerZahl, 1, 1, 1));
                this.spiBeklagtenZahl.setModel(new SpinnerNumberModel(this.primitives.beklagtenZahl, 0, 100, 1));
                this.focusComponent = this.spiBeklagtenZahl;
                break;
            }
            case 2: {
                this.btmKl.setColumnCount(2);
                this.tabKlaegerGenus.setModel(this.btmKl);
                this.btmBk.setColumnCount(2);
                this.tabBeklagtenGenus.setModel(this.btmBk);
                this.focusComponent = null;
                break;
            }
            case 3: {
                this.ftfBkStreitwert.setText(this.primitives.bkStreitwert.toString());
                this.btmBk.setColumnCount(3);
                this.btmBk.setEachStreitwert(this.primitives.bkStreitwert);
                this.tabBeklagtenSw.setModel(this.btmBk);
                this.chbBkSwEinheitlich.setSelected(false);
                this.chbBkSwEinheitlich.setSelected(true);
                this.chbBkSwEinheitlich.setSelected(this.primitives.bkSwEinheitlich);
                this.chbBkSwEinheitlich.setEnabled(!this.primitives.tab4ueberspringen || !this.primitives.bkSwEinheitlich);
                this.focusComponent = this.ftfBkStreitwert;
                break;
            }
            case 4: {
                this.chBkGesamtschuldner.setSelected(this.primitives.bkGesamt);
                this.ftfBkGesamtUnterliegen.setText(this.primitives.bkGesamtUnterliegen.toString());
                this.liBkGesamtschuldner.setListData((Beteiligter[])this.btmBk.getBeteiligterColumn());
                this.focusComponent = this.ftfBkGesamtUnterliegen;
                break;
            }
            case 5: {
                this.btmBk.setColumnCount(4);
                this.btmBk.setEachUnterliegen(this.primitives.bkUnterliegen);
                this.tbBkUnt.setModel(this.btmBk);
                this.focusComponent = null;
                break;
            }
            case 6: {
                this.chbKlWk.setSelected(this.primitives.klWk);
                this.spiDwbkAnz.setModel(new SpinnerNumberModel(this.primitives.dwbkZahl, 0, 100, 1));
                this.liBkWk.setListData((Beteiligter[])this.btmBk.getBeteiligterColumn());
                this.liBkWk.setSelectedIndex(this.primitives.bkWiderklaegerIndex);
                this.focusComponent = this.liBkWk;
                break;
            }
            case 7: {
                if (this.primitives.dwbkZahl > 0) {
                    this.btmDwbk.setColumnCount(2);
                    this.tbDwbkGenus.setModel(this.btmDwbk);
                    this.tbDwbkGenus.setEnabled(true);
                    this.focusComponent = this.tbDwbkGenus;
                    break;
                }
                this.tbDwbkGenus.setEnabled(false);
                this.focusComponent = null;
                break;
            }
            case 8: {
                if (this.primitives.klWk) {
                    this.btmKl.setColumnCount(3);
                    this.btmKl.setEachStreitwert(this.primitives.wkStreitwert);
                    this.tabKlSw.setModel(this.btmKl);
                } else {
                    this.tabKlSw.setEnabled(false);
                }
                if (this.primitives.dwbkZahl > 0) {
                    this.btmDwbk.setColumnCount(3);
                    this.btmDwbk.setEachStreitwert(this.primitives.wkStreitwert);
                    this.tabDwbkSw.setModel(this.btmDwbk);
                } else {
                    this.tabDwbkSw.setEnabled(false);
                }
                this.ftfWkSw.setText(this.primitives.wkStreitwert.toString());
                this.chbWkEinheitlich.setSelected(false);
                this.chbWkEinheitlich.setSelected(true);
                this.chbWkEinheitlich.setSelected(this.primitives.wkSwEinheitlich);
                this.chbWkEinheitlich.setEnabled(!this.primitives.tab9ueberspringen || !this.primitives.wkSwEinheitlich);
                this.focusComponent = this.ftfWkSw;
                break;
            }
            case 9: {
                ArrayList<BaumbachBeteiligter> tempWiderbeklagte = new ArrayList<BaumbachBeteiligter>();
                tempWiderbeklagte.addAll(this.rueckgabewert.klaeger);
                if (this.primitives.dwbkZahl > 0) {
                    tempWiderbeklagte.addAll(this.rueckgabewert.drittwiderbeklagte);
                }
                this.liWkGesamtschuldner.setListData((Beteiligter[])tempWiderbeklagte.toArray(new Beteiligter[tempWiderbeklagte.size()]));
                this.chbWkGesamtschuld.setSelected(false);
                this.chbWkGesamtschuld.setSelected(true);
                this.chbWkGesamtschuld.setSelected(this.primitives.wkGesamt && tempWiderbeklagte.size() > 1);
                this.chbWkGesamtschuld.setEnabled(tempWiderbeklagte.size() > 1);
                this.ftfWkUnterliegen.setText(this.primitives.wkGesamtUnterliegen.toString());
                this.focusComponent = this.liWkGesamtschuldner;
                break;
            }
            case 10: {
                if (this.primitives.klWk) {
                    this.btmKl.setColumnCount(4);
                    this.btmKl.setEachUnterliegen(this.primitives.wkUnterliegen);
                    this.tbKlDarueber.setModel(this.btmKl);
                    this.tbKlDarueber.setEnabled(true);
                } else {
                    this.tbKlDarueber.setEnabled(false);
                }
                if (this.primitives.dwbkZahl > 0) {
                    this.btmDwbk.setColumnCount(4);
                    this.btmDwbk.setEachUnterliegen(this.primitives.wkUnterliegen);
                    this.tbDwbkDarueber.setModel(this.btmDwbk);
                    this.tbDwbkDarueber.setEnabled(true);
                } else {
                    this.tbDwbkDarueber.setEnabled(false);
                }
                this.focusComponent = null;
                break;
            }
        }
    }

    public boolean isUeberspringbar(int tab) {
        if (tab == 1 && this.primitives.tab1ueberspringen) {
            return true;
        }
        if (tab == 2 && this.primitives.tab2ueberspringen) {
            return true;
        }
        if (tab == 4 && this.primitives.tab4ueberspringen) {
            return true;
        }
        if (tab == 6 && this.primitives.tab6ueberspringen) {
            return true;
        }
        if (tab == 7 && this.primitives.tab7ueberspringen) {
            return true;
        }
        return tab == 9 && this.primitives.tab9ueberspringen;
    }

    public void setRueckgabewert(Streitgenossen rueckgabewert) {
        this.rueckgabewert = rueckgabewert;
        this.btmKl = new ScalableBeteiligtenTableModel(Beteiligter.BeteiligtenTyp.KLAEGER, rueckgabewert.klaeger);
        this.btmBk = new ScalableBeteiligtenTableModel(Beteiligter.BeteiligtenTyp.BEKLAGTE, rueckgabewert.beklagte);
        this.btmDwbk = new ScalableBeteiligtenTableModel(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE, rueckgabewert.drittwiderbeklagte);
    }

    public ProtoBeteiligtenWerte pruefeVerfahrensDatenContainer(VerfahrensDatenContainer container, ProtoBeteiligtenWerte primitives) throws IllegalArgumentException {
        if (container == null) {
            throw new IllegalArgumentException("Leere Datei oder Datei konnte nicht gelesen werden!");
        }
        primitives.ohneXjustiz = container == null;
        primitives.tab1ueberspringen = true;
        primitives.tab2ueberspringen = true;
        primitives.tab6ueberspringen = true;
        primitives.tab7ueberspringen = true;
        primitives.mitWiderklage = container.streitgenossen.widerklage;
        if (!container.streitgenossen.gibtsKlaeger() || container.streitgenossen.klaeger.size() != 1) {
            throw new IllegalArgumentException("Nur ein Kl\u00e4ger erlaubt!");
        }
        primitives.klaegerZahl = container.streitgenossen.klaeger.size();
        primitives.klWk = primitives.mitWiderklage && container.streitgenossen.klaeger.enthaeltAnWiderklageBeteiligte();
        Kostenrechner.getLogger().info(String.format("Beklagtenzahl: %d.%n", container.streitgenossen.beklagte.size()));
        if (container.streitgenossen.beklagte.size() < 1) {
            primitives.tab1ueberspringen = false;
            primitives.tab2ueberspringen = false;
            primitives.tab6ueberspringen = false;
        } else if (container.streitgenossen.beklagte.zaehleAnWiderklageBeteiligte() > 1) {
            throw new IllegalArgumentException("Nur ein Widerkl\u00e4ger erlaubt!");
        }
        primitives.beklagtenZahl = container.streitgenossen.beklagte.size();
        primitives.tab4ueberspringen = primitives.beklagtenZahl < 2;
        boolean bl = primitives.bkGesamt = !primitives.tab4ueberspringen;
        if (primitives.mitWiderklage) {
            int i = 0;
            while (i < container.streitgenossen.beklagte.size()) {
                if (((BaumbachBeteiligter)container.streitgenossen.beklagte.get(i)).isAnWiderklageBeteiligt()) {
                    primitives.bkWiderklaegerIndex = i;
                }
                ++i;
            }
        }
        primitives.dwbkZahl = container.streitgenossen.gibtsDrittwiderbeklagte() ? container.streitgenossen.drittwiderbeklagte.size() : 0;
        if (primitives.mitWiderklage) {
            if (container.streitgenossen.beklagte.zaehleAnWiderklageBeteiligte() > 0 && container.streitgenossen.klaeger.zaehleAnWiderklageBeteiligte() < 1 && primitives.dwbkZahl < 1) {
                primitives.tab6ueberspringen = false;
                primitives.tab7ueberspringen = false;
            } else if ((container.streitgenossen.klaeger.zaehleAnWiderklageBeteiligte() > 0 || primitives.dwbkZahl > 0) && container.streitgenossen.beklagte.zaehleAnWiderklageBeteiligte() < 1) {
                primitives.tab6ueberspringen = false;
                primitives.tab7ueberspringen = false;
            }
            primitives.wbkZahl = primitives.klWk ? 1 : 0;
            primitives.wbkZahl += primitives.dwbkZahl;
            primitives.tab9ueberspringen = primitives.wbkZahl < 2;
            primitives.wkGesamt = !primitives.tab9ueberspringen;
        }
        primitives.bkStreitwert = container.allgemein.streitwert;
        primitives.wkStreitwert = container.allgemein.streitwert;
        return primitives;
    }

    public int getZustand() {
        return this.zustand;
    }

    public void setZustand(int zustand) {
        this.zustand = zustand;
    }

    public int getHoechsterZustand() {
        if (this.primitives.mitWiderklage) {
            return 11;
        }
        return 6;
    }

    private Streitgenossen leseFelder() throws NumberFormatException, NullPointerException {
        if (this.rueckgabewert == null) {
            this.rueckgabewert = new Streitgenossen();
        }
        switch (this.getZustand()) {
            default: {
                break;
            }
            case 1: {
                this.primitives.klaegerZahl = ((SpinnerNumberModel)this.spiKlaegerZahl.getModel()).getNumber().intValue();
                int lfd = this.rueckgabewert.klaeger.size();
                while (this.rueckgabewert.klaeger.size() < this.primitives.klaegerZahl) {
                    BaumbachBeteiligter klaeger = new BaumbachBeteiligter();
                    klaeger.setLfdNr(lfd);
                    klaeger.setTyp(Beteiligter.BeteiligtenTyp.KLAEGER);
                    klaeger.setGenusNumerus(Beteiligter.GenusNumerus.WEIBLICH_SINGULAR);
                    klaeger.setAntrag(Euro.ZERO_CENTS);
                    klaeger.setErfolg(Euro.ZERO_CENTS);
                    this.rueckgabewert.klaeger.add(klaeger);
                    Kostenrechner.getLogger().info(String.format("Kl\u00e4ger Nr. %d hinzugef\u00fcgt.%n", lfd + 1));
                    ++lfd;
                }
                this.primitives.beklagtenZahl = ((SpinnerNumberModel)this.spiBeklagtenZahl.getModel()).getNumber().intValue();
                this.primitives.tab4ueberspringen = this.primitives.beklagtenZahl < 2;
                this.primitives.bkGesamt = !this.primitives.tab4ueberspringen;
                lfd = this.rueckgabewert.beklagte.size();
                while (this.rueckgabewert.beklagte.size() < this.primitives.beklagtenZahl) {
                    BaumbachBeteiligter beklagter = new BaumbachBeteiligter();
                    beklagter.setLfdNr(lfd);
                    beklagter.setTyp(Beteiligter.BeteiligtenTyp.BEKLAGTE);
                    beklagter.setGenusNumerus(Beteiligter.GenusNumerus.WEIBLICH_SINGULAR);
                    this.rueckgabewert.beklagte.add(beklagter);
                    Kostenrechner.getLogger().info(String.format("Beklagten Nr. %d hinzugef\u00fcgt.%n", lfd + 1));
                    ++lfd;
                }
                if (!this.primitives.mitWiderklage || this.primitives.beklagtenZahl != 1) break;
                this.primitives.bkWiderklaegerIndex = 0;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.primitives.bkSwEinheitlich = this.chbBkSwEinheitlich.isSelected();
                if (this.primitives.bkSwEinheitlich) {
                    this.primitives.bkStreitwert = new NumberExtractor(this.ftfBkStreitwert, this.ftfBkStreitwert.getAccessibleContext().getAccessibleName()).extractEuro();
                    int row = 0;
                    while (row < this.primitives.beklagtenZahl) {
                        ((BaumbachBeteiligter)this.rueckgabewert.beklagte.get(row)).setAntrag(this.primitives.bkStreitwert);
                        ++row;
                    }
                    break;
                }
                this.primitives.bkStreitwert = this.rueckgabewert.beklagte.getHoechstenStreitwert(Beteiligter.BeteiligtenTyp.BEKLAGTE);
                break;
            }
            case 4: {
                this.primitives.bkGesamt = this.chBkGesamtschuldner.isSelected();
                if (!this.primitives.bkGesamt) break;
                this.primitives.bkGesamtIndices = this.liBkGesamtschuldner.getSelectedIndices();
                this.primitives.bkGesamtUnterliegen = new NumberExtractor(this.ftfBkGesamtUnterliegen, this.ftfBkGesamtUnterliegen.getAccessibleContext().getAccessibleName()).extractEuro();
                BaumbachGesamtschuldnerschaft gessch = new BaumbachGesamtschuldnerschaft();
                gessch.setTyp(Beteiligter.BeteiligtenTyp.BEKLAGTE);
                gessch.setGenusNumerus(Beteiligter.GenusNumerus.of(((BaumbachBeteiligter)this.rueckgabewert.beklagte.get(this.primitives.beklagtenZahl - 1)).getGenusNumerus().getGenus(), Beteiligter.GenusNumerus.Numerus.PLURAL));
                gessch.setErfolg(this.primitives.bkGesamtUnterliegen);
                gessch.setAufzaehlung(this.primitives.bkGesamtIndices);
                gessch.setBaumbachBeteiligtenListe(this.rueckgabewert.beklagte);
                this.rueckgabewert.beklagte.add(gessch);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.rueckgabewert.widerklage = this.primitives.mitWiderklage;
                this.primitives.dwbkZahl = ((SpinnerNumberModel)this.spiDwbkAnz.getModel()).getNumber().intValue();
                this.primitives.tab7ueberspringen = this.primitives.dwbkZahl < 1;
                int lfd = this.rueckgabewert.drittwiderbeklagte.size();
                while (this.rueckgabewert.drittwiderbeklagte.size() < this.primitives.dwbkZahl) {
                    BaumbachBeteiligter drittwiderbeklagter = new BaumbachBeteiligter();
                    drittwiderbeklagter.setLfdNr(lfd);
                    drittwiderbeklagter.setTyp(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE);
                    drittwiderbeklagter.setGenusNumerus(Beteiligter.GenusNumerus.MAENNLICH_SINGULAR);
                    drittwiderbeklagter.setAnWiderklageBeteiligt(true);
                    this.rueckgabewert.drittwiderbeklagte.add(drittwiderbeklagter);
                    Kostenrechner.getLogger().info(String.format("Drittwiderbeklagten Nr. %d hinzugef\u00fcgt.%n", lfd + 1));
                    ++lfd;
                }
                this.primitives.klWk = this.chbKlWk.isSelected();
                ((BaumbachBeteiligter)this.rueckgabewert.klaeger.get(0)).setAnWiderklageBeteiligt(this.primitives.klWk);
                this.primitives.wbkZahl = this.primitives.klWk ? 1 : 0;
                this.primitives.wbkZahl += this.primitives.dwbkZahl;
                this.primitives.tab9ueberspringen = this.primitives.wbkZahl < 2;
                this.primitives.wkGesamt = !this.primitives.tab9ueberspringen;
                this.primitives.bkWiderklaegerIndex = this.liBkWk.getSelectedIndex();
                int i = 0;
                while (i < this.primitives.beklagtenZahl) {
                    BaumbachBeteiligter bk = (BaumbachBeteiligter)this.rueckgabewert.beklagte.get(i);
                    if (i == this.primitives.bkWiderklaegerIndex) {
                        bk.setAnWiderklageBeteiligt(true);
                    } else {
                        bk.setAnWiderklageBeteiligt(false);
                    }
                    ++i;
                }
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.primitives.wkSwEinheitlich = this.chbWkEinheitlich.isSelected();
                if (this.primitives.wkSwEinheitlich) {
                    this.primitives.wkStreitwert = new NumberExtractor(this.ftfWkSw, this.ftfWkSw.getAccessibleContext().getAccessibleName()).extractEuro();
                    if (this.primitives.klWk) {
                        ((BaumbachBeteiligter)this.rueckgabewert.klaeger.get(0)).setAntrag(this.primitives.wkStreitwert);
                    }
                    if (this.primitives.dwbkZahl <= 0) break;
                    int row = 0;
                    while (row < this.primitives.dwbkZahl) {
                        ((BaumbachBeteiligter)this.rueckgabewert.drittwiderbeklagte.get(row)).setAntrag(this.primitives.wkStreitwert);
                        ++row;
                    }
                    break;
                }
                Euro klWkStreitwert = Euro.ZERO_CENTS;
                Euro dwbkStreitwert = Euro.ZERO_CENTS;
                if (this.primitives.klWk) {
                    klWkStreitwert = this.rueckgabewert.klaeger.getHoechstenStreitwert(Beteiligter.BeteiligtenTyp.KLAEGER);
                }
                if (this.primitives.dwbkZahl > 0) {
                    dwbkStreitwert = this.rueckgabewert.drittwiderbeklagte.getHoechstenStreitwert(Beteiligter.BeteiligtenTyp.BEKLAGTE);
                }
                if (klWkStreitwert.greaterThan(dwbkStreitwert)) {
                    this.primitives.wkStreitwert = klWkStreitwert;
                    break;
                }
                this.primitives.wkStreitwert = dwbkStreitwert;
                break;
            }
            case 9: {
                this.primitives.wkGesamt = this.chbWkGesamtschuld.isSelected();
                if (!this.primitives.wkGesamt) break;
                this.primitives.wkGesamtIndices = this.liWkGesamtschuldner.getSelectedIndices();
                this.primitives.wkGesamtUnterliegen = new NumberExtractor(this.ftfWkUnterliegen, this.ftfWkUnterliegen.getAccessibleContext().getAccessibleName()).extractEuro();
                BaumbachGesamtschuldnerschaft gessch = new BaumbachGesamtschuldnerschaft();
                gessch.setTyp(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE);
                gessch.setGenusNumerus(Beteiligter.GenusNumerus.of(((BaumbachBeteiligter)this.rueckgabewert.drittwiderbeklagte.get(this.primitives.dwbkZahl - 1)).getGenusNumerus().getGenus(), Beteiligter.GenusNumerus.Numerus.PLURAL));
                gessch.setAnWiderklageBeteiligt(true);
                gessch.setErfolg(this.primitives.wkGesamtUnterliegen);
                gessch.setAufzaehlung(this.primitives.wkGesamtIndices);
                BaumbachBeteiligtenListe zwischen = new BaumbachBeteiligtenListe();
                zwischen.addAll(this.rueckgabewert.klaeger);
                zwischen.addAll(this.rueckgabewert.drittwiderbeklagte);
                gessch.setBaumbachBeteiligtenListe(zwischen);
                this.rueckgabewert.drittwiderbeklagte.add(gessch);
                break;
            }
            case 10: {
                if (this.primitives.klWk && ((BaumbachBeteiligter)this.rueckgabewert.klaeger.get(0)).getErfolg().greaterThan(this.primitives.wkUnterliegen)) {
                    this.primitives.wkUnterliegen = ((BaumbachBeteiligter)this.rueckgabewert.klaeger.get(0)).getErfolg();
                }
                if (this.primitives.dwbkZahl <= 0) break;
                int row = 0;
                while (row < this.primitives.dwbkZahl) {
                    if (((BaumbachBeteiligter)this.rueckgabewert.drittwiderbeklagte.get(row)).getErfolg().greaterThan(this.primitives.wkUnterliegen)) {
                        this.primitives.wkUnterliegen = ((BaumbachBeteiligter)this.rueckgabewert.drittwiderbeklagte.get(row)).getErfolg();
                    }
                    ++row;
                }
                break block0;
            }
        }
        return this.rueckgabewert;
    }

    private boolean contains(int[] indices, int index) {
        boolean contains = false;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == index) {
                contains = true;
            }
            ++n2;
        }
        return contains;
    }
}

