/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.TenorAction;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.logic.baumbach.BaumbachFormel;

public class StreitgenossenBaumbachAction
extends TenorAction {
    private final StreitgenossenTabellenBehandelnd panel;
    private static final long serialVersionUID = 8105321861085009090L;

    public StreitgenossenBaumbachAction(StreitgenossenTabellenBehandelnd panel, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.panel = panel;
    }

    @Override
    protected boolean allesOk() throws IllegalArgumentException {
        if (!this.panel.pruefeTabellen()) {
            throw new IllegalArgumentException("Die Berechnung erfordert einen Kl\u00e4ger und mindestens einen Beklagten.");
        }
        return true;
    }

    @Override
    protected TenorDatenContainer tenorDaten(VerfahrensDatenContainer container) throws IllegalArgumentException {
        return new BaumbachFormel(container).erzeugeContainer();
    }
}

