/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import java.awt.event.ActionEvent;

public class StreitgenossenGesamtschuldDwbkExtractAction
extends BeschriebeneAktion {
    private final StreitgenossenTabellenBehandelnd handler;
    private static final long serialVersionUID = 8105321861085009090L;

    public StreitgenossenGesamtschuldDwbkExtractAction(StreitgenossenTabellenBehandelnd handler, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.handler = handler;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BaumbachBeteiligtenListe beteiligte = new BaumbachBeteiligtenListe();
        BeteiligtenTableModel btmKlaeger = (BeteiligtenTableModel)this.handler.getTableModel(Beteiligter.BeteiligtenTyp.KLAEGER.ordinal());
        BeteiligtenTableModel btmDrittwiderbeklagte = (BeteiligtenTableModel)this.handler.getTableModel(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE.ordinal());
        beteiligte.addAll(btmKlaeger.getAllValues());
        beteiligte.addAll(btmDrittwiderbeklagte.getAllValues());
        if (beteiligte == null || beteiligte.size() < 2) {
            return;
        }
        BaumbachGesamtschuldnerschaft gesamtschuldnerschaft = beteiligte.extrahiereGesamtschuldnerschaft(btmDrittwiderbeklagte.getBeteiligtenTyp());
        if (gesamtschuldnerschaft != null) {
            btmDrittwiderbeklagte.addRow(gesamtschuldnerschaft);
            Kostenrechner.getLogger().info("Schleife");
            this.actionPerformed(e);
            btmKlaeger.fireTableDataChanged();
            btmDrittwiderbeklagte.fireTableDataChanged();
        } else {
            Kostenrechner.getLogger().info("Schleife endet!");
        }
    }
}

