/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.view.baumbach.GesamtschuldnerDialog;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;
import java.awt.event.ActionEvent;

public class StreitgenossenGesamtschuldnerDwbkAction
extends BeschriebeneAktion
implements AbfrageLieferant<GesamtschuldnerDialog> {
    private final StreitgenossenPanel panel;
    private static final long serialVersionUID = -6637467913455344657L;
    private GesamtschuldnerDialog dialog = null;

    public StreitgenossenGesamtschuldnerDwbkAction(StreitgenossenPanel panel, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            try {
                this.setDialog(new GesamtschuldnerDialog(this.panel.getKostenrechner(), this.panel.btmKlaeger.getAllValues(), this.panel.btmDrittwiderbeklagte.getAllValues(), this.panel.getExtrahierenAktion(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE)));
                BaumbachGesamtschuldnerschaft bt = (BaumbachGesamtschuldnerschaft)this.getDialog().showDialogAndAsk();
                if (bt != null) {
                    this.panel.btmDrittwiderbeklagte.addRow(bt);
                }
            }
            catch (IllegalArgumentException iae) {
                FehlerHelper.zeigeFehler(iae.getLocalizedMessage(), iae);
                this.setDialog(null);
            }
        }
        finally {
            this.setDialog(null);
        }
    }

    @Override
    public GesamtschuldnerDialog getDialog() {
        return this.dialog;
    }

    private void setDialog(GesamtschuldnerDialog dialog) {
        this.dialog = dialog;
    }
}

