/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.files;

import eu.gronos.beschriftungen.view.FontHelfer;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlWerkzeugKasten
extends HTMLEditorKit {
    private static final long serialVersionUID = 1919064068820341048L;
    public static final String KOSTENTENOR_CSS = "resources/kostentenor.css";
    private static StyleSheet cssSheet = null;
    private StyleSheet sheet = null;
    private static final String EM_FINDER = "(\\d+|\\d+\\.\\d+)em";
    private StyledDocument doc;

    @Override
    public void install(JEditorPane textPane) {
        super.install(textPane);
        this.createDefaultDocument();
        if (textPane instanceof JTextPane) {
            ((JTextPane)textPane).setStyledDocument(this.doc);
        } else {
            textPane.setDocument(this.doc);
        }
        textPane.setEditable(false);
        textPane.addHyperlinkListener(HinzufuegenDialog.HYPERLINK_LISTENER);
    }

    @Override
    public Document createDefaultDocument() {
        if (this.doc != null) {
            return this.doc;
        }
        this.doc = (StyledDocument)super.createDefaultDocument();
        return this.doc;
    }

    public void read(String htmlfilename, JTextPane textPane) {
        this.read(htmlfilename, this.doc);
        textPane.setCaretPosition(0);
        textPane.repaint();
    }

    @Override
    public void setStyleSheet(StyleSheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public StyleSheet getStyleSheet() {
        if (this.sheet == null) {
            this.createStyles();
            return this.sheet;
        }
        return this.sheet;
    }

    protected void setDefaultStyleSheet(StyleSheet sheet) {
        super.setStyleSheet(sheet);
    }

    private StyleSheet getDefaultStyleSheet() {
        return super.getStyleSheet();
    }

    private void createStyles() {
        URL css = this.getClass().getClassLoader().getResource(KOSTENTENOR_CSS);
        this.setStyleSheet(new StyleSheet());
        this.getStyleSheet().addStyleSheet(this.getDefaultStyleSheet());
        List<String> oldStyleNames = this.collectStyleNamesList(this.getStyleSheet());
        if (cssSheet == null) {
            cssSheet = new StyleSheet();
            cssSheet = this.cssReinziehen(css, cssSheet);
        }
        List<String> newStyleNames = this.collectStyleNamesList(cssSheet);
        this.leereStyleSheet(super.getStyleSheet(), oldStyleNames, newStyleNames);
        this.getStyleSheet().addStyleSheet(cssSheet);
    }

    private void read(String name, StyledDocument doc) {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
            doc.remove(0, doc.getLength());
            doc.putProperty("IgnoreCharsetDirective", new Boolean(true));
            super.read(is, (Document)doc, 0);
        }
        catch (FileNotFoundException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
        }
        catch (BadLocationException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
        }
    }

    private void leereStyleSheet(StyleSheet sheet, List<String> names, List<String> newNames) {
        for (String name : names) {
            if (!newNames.contains(name)) continue;
            sheet.removeStyle(name);
        }
    }

    private List<String> collectStyleNamesList(StyleSheet sheet) {
        Enumeration<?> e = sheet.getStyleNames();
        ArrayList<String> names = new ArrayList<String>();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            names.add(str);
        }
        return names;
    }

    private StyleSheet cssReinziehen(URL css, StyleSheet sheet) {
        Kostenrechner.getLogger().info("cssReinziehen");
        sheet.importStyleSheet(css);
        this.applySystemConstants(sheet);
        return this.baueSheetMitFonts(sheet, this.collectStyleNamesList(sheet));
    }

    private StyleSheet baueSheetMitFonts(StyleSheet sheet, List<String> names) {
        String[] installedFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        StyleSheet newSheet = new StyleSheet();
        StringBuilder cssText = new StringBuilder();
        for (String name : names) {
            Style rule = sheet.getRule(name);
            StringBuilder builder = new StringBuilder(String.valueOf(name) + " {");
            Enumeration<?> ruleEnumerator = rule.getAttributeNames();
            while (ruleEnumerator.hasMoreElements()) {
                Object element = ruleEnumerator.nextElement();
                if (!(element instanceof StyleConstants) || !(rule.getAttribute(element) instanceof StyleContext.NamedStyle)) continue;
                StyleContext.NamedStyle named = (StyleContext.NamedStyle)rule.getAttribute(element);
                Enumeration<?> namedStylesEnumerator = named.getAttributeNames();
                while (namedStylesEnumerator.hasMoreElements()) {
                    Object nextE = namedStylesEnumerator.nextElement();
                    Object attribute = named.getAttribute(nextE);
                    if (CSS.Attribute.FONT_FAMILY.equals(nextE)) {
                        builder.append(String.format("%s: %s;", nextE.toString(), this.pickeFontName(attribute.toString(), installedFonts)));
                        continue;
                    }
                    if (CSS.Attribute.MARGIN.equals(nextE) || CSS.Attribute.MARGIN_LEFT.equals(nextE) || CSS.Attribute.MARGIN_RIGHT.equals(nextE) || CSS.Attribute.MARGIN_BOTTOM.equals(nextE) || CSS.Attribute.MARGIN_TOP.equals(nextE)) continue;
                    String verwandleGroesse = this.verwandleGroessen(attribute.toString());
                    builder.append(String.format("%s: %s;", nextE.toString(), verwandleGroesse));
                }
            }
            builder.append("}");
            String string = builder.toString();
            cssText.append(String.valueOf(string) + System.lineSeparator());
            newSheet.addRule(string);
        }
        Kostenrechner.getLogger().info(cssText.toString());
        return newSheet;
    }

    private String verwandleGroessen(String string) {
        StringBuilder builder = new StringBuilder();
        Pattern pattern = Pattern.compile(EM_FINDER);
        Matcher matcher = pattern.matcher(string);
        int start = -1;
        int end = -1;
        int found = 0;
        int last = 0;
        while (matcher.find()) {
            start = matcher.start();
            end = matcher.end();
            String gefunden = (String)string.subSequence(start, end - 2);
            int size = this.verwandleGroesse(gefunden);
            if (start > 0) {
                builder.append(string.subSequence(last, start - 1));
            }
            builder.append(String.format("%dpx", size));
            ++found;
            last = end - 1;
        }
        if (found > 0 && end < string.length() - 1) {
            builder.append(string.subSequence(end, string.length() - 1));
        }
        if (found > 0) {
            return builder.toString();
        }
        return string;
    }

    private int verwandleGroesse(String gefunden) {
        float fliess = Float.parseFloat(gefunden);
        int size = (int)((double)((float)this.baseFont().getSize() * fliess) * FontHelfer.zoom);
        return size;
    }

    private String pickeFontName(String fonts, String[] installierte) {
        String[] einzelne;
        String[] stringArray = einzelne = fonts.split(",\\s+");
        int n = einzelne.length;
        int n2 = 0;
        while (n2 < n) {
            String einzelner = stringArray[n2];
            String[] stringArray2 = installierte;
            int n3 = installierte.length;
            int n4 = 0;
            while (n4 < n3) {
                String installierter = stringArray2[n4];
                if (installierter.equals(einzelner)) {
                    return einzelner;
                }
                ++n4;
            }
            ++n2;
        }
        return this.baseFont().getFontName();
    }

    private void applySystemConstants(StyleSheet sheet) {
        Font font = this.baseFont();
        Style body = sheet.getStyle("body");
        StyleConstants.setFontSize(body, (int)((double)font.getSize() * FontHelfer.zoom));
        StyleConstants.setFontFamily(body, font.getFontName());
    }

    private Font baseFont() {
        UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
        Font font = uid.getFont("Label.font");
        return font;
    }
}

