/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.files;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class KostenFileFilter
extends FileFilter {
    private final String description;
    private final List<String> extensions;
    private final List<String> lowerCaseExtensions;
    private final String preSelected;

    public KostenFileFilter(String preSelected, String description, String ... extensions) {
        this.preSelected = preSelected;
        this.description = description;
        this.extensions = new ArrayList<String>();
        this.lowerCaseExtensions = new ArrayList<String>();
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (extension == null || extension.length() < 1) {
                throw new IllegalArgumentException("Extensions must not be null or empty!");
            }
            this.extensions.add(extension);
            this.lowerCaseExtensions.add(extension.toLowerCase());
            ++n2;
        }
    }

    @Override
    public boolean accept(File datei) {
        Path pfad = datei.toPath();
        return this.accept(pfad);
    }

    public boolean accept(Path pfad) {
        if (pfad != null) {
            if (Files.isDirectory(pfad, new LinkOption[0])) {
                return true;
            }
            if (this.acceptExtension(pfad)) {
                return true;
            }
        }
        return false;
    }

    public boolean acceptExtension(Path datei) {
        if (datei == null || Files.isDirectory(datei, new LinkOption[0])) {
            return false;
        }
        String dateiName = datei.getFileName().toString();
        int i = dateiName.lastIndexOf(46);
        if (i > 0 && i < dateiName.length() - 1) {
            String dateiErweiterung = dateiName.substring(i + 1);
            return this.lowerCaseExtensions.contains(dateiErweiterung.toLowerCase());
        }
        return false;
    }

    public Path acceptAsPath(Path datei) {
        if (datei == null) {
            return null;
        }
        if (!datei.toString().endsWith(this.ganzeEndung())) {
            datei = Paths.get(String.valueOf(datei.toAbsolutePath().toString()) + this.ganzeEndung(), new String[0]);
        }
        return datei;
    }

    public String getPreSelected() {
        return this.preSelected;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[description=" + this.getDescription() + " extensions=" + this.extensions + "]";
    }

    public String ganzeEndung() {
        return "." + this.getExtensions().get(0);
    }
}

