/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.files;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.view.FontHelfer;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.KostenFileFilter;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.BegruendungsZahlenTableModel;
import eu.gronos.kostenrechner.data.tenordaten.CaretRange;
import eu.gronos.kostenrechner.interfaces.Tabulierend;
import eu.gronos.kostenrechner.interfaces.Tenorierend;
import eu.gronos.kostenrechner.util.files.RTFStringCreator;
import eu.gronos.kostenrechner.view.KostenFileChooser;
import eu.gronos.kostenrechner.view.result.BegruendungsZahlenRenderer;
import eu.gronos.kostenrechner.view.result.StringButtonRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.rtf.RTFEditorKit;

public class RtfWerkzeugKasten
extends RTFEditorKit
implements ClipboardOwner,
Transferable {
    private static final long serialVersionUID = 2201251699302376878L;
    private final DataFlavor[] flavors = new DataFlavor[]{new DataFlavor("text/rtf", "Rich Formatted Text"), new DataFlavor("text/plain", "Plain Text")};
    private String[] data;
    private KostenFileChooser fileChooser;
    private Document doc;
    private Tenorierend tenorierend;
    private final RTFStringCreator writer;
    private final boolean alsBruch;
    public static final KostenFileFilter DATEI_FILTER = new KostenFileFilter("tenor", "Rich Text Format (RTF)", "rtf");
    private static final String[] ARIALS = new String[]{"Arial", "Helvetica", "Helv"};

    public RtfWerkzeugKasten(boolean alsBruch) {
        this.alsBruch = alsBruch;
        this.writer = new RTFStringCreator(alsBruch);
    }

    public void kopiereRtfInZwischenablage() {
        Clipboard zwischenAblage = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            this.setTransferData(this.writer.createRTFString(this.tenorierend), this.getAllText());
            zwischenAblage.setContents(this, this);
        }
        catch (UnsupportedEncodingException | BadLocationException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        Kostenrechner.getLogger().info(String.format("Och n\u00f6, geh\u00f6rt mir doch die Zwischeablage (%s) nicht mehr!", clipboard.getName()));
    }

    @Override
    public void install(JEditorPane textPane) {
        super.install(textPane);
        this.doc = this.createDefaultDocument();
        textPane.setEditable(false);
        this.createStyles();
    }

    @Override
    public Document createDefaultDocument() {
        if (this.getDefaultStyledDocument() != null) {
            return this.getDefaultStyledDocument();
        }
        this.doc = super.createDefaultDocument();
        return this.getDefaultStyledDocument();
    }

    public DefaultStyledDocument getDefaultStyledDocument() {
        return (DefaultStyledDocument)this.getDocument();
    }

    public Path speichereRTF(Component parent) {
        boolean erfolg = false;
        Path datei = null;
        this.fileChooser = new KostenFileChooser(DATEI_FILTER, (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(75000));
        int option = this.fileChooser.showSaveDialog(parent);
        if (option == 0) {
            datei = this.fileChooser.getSelectedPath().toAbsolutePath();
            erfolg = this.write(datei);
        }
        this.fileChooser = null;
        if (erfolg) {
            return datei;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor df = dataFlavorArray[n2];
            if (df.isMimeTypeEqual(flavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        int i = 0;
        while (i < this.flavors.length) {
            if (this.flavors[i].isMimeTypeEqual(flavor)) {
                return new ByteArrayInputStream(this.data[i].getBytes());
            }
            ++i;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public KostenFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void insertString(String str, String title, boolean grosseTabulatoren) throws BadLocationException {
        this.writer.setTenor(str);
        this.writer.setTitle(title);
        this.doc.remove(0, this.doc.getLength());
        this.doc.insertString(0, str, ((StyledDocument)this.doc).getStyle("base"));
        this.doc.putProperty("title", title);
        this.setParagraphAttributes(0, this.doc.getLength(), grosseTabulatoren);
    }

    public int insertString(String str, Tenorierend tenorierend, Dimension paneSize, String gruendeUeberschrift) throws BadLocationException {
        this.tenorierend = tenorierend;
        this.writer.setGruende(str);
        this.writer.setGruendeUeberschrift(gruendeUeberschrift);
        int anfang = this.doc.getLength();
        this.doc.insertString(anfang, this.writer.getGruendeUeberschrift(), this.getDefaultStyledDocument().getStyle("bold"));
        int nachUeberschrift = this.doc.getLength();
        this.doc.insertString(nachUeberschrift, str, this.getDefaultStyledDocument().getStyle("base"));
        Kostenrechner.getLogger().info(String.format("doc.Length()-anfang: %04d", this.doc.getLength() - anfang));
        if (tenorierend instanceof Tabulierend) {
            this.createTableStyle(this.baueGruendeTabelle((Tabulierend)((Object)tenorierend), paneSize, this.alsBruch));
            this.gruendeTabelleEinpassen(str, (Tabulierend)((Object)tenorierend), nachUeberschrift);
        }
        return nachUeberschrift;
    }

    private boolean write(Path datei) {
        boolean erfolg = false;
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(datei, StandardCharsets.UTF_8, new OpenOption[0]);){
                bw.write(this.writer.createRTFString(this.tenorierend));
                erfolg = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
        }
        return erfolg;
    }

    private String getAllText() throws BadLocationException {
        return this.doc.getText(this.doc.getStartPosition().getOffset(), this.doc.getLength());
    }

    private void setTransferData(String ... data) {
        this.data = data;
    }

    private Style createStyles() {
        DefaultStyledDocument doc = this.getDefaultStyledDocument();
        Style baseStyle = this.createBaseStyle();
        this.createBoldStyle(doc, baseStyle);
        this.createTabStoppedStyle(doc, baseStyle);
        return baseStyle;
    }

    private Style createBaseStyle() {
        Style baseStyle = this.getDefaultStyledDocument().addStyle("base", null);
        this.setFontArial(baseStyle);
        this.setFontSize(baseStyle);
        StyleConstants.setLineSpacing(baseStyle, 0.33f);
        StyleConstants.setSpaceBelow(baseStyle, 7.0f);
        return baseStyle;
    }

    private Style createBoldStyle(StyledDocument doc, Style baseStyle) {
        Style style = doc.addStyle("bold", baseStyle);
        StyleConstants.setBold(style, true);
        return style;
    }

    private Style createTabStoppedStyle(StyledDocument doc, Style baseStyle) {
        Style style = doc.addStyle("tabulatoren", baseStyle);
        StyleConstants.setTabSet(style, new TabSet(new TabStop[]{new TabStop(600.0f, 1, 1), new TabStop(950.0f, 1, 1)}));
        return style;
    }

    private Style createTableStyle(JTable table) {
        Style style = this.getDefaultStyledDocument().addStyle("table", this.getDefaultStyledDocument().getStyle("base"));
        JScrollPane jScrollPane = new JScrollPane(table);
        StyleConstants.setComponent(style, jScrollPane);
        return style;
    }

    private void gruendeTabelleEinpassen(String gruende, Tabulierend tab, int offset) throws BadLocationException {
        CaretRange range = tab.getRange();
        int anfangGruende = offset + range.beginn + 1;
        int laenge = range.ende - range.beginn;
        this.getDefaultStyledDocument().remove(anfangGruende, laenge - 1);
        this.getDefaultStyledDocument().insertString(anfangGruende, gruende.substring(range.beginn + 1, range.ende), this.getDefaultStyledDocument().getStyle("table"));
        Kostenrechner.getLogger().info(String.format("anfangGruende: %04d, doc.getLength(): %04d, range: (%04d, %04d); laenge: %04d", anfangGruende, this.getDefaultStyledDocument().getLength(), range.beginn, range.ende, laenge));
    }

    private JTable baueGruendeTabelle(Tabulierend tabulierend, Dimension paneSize, boolean alsBruch) {
        JTable table = new JTable(new BegruendungsZahlenTableModel(tabulierend));
        Dimension d = table.getPreferredSize();
        d.width = paneSize.width;
        table.setPreferredScrollableViewportSize(d);
        table.setDefaultRenderer(Number.class, new BegruendungsZahlenRenderer(alsBruch));
        table.setDefaultRenderer(String.class, new StringButtonRenderer());
        return table;
    }

    private boolean setFontArial(MutableAttributeSet attrib) {
        FontHelfer helper = new FontHelfer();
        boolean ok = false;
        String ff = StyleConstants.getFontFamily(attrib);
        String[] stringArray = ARIALS;
        int n = ARIALS.length;
        int n2 = 0;
        while (n2 < n) {
            String arial = stringArray[n2];
            if (helper.getFontForName(arial) != null) {
                this.writer.setArial(arial);
            }
            if (arial.equals(ff)) {
                StyleConstants.setFontFamily(attrib, arial);
                ok = true;
            } else if (!ok && helper.getFontForName(arial) != null) {
                StyleConstants.setFontFamily(attrib, arial);
                ok = true;
            }
            ++n2;
        }
        return ok;
    }

    private void setFontSize(MutableAttributeSet attrib) {
        Font font = this.baseFont();
        int fs = (int)((double)StyleConstants.getFontSize(attrib) * FontHelfer.zoom);
        StyleConstants.setFontSize(attrib, fs > font.getSize() ? fs : font.getSize());
    }

    private Font baseFont() {
        UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
        return uid.getFont("EditorPane.font");
    }

    private void setParagraphAttributes(int offset, int length, boolean grosseTabulatoren) {
        if (grosseTabulatoren) {
            this.getDefaultStyledDocument().setParagraphAttributes(offset, length, this.getDefaultStyledDocument().getStyle("tabulatoren"), false);
        } else {
            this.getDefaultStyledDocument().setParagraphAttributes(offset, length, this.getDefaultStyledDocument().getStyle("base"), false);
        }
    }
}

