/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.files;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.util.files.TenorXmlDatei;
import eu.gronos.kostenrechner.view.result.TenorDialog;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JDialog;
import javax.xml.bind.JAXBException;

public class SpeichereRtfAction
extends BeschriebeneAktion
implements AbfrageLieferant<JDialog> {
    private final TenorDialog tenorDialog;
    private TenorDatenContainer container;
    private static final long serialVersionUID = 1162624762983290295L;

    public SpeichereRtfAction(TenorDialog tenorDialog, TenorDatenContainer container, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.tenorDialog = tenorDialog;
        this.container = container;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Path datei = this.tenorDialog.getKit().speichereRTF(this.tenorDialog);
        if (datei != null && this.tenorDialog.isXmlSelected()) {
            datei = Paths.get(String.valueOf(datei.toAbsolutePath().toString()) + TenorXmlDatei.DATEI_FILTER.ganzeEndung(), new String[0]);
            try {
                new TenorXmlDatei().speicherXml(this.container, datei);
            }
            catch (IOException | JAXBException je) {
                FehlerHelper.zeigeFehler("Fehler beim Umwandeln in XML", je);
            }
        }
    }

    @Override
    public JDialog getDialog() {
        if (this.tenorDialog.getKit().getFileChooser() != null) {
            return this.tenorDialog.getKit().getFileChooser().getDialog();
        }
        return null;
    }
}

