/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.files;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.KostenFileFilter;
import eu.gronos.kostenrechner.controller.files.XmlTransferHandler;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.util.files.XJustizErrorHandler;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XjustizContentHandler
implements ContentHandler {
    private static final String INSTANZDATEN_TAG = "Instanzdaten";
    private static final String BETEILIGUNG_TAG = "Beteiligung";
    private static final String ROLLE_TAG = "Rolle";
    private static final String ROLLENBEZEICHNUNG_TAG = "Rollenbezeichnung";
    private static final String NR_TAG = "Nr";
    private static final String BETEILIGTER_TAG = "Beteiligter";
    private static final String GESCHLECHT_TAG = "Geschlecht";
    private static final String CONTENT_TAG = "content";
    private static final String GEGENSTANDSWERT_TAG = "Gegenstandswert";
    private static final String ZAHL_TAG = "Zahl";
    private static final String RECHTSFORM_TAG = "Rechtsform";
    private static final String AKTENZEICHEN_TAG = "Aktenzeichen";
    private static final String KLAEGER_CONTENT = "Kl\u00e4ger(in)";
    private static final String BEKLAGTER_CONTENT = "Beklagte(r)";
    private static final String DRITTWIDERBEKLAGTE_CONTENT = "Drittwiderbeklagte(r)";
    private static final String WIDERBEKLAGTE_CONTENT = "Widerbeklagte(r)";
    private static final String WIDERKLAEGER_CONTENT = "Widerkl\u00e4ger(in)";
    private static final String DRITTWIDERKLAEGER_CONTENT = "Drittwiderkl\u00e4ger(in)";
    private static final String MAENNLICH_CONTENT = "m\u00e4nnlich";
    private static final String WEIBLICH_CONTENT = "weiblich";
    private XMLReader xmlReader;
    private String xmlDatei;
    private int betZaehler;
    private boolean betOffen;
    private boolean rolleOffen;
    private ArrayList<String> beteiligterElemente;
    private ArrayList<String> rolleElemente;
    private boolean betrOffen;
    private String aktGenus;
    private ArrayList<String> aktRollen;
    private ArrayList<Integer> nrRollen;
    private Locator locator;
    private StringBuffer stringBuffer;
    private boolean instOffen;
    private ArrayList<String> instanzElemente;
    private Euro gegenstandswert;
    private BaumbachBeteiligtenListe klaeger;
    private BaumbachBeteiligtenListe drittwiderbeklagte;
    private BaumbachBeteiligtenListe beklagte;
    private String rechtsform;
    private String aktenzeichen;
    public static final KostenFileFilter XJUSTIZ_FILTER = new KostenFileFilter(null, "Xjustiz (XML)", "xml");

    public XjustizContentHandler(String uri) throws ParserConfigurationException, SAXException {
        this.xmlDatei = uri == null ? this.getClass().getClassLoader().getResource("resources/xjustizimport.xml").toString() : uri;
        this.xmlReader = this.setzeParser();
    }

    public static String vonPathNachURI(Path pfad) {
        if (pfad == null) {
            return null;
        }
        return pfad.toAbsolutePath().toUri().toString();
    }

    private XMLReader setzeParser() throws ParserConfigurationException, SAXException {
        XMLReader xmlReader = null;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(new XJustizErrorHandler());
        return xmlReader;
    }

    public void clearRecent() {
        this.aktGenus = null;
        this.rechtsform = null;
        if (this.aktRollen == null) {
            this.aktRollen = new ArrayList();
        } else {
            this.aktRollen.clear();
        }
        if (this.nrRollen == null) {
            this.nrRollen = new ArrayList();
        } else {
            this.nrRollen.clear();
        }
        this.stringBuffer = new StringBuffer();
    }

    private boolean istRechtsformGrammatikalischMaeenlich(String rechtsform) {
        boolean zwischen = false;
        String[] stringArray = new String[]{"B", "e.V.", "e.V. iL", "eK", "GemVerb", "GVV", "IV", "Kr", "KV", "L", "LV", "NaKV", "NaP", "Pfl", "Seq", "TV", "V", "VEB", "VglV", "VIV", "VVaG", "ZV"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String rf = stringArray[n2];
            if (rf.equals(rechtsform)) {
                zwischen = true;
            }
            ++n2;
        }
        return zwischen;
    }

    public VerfahrensDatenContainer parseXjustiz() throws IOException, SAXException {
        this.xmlReader.parse(this.xmlDatei);
        return new VerfahrensDatenContainer(this.klaeger, this.drittwiderbeklagte, this.beklagte, this.gegenstandswert, this.aktenzeichen, new XmlTransferHandler().speicherDatum());
    }

    @Override
    public void startDocument() throws SAXException {
        this.betZaehler = 0;
        this.clearRecent();
        this.betOffen = false;
        this.rolleOffen = false;
        this.beteiligterElemente = new ArrayList();
        this.rolleElemente = new ArrayList();
        this.klaeger = new BaumbachBeteiligtenListe();
        this.drittwiderbeklagte = new BaumbachBeteiligtenListe();
        this.beklagte = new BaumbachBeteiligtenListe();
        this.gegenstandswert = null;
        this.aktenzeichen = null;
        this.rechtsform = null;
    }

    @Override
    public void endDocument() throws SAXException {
        String str = "";
        if (this.betOffen) {
            str = String.valueOf(str) + "Eine Beteiligung war noch offen! ";
        }
        str = String.valueOf(str) + String.format("Anzahl der Beteiligungen: %d", this.betZaehler);
        Kostenrechner.getLogger().info(str);
        if (this.klaeger != null) {
            Collections.sort(this.klaeger);
        }
        if (this.drittwiderbeklagte != null) {
            Collections.sort(this.drittwiderbeklagte);
        }
        if (this.beklagte != null) {
            Collections.sort(this.beklagte);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.stringBuffer = new StringBuffer();
        if (BETEILIGUNG_TAG.equals(localName)) {
            this.betOffen = true;
            ++this.betZaehler;
            if (this.locator != null) {
                System.out.printf("Beteiligung Nr. %d beginnt bei Zeile %d, Spalte %d.%n", this.betZaehler, this.locator.getLineNumber(), this.locator.getColumnNumber() - localName.length() - 2);
            }
        } else if (this.betOffen) {
            if (ROLLE_TAG.equals(localName)) {
                this.rolleOffen = true;
                this.rolleElemente = new ArrayList();
            }
            if (this.rolleOffen && this.rolleElemente != null) {
                this.rolleElemente.add(localName);
            }
            if (!this.rolleOffen && BETEILIGTER_TAG.equals(localName)) {
                this.betrOffen = true;
                this.beteiligterElemente = new ArrayList();
                this.beteiligterElemente.add(localName);
            }
            if (this.betrOffen && this.beteiligterElemente != null) {
                this.beteiligterElemente.add(localName);
            }
        }
        if (INSTANZDATEN_TAG.equals(localName)) {
            this.instOffen = true;
            if (this.instanzElemente == null) {
                this.instanzElemente = new ArrayList();
            } else {
                this.instanzElemente.clear();
            }
        } else if (this.instOffen && this.instanzElemente != null) {
            this.instanzElemente.add(localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String content = this.stringBuffer.toString().trim();
        if (BETEILIGUNG_TAG.equals(localName)) {
            this.betOffen = false;
            this.rolleOffen = false;
            this.betrOffen = false;
            this.rolleElemente.clear();
            this.beteiligterElemente.clear();
            BaumbachBeteiligter bb = this.baueBeteiligten();
            if (bb != null) {
                switch (bb.getTyp()) {
                    case KLAEGER: {
                        this.klaeger.add(bb);
                        System.out.println("Kl\u00e4ger/in gefunden!");
                        break;
                    }
                    case DRITTWIDERBEKLAGTE: {
                        this.drittwiderbeklagte.add(bb);
                        System.out.println("Drittwiderbeklagte/n gefunden!");
                        break;
                    }
                    default: {
                        this.beklagte.add(bb);
                        System.out.println("Beklagte/n gefunden!");
                    }
                }
            }
            this.clearRecent();
            if (this.locator != null) {
                String str = String.format("Beteiligung Nr. %d endet bei Zeile %d, Spalte %d.%n", this.betZaehler, this.locator.getLineNumber(), this.locator.getColumnNumber());
                Kostenrechner.getLogger().info(str);
            }
        }
        if (ROLLE_TAG.equals(localName)) {
            this.rolleOffen = false;
            this.rolleElemente.clear();
        }
        if (BETEILIGTER_TAG.equals(localName)) {
            this.betrOffen = false;
            this.beteiligterElemente.clear();
        }
        if (ZAHL_TAG.equals(localName) && this.instOffen && this.instanzElemente != null && this.instanzElemente.size() > 1) {
            int size = this.instanzElemente.size();
            if (GEGENSTANDSWERT_TAG.equals(this.instanzElemente.get(size - 2))) {
                Kostenrechner.getLogger().info("Gegenstandswert: " + content);
            }
            try {
                this.gegenstandswert = Euro.ofEuros(Double.parseDouble(content));
            }
            catch (NumberFormatException e) {
                Kostenrechner.getLogger().log(Level.WARNING, "Gegenstandswert konnte nicht konvertiert werden: " + e.getLocalizedMessage(), e);
            }
        }
        if (AKTENZEICHEN_TAG.equals(localName) && this.instOffen) {
            this.aktenzeichen = this.aktenzeichen == null ? content : String.valueOf(this.aktenzeichen) + " bzw. " + content;
            Kostenrechner.getLogger().info("Aktenzeichen: " + this.aktenzeichen);
        }
        if (INSTANZDATEN_TAG.equals(localName)) {
            this.instOffen = false;
            this.instanzElemente.clear();
        }
        if (NR_TAG.equals(localName) && this.betOffen && this.rolleOffen) {
            int parseInt;
            try {
                parseInt = Integer.parseInt(content);
            }
            catch (NumberFormatException e) {
                Kostenrechner.getLogger().log(Level.WARNING, e.getLocalizedMessage());
                parseInt = this.nrRollen.size();
            }
            if (this.nrRollen.size() >= this.aktRollen.size() && this.nrRollen.get(this.nrRollen.size() - 1) == null) {
                this.nrRollen.set(this.nrRollen.size() - 1, parseInt);
            } else {
                this.nrRollen.add(parseInt);
            }
        }
        if (CONTENT_TAG.equals(localName)) {
            int size;
            if (this.betOffen && this.rolleElemente != null && this.rolleElemente.size() > 1 && ROLLENBEZEICHNUNG_TAG.equals(this.rolleElemente.get((size = this.rolleElemente.size()) - 2)) && content != null && content.length() > 0) {
                this.aktRollen.add(content);
                if (this.nrRollen.size() < this.aktRollen.size()) {
                    this.nrRollen.add(null);
                }
            }
            if (this.betrOffen && this.beteiligterElemente != null && this.beteiligterElemente.size() > 1) {
                size = this.beteiligterElemente.size();
                if (GESCHLECHT_TAG.equals(this.beteiligterElemente.get(size - 2)) && content != null && content.length() > 0) {
                    this.aktGenus = content;
                }
                if (RECHTSFORM_TAG.equals(this.beteiligterElemente.get(size - 2)) && content != null && content.length() > 0) {
                    this.rechtsform = content;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stringBuffer == null) {
            this.stringBuffer = new StringBuffer(String.copyValueOf(ch, start, length));
        } else {
            this.stringBuffer.append(ch, start, length);
        }
    }

    BaumbachBeteiligter baueBeteiligten() {
        BaumbachBeteiligter bb = null;
        Beteiligter.BeteiligtenTyp typ = null;
        Beteiligter.GenusNumerus genusNumerus = null;
        int lfdNr = -1;
        boolean anWiderklageBeteiligt = false;
        String zwischen = "";
        if (this.aktRollen.contains(DRITTWIDERBEKLAGTE_CONTENT) || this.aktRollen.contains(WIDERBEKLAGTE_CONTENT) || this.aktRollen.contains(DRITTWIDERKLAEGER_CONTENT) || this.aktRollen.contains(WIDERKLAEGER_CONTENT)) {
            anWiderklageBeteiligt = true;
        }
        if (this.aktRollen.contains(KLAEGER_CONTENT)) {
            typ = Beteiligter.BeteiligtenTyp.KLAEGER;
            lfdNr = this.nrRollen.get(this.aktRollen.indexOf(KLAEGER_CONTENT));
        } else if (this.aktRollen.contains(BEKLAGTER_CONTENT)) {
            typ = Beteiligter.BeteiligtenTyp.BEKLAGTE;
            lfdNr = this.nrRollen.get(this.aktRollen.indexOf(BEKLAGTER_CONTENT));
        } else if (this.aktRollen.contains(DRITTWIDERBEKLAGTE_CONTENT)) {
            typ = Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE;
            lfdNr = this.nrRollen.get(this.aktRollen.indexOf(DRITTWIDERBEKLAGTE_CONTENT));
        } else if (!this.aktRollen.contains(KLAEGER_CONTENT) && this.aktRollen.contains(WIDERBEKLAGTE_CONTENT)) {
            typ = Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE;
            lfdNr = this.nrRollen.get(this.aktRollen.indexOf(WIDERBEKLAGTE_CONTENT));
        }
        for (String st : this.aktRollen) {
            zwischen = String.valueOf(zwischen) + st + ", ";
        }
        Kostenrechner.getLogger().info("Rolle(n): " + zwischen);
        if (MAENNLICH_CONTENT.equals(this.aktGenus)) {
            Kostenrechner.getLogger().info("Geschlecht: m\u00e4nnlich.");
            genusNumerus = Beteiligter.GenusNumerus.MAENNLICH_SINGULAR;
        } else if (WEIBLICH_CONTENT.equals(this.aktGenus)) {
            Kostenrechner.getLogger().info("Geschlecht: weiblich.");
            genusNumerus = Beteiligter.GenusNumerus.WEIBLICH_SINGULAR;
        } else if (this.rechtsform != null && this.istRechtsformGrammatikalischMaeenlich(this.rechtsform)) {
            Kostenrechner.getLogger().info("Geschlecht: m\u00e4nnlich (Organisation).");
            genusNumerus = Beteiligter.GenusNumerus.MAENNLICH_SINGULAR;
        } else {
            Kostenrechner.getLogger().info("Geschlecht: unbekannt?");
            genusNumerus = Beteiligter.GenusNumerus.WEIBLICH_SINGULAR;
        }
        if (typ != null) {
            Euro streitwert;
            Kostenrechner.getLogger().info(String.format("Typ: %d, genusNumerus: %d, lfdNr: %d, anWiderklageBeteiligt: %s, ", new Object[]{typ, genusNumerus, lfdNr, anWiderklageBeteiligt}));
            if (typ == Beteiligter.BeteiligtenTyp.BEKLAGTE || typ == Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE || typ == Beteiligter.BeteiligtenTyp.KLAEGER && anWiderklageBeteiligt) {
                streitwert = this.gegenstandswert;
                Kostenrechner.getLogger().info(String.format("Streitwert: %,.2f EUR.%n", this.gegenstandswert));
            } else {
                streitwert = Euro.ZERO_CENTS;
            }
            bb = new BaumbachBeteiligter(typ, genusNumerus, streitwert, Euro.ZERO_CENTS, anWiderklageBeteiligt);
            bb.setLfdNr(lfdNr);
        }
        return bb;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        Kostenrechner.getLogger().info("Folgender Locator wird gesetzt: " + locator.toString());
        this.locator = locator;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

