/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.files;

import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenXJustizLesenAction;
import eu.gronos.kostenrechner.controller.files.XjustizContentHandler;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.util.files.BerechnungXmlDatei;
import eu.gronos.kostenrechner.util.files.TenorXmlDatei;
import eu.gronos.kostenrechner.view.RechnerhammerIcons;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;
import eu.gronos.kostenrechner.view.forderungen.ForderungsStaffelungPanel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;
import eu.gronos.kostenrechner.view.menus.ExtrasJMenu;
import eu.gronos.kostenrechner.view.result.TenorDialog;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XmlTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 8733776081066774904L;
    private static final String FEHLER_KEINE_XML_DATEI = "Keine XML-Datei!";
    private static final String FEHLER_MEHRERE_DATEIEN = "Mehr als eine oder keine Datei im Zugriff!";

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean copySupported;
        if (support.isDrop()) {
            support.setShowDropLocation(false);
        }
        if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Kostenrechner.getLogger().info("Flavor not supported: javaFileListFlavor!");
            return false;
        }
        boolean bl = copySupported = (1 & support.getSourceDropActions()) == 1;
        if (!copySupported) {
            Kostenrechner.getLogger().info("COPY not supported!");
            return false;
        }
        support.setDropAction(1);
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) throws NullPointerException {
        block9: {
            List list;
            block8: {
                if (!this.canImport(support)) {
                    return false;
                }
                Transferable t = support.getTransferable();
                List o = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (!(o instanceof List)) {
                    return false;
                }
                list = o;
                if (list != null && list.size() == 1) break block8;
                FehlerHelper.zeigeFehler(FEHLER_MEHRERE_DATEIEN, new IOException(FEHLER_MEHRERE_DATEIEN));
                return false;
            }
            Path xml = ((File)list.get(0)).toPath();
            if (!this.isXml(xml) && !this.isBerechnung(xml)) break block9;
            Kostenrechner.getLogger().info("(isXml(xml) || isBerechnung(xml))");
            SwingUtilities.invokeLater(() -> this.nimmXmlDatei(xml));
            Kostenrechner.getLogger().info("return true;");
            return true;
        }
        try {
            FehlerHelper.zeigeFehler(FEHLER_KEINE_XML_DATEI, new IOException(FEHLER_KEINE_XML_DATEI));
            return false;
        }
        catch (UnsupportedFlavorException e) {
            FehlerHelper.zeigeFehler("Flavor not supported. " + e.getLocalizedMessage(), e);
            return false;
        }
        catch (IOException e) {
            FehlerHelper.zeigeFehler("Data is no longer available in the requested flavor. " + e.getLocalizedMessage(), e);
            return false;
        }
    }

    @Override
    public Image getDragImage() {
        return (Image)RechnerhammerIcons.getInstance().get(4);
    }

    public VerfahrensDatenContainer liesAlleWertefuerContainer() {
        VerfahrensDatenContainer container = new VerfahrensDatenContainer();
        container.allgemein = ExtrasJMenu.getInstance().baueRueckgabewert();
        container.teilklageruecknahme = TeilklageruecknahmePanel.getInstance().baueRueckgabewert();
        container.streitgenossen = StreitgenossenPanel.getInstance().baueRueckgabewert();
        container.staffelung = ForderungsStaffelungPanel.getInstance().baueRueckgabewert();
        container.gebuehrenBerechnung = GebuehrenBerechnungPanel.getInstance().baueRueckgabewert();
        container.setzeStreitwertInAllgemein();
        return container;
    }

    public void nimmXmlDatei(Path xml) {
        VerfahrensDatenContainer container = null;
        if (xml != null) {
            Kostenrechner.getLogger().info("nimmXmlDatei");
            if (this.isXml(xml)) {
                container = new StreitgenossenXJustizLesenAction(StreitgenossenPanel.getInstance(), Kostenrechner.getInstance(), (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(39211)).xJustizLesen(xml);
                if (container != null) {
                    if (container.allgemein != null) {
                        ExtrasJMenu.getInstance().setzeWerte(container.allgemein);
                    }
                    if (container.streitgenossen != null) {
                        StreitgenossenPanel.getInstance().setzeWerte(container.streitgenossen);
                    }
                }
            } else if (this.isBerechnung(xml) && (container = TenorXmlDatei.createInstanceFor(xml).ladeXml(xml)) != null) {
                this.setzeAlleWerteAusContainer(container);
                if (container instanceof TenorDatenContainer) {
                    new TenorDialog(Kostenrechner.getInstance(), (TenorDatenContainer)container).showDialog();
                }
            }
        }
    }

    public void setzeAlleWerteAusContainer(VerfahrensDatenContainer container) {
        Kostenrechner.getLogger().info(container.createFileInfo());
        container.allgemein.selectedPanel = this.getSelectedPanel(container);
        Kostenrechner.getLogger().info("container.allgemein");
        ExtrasJMenu.getInstance().setzeWerte(container.allgemein);
        Kostenrechner.getLogger().info("container.teilklageruecknahme");
        TeilklageruecknahmePanel.getInstance().setzeWerte(container.teilklageruecknahme);
        Kostenrechner.getLogger().info("container.streitgenossen");
        StreitgenossenPanel.getInstance().setzeWerte(container.streitgenossen);
        Kostenrechner.getLogger().info("container.staffelung");
        ForderungsStaffelungPanel.getInstance().setzeWerte(container.staffelung);
        Kostenrechner.getLogger().info("container.gebuehrenBerechnung");
        GebuehrenBerechnungPanel.getInstance().setzeWerte(container.gebuehrenBerechnung);
    }

    public XMLGregorianCalendar speicherDatum() {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            return factory.newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException dce) {
            FehlerHelper.zeigeFehler("Schwerer Fehler beim Konfigurieren der Zeit!", dce);
            return null;
        }
    }

    public int getSelectedPanel(VerfahrensDatenContainer container) {
        if (container.allgemein.selectedPanel > -1) {
            return container.allgemein.selectedPanel;
        }
        if (!container.teilklageruecknahme.isEmpty()) {
            return 0;
        }
        if (!container.streitgenossen.isEmpty()) {
            return 1;
        }
        if (!container.staffelung.isEmpty()) {
            return 2;
        }
        if (!container.gebuehrenBerechnung.isEmpty()) {
            return 3;
        }
        return container.allgemein.selectedPanel;
    }

    private boolean isBerechnung(Path datei) {
        return BerechnungXmlDatei.DATEI_FILTER.acceptExtension(datei);
    }

    private boolean isXml(Path datei) {
        return XjustizContentHandler.XJUSTIZ_FILTER.acceptExtension(datei);
    }
}

