/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.files;

import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.util.files.BerechnungXmlDatei;
import eu.gronos.kostenrechner.util.files.TenorXmlDatei;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.Deflater;

public class ZipContainerXmlStrings {
    final VerfahrensDatenContainer verfahren;
    final TenorDatenContainer tenor;
    final Deflater compresser;

    public ZipContainerXmlStrings(VerfahrensDatenContainer verfahrensDatenContainer, TenorDatenContainer tenorDatenContainer) {
        this.verfahren = verfahrensDatenContainer;
        this.tenor = tenorDatenContainer;
        this.compresser = new Deflater(9);
    }

    public byte[] zippedBytes() {
        BerechnungXmlDatei vdcXml = new BerechnungXmlDatei();
        TenorXmlDatei tdcXml = new TenorXmlDatei();
        String xmlString = String.valueOf(vdcXml.toXmlString(this.verfahren)) + "\n" + tdcXml.toXmlString(this.tenor);
        this.compresser.setInput(xmlString.getBytes());
        this.compresser.finish();
        byte[] output = new byte[this.compresser.getTotalOut()];
        this.compresser.deflate(output);
        return output;
    }

    public File speicherTempZip() throws IOException {
        String suffix = "xmlzip";
        Path path = Files.createTempFile(null, "xmlzip", new FileAttribute[0]);
        File datei = path.toFile();
        this.speicherZip(datei);
        return datei;
    }

    private boolean speicherZip(File file) {
        block13: {
            byte[] data = this.zippedBytes();
            Throwable throwable = null;
            Object var4_7 = null;
            FileOutputStream stream = new FileOutputStream(file);
            try {
                stream.write(data);
                stream.flush();
                if (stream == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException e) {
                    FehlerHelper.zeigeFehler("Fehler beim Speichern einer ZIP-Datei:\nDie ZIP-Datei konnte nicht gefunden werden", e);
                    return false;
                }
                catch (IOException e) {
                    FehlerHelper.zeigeFehler(String.format("Fehler beim Speichern einer ZIP-Datei:%nDie ZIP-Datei konnte nicht gespeichert werden: %s", file.getAbsolutePath()), e);
                    return false;
                }
            }
            stream.close();
        }
        return true;
    }
}

