/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.forderungen;

import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.util.forderungen.ForderungPruefer;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

public class ForderungParser
implements ParsendUndBauend<Forderung> {
    private JComboBox<Forderung> cmbForderungsart;
    private JFormattedTextField ftfStreitwert;
    private JFormattedTextField ftfUnterliegen;
    private Forderung rueckgabewert;

    @Override
    public ParsendUndBauend<Forderung> leseComponents(Component ... components) {
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                JComponent component = (JComponent)comp;
                if ("45015".equals(component.getName())) {
                    this.cmbForderungsart = (JComboBox)component;
                } else if ("45025".equals(component.getName())) {
                    this.ftfStreitwert = (JFormattedTextField)component;
                } else if ("45035".equals(component.getName())) {
                    this.ftfUnterliegen = (JFormattedTextField)component;
                }
                ++n2;
            }
        }
        return this;
    }

    @Override
    public boolean parseEingabe() {
        try {
            this.rueckgabewert = this.leseFelder();
            return this.parseEingabe(this.rueckgabewert);
        }
        catch (IllegalArgumentException | NullPointerException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
    }

    @Override
    public boolean parseEingabe(Forderung forderung) throws IllegalArgumentException, NumberFormatException, NullPointerException {
        this.rueckgabewert = forderung;
        ForderungPruefer pruefer = new ForderungPruefer();
        return pruefer.pruefeEingabe(forderung);
    }

    @Override
    public Forderung getRueckgabewert() {
        return this.rueckgabewert;
    }

    private Forderung leseFelder() throws NumberFormatException, NullPointerException {
        this.rueckgabewert = (Forderung)this.cmbForderungsart.getSelectedItem();
        if (this.rueckgabewert == null) {
            throw new NullPointerException("Keine Forderungsart ausgew\u00e4hlt. W\u00e4hlen Sie bitte eine Forderungsart aus!");
        }
        Double wert = new NumberExtractor(this.ftfStreitwert, this.ftfStreitwert.getAccessibleContext().getAccessibleName()).extractDouble();
        Double erfolg = new NumberExtractor(this.ftfUnterliegen, this.ftfUnterliegen.getAccessibleContext().getAccessibleName()).extractDouble();
        this.rueckgabewert.setAntrag(Euro.ofEuros(wert));
        this.rueckgabewert.setErfolg(Euro.ofEuros(erfolg));
        return this.rueckgabewert;
    }
}

