/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.forderungen;

import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.forderungen.ForderungenTableModel;
import eu.gronos.kostenrechner.util.forderungen.ForderungsStaffelungPruefer;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;

public class ForderungsStaffelungParser
implements ParsendUndBauend<ForderungsStaffelung> {
    private ForderungsStaffelung rueckgabewert;
    private JComboBox<Beteiligter> cbAngriffsKlaeger;
    private JComboBox<Beteiligter> cbVerteidigungsBeklagter;
    private JTable tbForderungen;
    private final boolean streng;

    public ForderungsStaffelungParser() {
        this(false);
    }

    public ForderungsStaffelungParser(boolean streng) {
        this.streng = streng;
    }

    @Override
    public ParsendUndBauend<ForderungsStaffelung> leseComponents(Component ... components) {
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                JComponent component = (JComponent)comp;
                if ("41005".equals(component.getName())) {
                    this.cbAngriffsKlaeger = (JComboBox)component;
                } else if ("41015".equals(component.getName())) {
                    this.cbVerteidigungsBeklagter = (JComboBox)component;
                } else if ("42011".equals(component.getName())) {
                    this.tbForderungen = (JTable)component;
                }
                ++n2;
            }
        }
        return this;
    }

    @Override
    public boolean parseEingabe() {
        try {
            this.rueckgabewert = this.leseFelder();
            if (this.streng) {
                return this.parseEingabe(this.rueckgabewert);
            }
            return true;
        }
        catch (IllegalArgumentException | NullPointerException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
    }

    @Override
    public boolean parseEingabe(ForderungsStaffelung rueckgabewert) throws IllegalArgumentException, NullPointerException {
        this.rueckgabewert = rueckgabewert;
        ForderungsStaffelungPruefer pruefer = new ForderungsStaffelungPruefer();
        return pruefer.pruefeEingabe(rueckgabewert);
    }

    @Override
    public ForderungsStaffelung getRueckgabewert() {
        return this.rueckgabewert;
    }

    private ForderungsStaffelung leseFelder() throws NullPointerException {
        this.rueckgabewert = new ForderungsStaffelung();
        this.rueckgabewert.parteien.add((Beteiligter)this.cbAngriffsKlaeger.getSelectedItem());
        this.rueckgabewert.parteien.add((Beteiligter)this.cbVerteidigungsBeklagter.getSelectedItem());
        ForderungenTableModel ftm = (ForderungenTableModel)this.tbForderungen.getModel();
        this.rueckgabewert.forderungen = ftm.getAllValues();
        return this.rueckgabewert;
    }
}

