/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.VorsorgendeBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenGesetzesSammlung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenVerzeichnis;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.PanelTableModelHandler;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrHinzufuegenDialog;
import java.awt.event.ActionEvent;

public class GebuehrNeuAction
extends BeschriebeneAktion
implements AbfrageLieferant<GebuehrHinzufuegenDialog> {
    private final PanelTableModelHandler<GebuehrenTableModel> panel;
    private static final long serialVersionUID = 7170038539836176410L;
    private final int index;
    private GebuehrenVerzeichnis alleTatbestaende;
    private GebuehrHinzufuegenDialog dialog = null;
    private final int gebuehrenKey;
    public static final int RVG_KEY = 32;
    public static final int GKG_KEY = 64;
    public static final int ALLE_KEY = 96;

    public GebuehrNeuAction(PanelTableModelHandler<GebuehrenTableModel> panel, LangBeschriftung beschriftung, int index, int gebuehrenKey) {
        super(beschriftung);
        this.panel = panel;
        this.index = index;
        this.gebuehrenKey = gebuehrenKey;
    }

    public GebuehrNeuAction(PanelTableModelHandler<GebuehrenTableModel> panel, LangBeschriftung beschriftung, int index) {
        this(panel, beschriftung, index, 96);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String name = (String)this.getValue("Name");
        VorsorgendeBeschriftung vorsorgend = (VorsorgendeBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(16000);
        ComponentBeschrifter beschrifter = new ComponentBeschrifter();
        beschrifter.changeTo(vorsorgend, 0);
        beschrifter.changeTo(vorsorgend, name);
        GebuehrenTatbestand gt = (GebuehrenTatbestand)this.setDialog(new GebuehrHinzufuegenDialog(Kostenrechner.getInstance(), vorsorgend, this.getAlleTatbestaende())).showDialogAndAsk();
        if (gt != null) {
            this.panel.getTableModel(this.index).addRow(gt);
        }
        this.setDialog(null);
    }

    @Override
    public GebuehrHinzufuegenDialog getDialog() {
        return this.dialog;
    }

    private GebuehrenVerzeichnis getAlleTatbestaende() {
        if (this.alleTatbestaende == null) {
            this.alleTatbestaende = 32 == this.gebuehrenKey ? GebuehrenGesetzesSammlung.getRvg().getVerzeichnis() : (64 == this.gebuehrenKey ? GebuehrenGesetzesSammlung.getGkg().getVerzeichnis() : GebuehrNeuAction.createAlleGebuehrenTatbestaende());
        }
        return this.alleTatbestaende;
    }

    private GebuehrHinzufuegenDialog setDialog(GebuehrHinzufuegenDialog dialog) {
        this.dialog = dialog;
        return dialog;
    }

    private static GebuehrenVerzeichnis createAlleGebuehrenTatbestaende() {
        GebuehrenVerzeichnis verzeichnis = new GebuehrenVerzeichnis();
        verzeichnis.putAll(GebuehrenGesetzesSammlung.getGkg().getVerzeichnis());
        verzeichnis.putAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis());
        return verzeichnis;
    }
}

