/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.gebuehren.AuslagenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAnrechnungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenErhoehungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenRahmenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.MehrfachPauschalTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.PauschalTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.util.gebuehren.GebuehrenPruefer;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;

public class GebuehrenParser
implements ParsendUndBauend<GebuehrenTatbestand> {
    private JFormattedTextField ftfAuslagenHoehe;
    private JLabel lblAuslagenHoehe;
    private JList<GebuehrenTatbestand> liGebuehrenListe;
    private GebuehrenTatbestand rueckgabewert;

    @Override
    public ParsendUndBauend<GebuehrenTatbestand> leseComponents(Component ... components) {
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                JComponent component = (JComponent)comp;
                if ("16035".equals(component.getName())) {
                    this.ftfAuslagenHoehe = (JFormattedTextField)component;
                } else if ("16021".equals(component.getName())) {
                    this.liGebuehrenListe = (JList)component;
                } else if ("16031".equals(component.getName())) {
                    this.lblAuslagenHoehe = (JLabel)component;
                }
                ++n2;
            }
        }
        return this;
    }

    @Override
    public boolean parseEingabe() {
        try {
            this.rueckgabewert = this.leseFelder();
            this.parseEingabe(this.rueckgabewert);
        }
        catch (NullPointerException | NumberFormatException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
        return true;
    }

    @Override
    public boolean parseEingabe(GebuehrenTatbestand gt) throws NumberFormatException, NullPointerException {
        this.rueckgabewert = gt;
        return new GebuehrenPruefer().pruefeEingabe(this.rueckgabewert);
    }

    @Override
    public GebuehrenTatbestand getRueckgabewert() {
        return this.rueckgabewert;
    }

    public GebuehrenTatbestand getSelectedItem() {
        if (this.liGebuehrenListe.getSelectedIndex() < 0) {
            return null;
        }
        return this.liGebuehrenListe.getModel().getElementAt(this.liGebuehrenListe.getSelectedIndex());
    }

    private GebuehrenTatbestand leseFelder() throws NumberFormatException, NullPointerException {
        this.rueckgabewert = this.getSelectedItem();
        NumberExtractor extractor = new NumberExtractor(this.ftfAuslagenHoehe, this.lblAuslagenHoehe.getText());
        if (this.rueckgabewert == null) {
            throw new NullPointerException("Kein Geb\u00fchrentatbestand ausgew\u00e4hlt. W\u00e4hlen Sie bitte einen Geb\u00fchrentatbestand aus!");
        }
        if (this.rueckgabewert instanceof MehrfachPauschalTatbestand && ((MehrfachPauschalTatbestand)this.rueckgabewert).getAnzahl() < 0) {
            int anzahl = extractor.extractInteger();
            this.rueckgabewert = ((MehrfachPauschalTatbestand)this.rueckgabewert).clone();
            ((MehrfachPauschalTatbestand)this.rueckgabewert).setAnzahl(anzahl);
        } else if (this.rueckgabewert instanceof AuslagenTatbestand && (((AuslagenTatbestand)this.rueckgabewert).getBetrag() == null || ((AuslagenTatbestand)this.rueckgabewert).getBetrag().compareTo(Euro.ofCents(0L)) < 0)) {
            double auslagen = extractor.extractDouble();
            System.out.println("Auslagen: " + auslagen);
            this.rueckgabewert = ((AuslagenTatbestand)this.rueckgabewert).clone();
            ((AuslagenTatbestand)this.rueckgabewert).setBetrag(Euro.ofEuros(auslagen));
            System.out.println("AuslagenBetrag: " + ((AuslagenTatbestand)this.rueckgabewert).getBetrag());
        } else if (this.rueckgabewert instanceof PauschalTatbestand) {
            this.rueckgabewert = (PauschalTatbestand)this.rueckgabewert;
        } else if (this.rueckgabewert instanceof GebuehrenErhoehungsTatbestand && ((GebuehrenErhoehungsTatbestand)this.rueckgabewert).getAnzahl() < 0) {
            int anzahl = extractor.extractInteger();
            this.rueckgabewert = ((GebuehrenErhoehungsTatbestand)this.rueckgabewert).clone();
            ((GebuehrenErhoehungsTatbestand)this.rueckgabewert).setAnzahl(anzahl);
        } else if (this.rueckgabewert instanceof GebuehrenAnrechnungsTatbestand) {
            double satz = extractor.extractDouble();
            this.rueckgabewert = ((GebuehrenAnrechnungsTatbestand)this.rueckgabewert).clone();
            ((GebuehrenAnrechnungsTatbestand)this.rueckgabewert).setSatz(satz);
        } else if (this.rueckgabewert instanceof GebuehrenRahmenTatbestand) {
            double satz = extractor.extractDouble();
            this.rueckgabewert = ((GebuehrenRahmenTatbestand)this.rueckgabewert).clone();
            ((GebuehrenRahmenTatbestand)this.rueckgabewert).setSatz(satz);
        }
        return this.rueckgabewert;
    }
}

