/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.kostenrechner.controller.AllzweckHorcher;
import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.model.gebuehren.StreitwertTableModel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;

public class GebuehrenStreitwertHorcher
extends AllzweckHorcher {
    private GebuehrenBerechnungPanel panel;
    private String beschriftung;

    public GebuehrenStreitwertHorcher(GebuehrenBerechnungPanel panel, String beschriftung) {
        this.panel = panel;
        this.beschriftung = beschriftung;
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        Object source = ke.getSource();
        if (ke.getKeyCode() == 10) {
            if (source instanceof JTable) {
                SwingUtilities.invokeLater(() -> this.ftfAnTableAnpassen((JTable)source));
            } else if (source instanceof JFormattedTextField) {
                SwingUtilities.invokeLater(() -> this.tableAnFtfAnpassen((JFormattedTextField)source, this.beschriftung));
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        this.keyReleased(ke);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        Object source = me.getSource();
        if (source instanceof JTable && me.getClickCount() > 1) {
            this.ftfAnTableAnpassen((JTable)source);
        }
    }

    @Override
    public void focusLost(FocusEvent fe) {
        Object source = fe.getSource();
        if (source instanceof JTable) {
            SwingUtilities.invokeLater(() -> this.ftfAnTableAnpassen((JTable)source));
        } else if (source instanceof JFormattedTextField) {
            SwingUtilities.invokeLater(() -> this.tableAnFtfAnpassen((JFormattedTextField)source, this.beschriftung));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        Object source = lse.getSource();
        if (source instanceof ListSelectionModel) {
            this.ftfAnTableAnpassen(this.panel.getTabStreitwertTabelle());
        }
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        this.panel.errechneGebuehrenSumme();
    }

    private void tableAnFtfAnpassen(JFormattedTextField ftf, String beschriftung) {
        if (!(this.panel.getTabStreitwertTabelle().getModel() instanceof StreitwertTableModel)) {
            this.panel.initStreitwertTable();
        }
        Euro streitwert = Euro.ofCents(0L);
        if (ftf.isEditValid()) {
            try {
                streitwert = Euro.ofEuros(new NumberExtractor(ftf, beschriftung).extractLong());
                int zeile = ((StreitwertTableModel)this.panel.getTabStreitwertTabelle().getModel()).rowAtStreitwert(streitwert);
                if (zeile > -1) {
                    this.panel.getTabStreitwertTabelle().changeSelection(zeile, -1, false, false);
                }
                this.panel.errechneGebuehrenSumme();
            }
            catch (NumberFormatException e) {
                FehlerHelper.zeigeFehler("Falsches Eingabeformat!", e);
            }
        }
    }

    private void ftfAnTableAnpassen(JTable table) {
        int selectedRow;
        if (!(table.getModel() instanceof StreitwertTableModel)) {
            this.panel.initStreitwertTable();
        }
        if ((selectedRow = table.getSelectedRow()) < 0) {
            return;
        }
        Euro valueAt = (Euro)table.getModel().getValueAt(selectedRow, 0);
        System.out.println("valueAt:" + valueAt);
        this.panel.getFormattedTextField(5).setText(Long.toString(valueAt.longValue()));
        this.panel.errechneGebuehrenSumme();
    }
}

