/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenDragListener;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenTransferable;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class GebuehrenTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -35313196581225380L;

    public GebuehrenTransferHandler(JTable table) {
        table.setDragEnabled(true);
        table.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        table.setFillsViewportHeight(true);
        table.addMouseMotionListener(new GebuehrenDragListener());
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent ie, int action) {
        super.exportAsDrag(comp, ie, action);
    }

    @Override
    public int getSourceActions(JComponent comp) {
        return 2;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        if (this.isJTableValidSource(c)) {
            JTable t = (JTable)c;
            GebuehrenTableModel gttm = (GebuehrenTableModel)t.getModel();
            return new GebuehrenTransferable(gttm.getRow(t.getSelectedRow()));
        }
        return null;
    }

    @Override
    public void exportDone(JComponent source, Transferable data, int action) {
        if (this.isJTableValidSource(source) && action == 2) {
            JTable t = (JTable)source;
            GebuehrenTableModel model = (GebuehrenTableModel)t.getModel();
            model.removeRow(t.getSelectedRow());
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.isDrop()) {
            support.setShowDropLocation(true);
        }
        if (!support.isDataFlavorSupported(GebuehrenTransferable.GEBUEHREN_FLAVOR)) {
            Kostenrechner.getLogger().info(String.format("Flavor not supported: %s!", GebuehrenTransferable.GEBUEHREN_FLAVOR.toString()));
            return false;
        }
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) throws NullPointerException {
        if (support == null) {
            throw new NullPointerException("TransferSupport ist null!");
        }
        if (!this.isJTableValid((JComponent)support.getComponent())) {
            return false;
        }
        if (!this.canImport(support)) {
            return false;
        }
        String woNull = "(?)";
        try {
            GebuehrenTableModel gttm;
            GebuehrenTatbestand gt = (GebuehrenTatbestand)support.getTransferable().getTransferData(GebuehrenTransferable.GEBUEHREN_FLAVOR);
            JTable table = (JTable)support.getComponent();
            if (table == null) {
                woNull = "table";
            }
            if ((gttm = (GebuehrenTableModel)table.getModel()) == null) {
                woNull = "gttm";
            }
            int dropPoint = -1;
            if (support.isDrop()) {
                JTable.DropLocation dropLocation = (JTable.DropLocation)support.getDropLocation();
                dropPoint = dropLocation.getRow();
            }
            if (dropPoint > -1 && dropPoint < gttm.getRowCount()) {
                gttm.addRowAt(dropPoint, gt);
            } else {
                gttm.addRow(gt);
            }
            return true;
        }
        catch (Exception e) {
            FehlerHelper.zeigeFehler(String.format("Fehler beim Geb\u00fchrenkopieren: Fehler (%s) beim Kopieren eines Geb\u00fchrentatbestands (%s): %s", e.getClass().toString(), woNull, e.getLocalizedMessage()), e);
            return false;
        }
    }

    private boolean isJTableValidSource(JComponent comp) {
        return this.isJTableValid(comp) && ((JTable)comp).getSelectedRow() >= 0;
    }

    private boolean isJTableValid(JComponent comp) {
        return comp != null && comp instanceof JTable && ((JTable)comp).getModel() instanceof GebuehrenTableModel;
    }
}

