/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class GebuehrenTransferable
implements Transferable {
    private final GebuehrenTatbestand gt;
    static final DataFlavor GEBUEHREN_FLAVOR = GebuehrenTransferable.getDataFlavor();

    private static DataFlavor getDataFlavor() {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref;class=eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand");
        }
        catch (ClassNotFoundException e) {
            FehlerHelper.zeigeFehler(String.format("Klasse nicht gefunden: GebuehrenTatbestand (%s)", e.getLocalizedMessage()), e);
            return null;
        }
    }

    public GebuehrenTransferable(GebuehrenTatbestand gt) {
        this.gt = gt;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.getGt();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{GEBUEHREN_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return GEBUEHREN_FLAVOR.equals(flavor);
    }

    private GebuehrenTatbestand getGt() {
        return this.gt;
    }
}

