/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.baumbach;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.baumbach.MehrfachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.EuroAdapter;
import eu.gronos.kostenrechner.interfaces.AntragErfolgElement;
import eu.gronos.kostenrechner.interfaces.EnumString;
import eu.gronos.kostenrechner.interfaces.ParteiBeziehung;
import eu.gronos.kostenrechner.logic.TenorToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Angriff
implements Comparable<Angriff>,
ParteiBeziehung<List<Beteiligter>>,
AntragErfolgElement {
    private List<Beteiligter> angreifer = new ArrayList<Beteiligter>();
    private List<Beteiligter> gegner = new ArrayList<Beteiligter>();
    private Euro antrag;
    private Euro erfolg;
    private boolean gesamtSchuldnerisch;

    public String toString() {
        StringBuilder builder = new StringBuilder(this.formatTitle());
        builder.append(this.formatErfolg());
        return builder.toString();
    }

    private CharSequence formatTitle() {
        StringBuilder builder = new StringBuilder(this.formatAngreifer());
        builder.append(String.valueOf(TenorToken.GEGEN.toString()) + TenorToken.LEER);
        builder.append(this.formatGegner());
        builder.append(this.formatAntrag());
        return builder;
    }

    @Override
    @XmlElementWrapper(name="angreiferlein")
    @XmlIDREF
    @XmlElement
    public List<Beteiligter> getAngreifer() {
        return this.angreifer;
    }

    @Override
    public void setAngreifer(List<Beteiligter> angreifer) {
        this.angreifer.clear();
        this.angreifer.addAll(angreifer);
    }

    private CharSequence formatAngreifer() {
        StringBuilder builder = new StringBuilder();
        Iterator iterator = this.getAngreifer().iterator();
        while (iterator.hasNext()) {
            Beteiligter bt = (Beteiligter)iterator.next();
            builder.append(bt.kurzBezeichner(Beteiligter.Casus.GENITIV));
            if (bt.getLfdNr() > 0) {
                builder.append('-');
                builder.append(bt.getLfdNr());
            }
            builder.append(TenorToken.LEER);
        }
        return builder;
    }

    @Override
    @XmlElementWrapper(name="gegnerlein")
    @XmlIDREF
    @XmlElement
    public List<Beteiligter> getGegner() {
        return this.gegner;
    }

    @Override
    public void setGegner(List<Beteiligter> gegner) {
        this.gegner.clear();
        gegner.addAll(gegner);
    }

    private CharSequence formatGegner() {
        StringBuilder builder = new StringBuilder();
        if (this.getGegner().size() > 1) {
            builder.append('[');
        }
        Iterator iterator = this.getGegner().iterator();
        while (iterator.hasNext()) {
            Beteiligter bt = (Beteiligter)iterator.next();
            builder.append(bt.kurzBezeichner(Beteiligter.Casus.AKKUSATIV));
            if (bt.getLfdNr() > 0) {
                builder.append('-');
                builder.append(bt.getLfdNr());
            }
            builder.append(TenorToken.LEER);
        }
        if (this.getGegner().size() > 1) {
            builder.deleteCharAt(builder.lastIndexOf(TenorToken.LEER.toString()));
            builder.append("]@");
            builder.append(Integer.toHexString(this.getGegner().hashCode()));
            builder.append(TenorToken.LEER);
        }
        builder.append(this.formatGesamtschuldnerisch());
        return builder;
    }

    private String formatGesamtschuldnerisch() {
        if (this.isGesamtSchuldnerisch()) {
            return String.valueOf(TenorToken.LEER.toString()) + TenorToken.GESAMTSCHULDNERISCH + TenorToken.LEER;
        }
        return TenorToken.LEER.toString();
    }

    @Override
    @XmlAttribute(name="antrag")
    @XmlJavaTypeAdapter(value=EuroAdapter.class)
    public Euro getAntrag() {
        return this.antrag;
    }

    @Override
    public void setAntrag(Euro antrag) {
        this.antrag = antrag;
    }

    private CharSequence formatAntrag() {
        StringBuilder builder = new StringBuilder();
        if (this.getAntrag().getCents() > 0L) {
            builder.append(String.valueOf(TenorToken.AUF.toString()) + TenorToken.LEER);
            builder.append(this.getAntrag().toString());
            builder.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.EURO + TenorToken.LEER);
        }
        return builder;
    }

    @Override
    @XmlAttribute(name="erfolg")
    @XmlJavaTypeAdapter(value=EuroAdapter.class)
    public Euro getErfolg() {
        return this.erfolg;
    }

    @Override
    public void setErfolg(Euro erfolg) {
        this.erfolg = erfolg;
    }

    private CharSequence formatErfolg() {
        StringBuilder builder = new StringBuilder("(Erfolg:" + TenorToken.LEER);
        builder.append(this.getErfolg().toString());
        builder.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.EURO + ").");
        return builder;
    }

    @XmlAttribute
    public boolean isGesamtSchuldnerisch() {
        return this.gesamtSchuldnerisch;
    }

    public void setGesamtSchuldnerisch(boolean gesamtSchuldnerisch) {
        this.gesamtSchuldnerisch = gesamtSchuldnerisch;
    }

    @Override
    public int compareTo(Angriff o) {
        if (this.angreifer.get(0).compareTo(o.angreifer.get(0)) != 0) {
            return this.angreifer.get(0).compareTo(o.angreifer.get(0));
        }
        if (this.gegner.size() > 1 || o.gegner.size() > 1) {
            return o.gegner.size() - this.gegner.size();
        }
        if (this.gegner.get(0).compareTo(this.gegner.get(0)) != 0) {
            return this.gegner.get(0).compareTo(this.gegner.get(0));
        }
        return 0;
    }

    public List<Beteiligter> joinBeteiligte() {
        ArrayList<Beteiligter> beteiligte = new ArrayList<Beteiligter>((Collection<Beteiligter>)this.getAngreifer());
        beteiligte.addAll((Collection<Beteiligter>)this.getGegner());
        return beteiligte;
    }

    public static String benenneAngriff(Angriff angriff, List<Beteiligter> beteiligte) {
        StringBuilder builder = new StringBuilder();
        builder.append(MehrfachBeteiligter.kurzBezeichnerListe(beteiligte, (List<Beteiligter>)angriff.getAngreifer(), Beteiligter.Casus.NOMINATIV));
        builder.append(TenorToken.VS.toString());
        builder.append(MehrfachBeteiligter.kurzBezeichnerListe(beteiligte, (List<Beteiligter>)angriff.getGegner(), Beteiligter.Casus.AKKUSATIV));
        builder.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.AUF + TenorToken.LEER);
        builder.append(angriff.getAntrag().toString());
        builder.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.EURO);
        return builder.toString();
    }

    private static Collection<? extends Beteiligter> gesamtschuldnerBeteiligte(BaumbachGesamtschuldnerschaft gegner) {
        ArrayList<Beteiligter> liste = new ArrayList<Beteiligter>();
        int[] nArray = gegner.getAufzaehlung();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            liste.add(Angriff.copyBeteiligter((Beteiligter)gegner.getBaumbachBeteiligtenListe().get(index)));
            ++n2;
        }
        return liste;
    }

    private static Beteiligter copyBeteiligter(Beteiligter beteiligter) {
        Beteiligter copy = new Beteiligter(beteiligter);
        copy.setLfdNr(beteiligter.getLfdNr());
        return copy;
    }

    static Angriff from(BaumbachBeteiligter angreifer, BaumbachBeteiligter gegner) {
        Angriff angriff = new Angriff();
        Beteiligter angreiferBeteiligter = Angriff.copyBeteiligter(angreifer);
        angriff.getAngreifer().add(angreiferBeteiligter);
        if (gegner instanceof BaumbachGesamtschuldnerschaft) {
            Object liste = angriff.getGegner();
            liste.addAll(Angriff.gesamtschuldnerBeteiligte((BaumbachGesamtschuldnerschaft)gegner));
            angriff.setGesamtSchuldnerisch(true);
        } else {
            Beteiligter gegnerBeteiligter = Angriff.copyBeteiligter(gegner);
            angriff.getGegner().add(gegnerBeteiligter);
            angriff.setGesamtSchuldnerisch(false);
        }
        angriff.setAntrag(gegner.getAntrag());
        angriff.setErfolg(gegner.getErfolg());
        return angriff;
    }

    public static enum AngriffArt implements EnumString<AngriffArt>
    {
        KLAGE("Klage"),
        WIDERKLAGE("Widerklage"),
        UNBESTIMMT("Klage-/Widerklage");

        private final String string;

        private AngriffArt(String string2) {
            this.string = string2;
        }

        @Override
        public String toString() {
            return this.string;
        }

        public static AngriffArt forBeteiligterTyp(Beteiligter.BeteiligtenTyp typ) {
            switch (typ) {
                case KLAEGER: {
                    return KLAGE;
                }
                case BEKLAGTE: {
                    return WIDERKLAGE;
                }
            }
            return UNBESTIMMT;
        }
    }
}

