/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.baumbach;

import eu.gronos.kostenrechner.data.baumbach.Angriff;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.AntragErfolgElement;
import eu.gronos.kostenrechner.interfaces.ParteiBeziehung;
import eu.gronos.kostenrechner.util.baumbach.BeteiligteInAngreiferGegnerReihenfolge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AngriffListe
extends ArrayList<Angriff> {
    private static final long serialVersionUID = -2334090899427375988L;
    private final List<Beteiligter> beteiligte = new ArrayList<Beteiligter>();

    @Override
    public boolean add(Angriff angriff) {
        this.addBeteiligteFrom(angriff);
        return super.add(angriff);
    }

    @Override
    public boolean addAll(Collection<? extends Angriff> angriffe) {
        int oldSize = this.size();
        this.addAllBeteiligte(angriffe);
        return this.size() != oldSize;
    }

    private void addAllBeteiligte(Collection<? extends Angriff> angriffe) {
        for (Angriff angriff : angriffe) {
            this.addBeteiligteFrom(angriff);
            this.add(angriff);
        }
    }

    @Override
    public void add(int index, Angriff angriff) {
        this.addBeteiligteFrom(angriff);
        super.add(index, angriff);
    }

    public List<Beteiligter> getBeteiligte() {
        return this.beteiligte;
    }

    public static AngriffListe from(BaumbachBeteiligtenListe beteiligte) {
        AngriffListe angriffe = new AngriffListe();
        for (BaumbachBeteiligter gegner : beteiligte) {
            BaumbachBeteiligter angreifer = AngriffListe.findeAngreifer(beteiligte, gegner);
            if (angreifer == null) continue;
            Angriff angriff = Angriff.from(angreifer, gegner);
            angriffe.add(angriff);
        }
        angriffe.addAll(AngriffListe.angriffeUmklammern(angriffe));
        return angriffe;
    }

    private void addBeteiligteFrom(Angriff angriff) {
        List<Beteiligter> liste = angriff.joinBeteiligte();
        for (Beteiligter beteiligter : liste) {
            if (this.beteiligte.contains(beteiligter)) continue;
            this.beteiligte.add(beteiligter);
        }
        Collections.sort(this.beteiligte, new BeteiligteInAngreiferGegnerReihenfolge());
    }

    public static Euro findeGanzenErfolg(List<Angriff> gruppe, List<Beteiligter> angreifer, List<Beteiligter> gegner) {
        Euro erfolg = gruppe.stream().filter(angriff -> angriff.getGegner().containsAll(gegner) && angriff.getAngreifer().equals(angreifer)).map(Angriff::getErfolg).reduce(Euro.ZERO_CENTS, (bisher, neu) -> bisher.add((Euro)neu));
        return erfolg;
    }

    public static Euro addiereAntrag(List<Angriff> gruppe) {
        Euro gesamt = gruppe.stream().map(Angriff::getAntrag).reduce(Euro.ZERO_CENTS, (bisher, neu) -> bisher.add((Euro)neu));
        return gesamt;
    }

    public static Euro addiereErfolg(List<Angriff> gruppe) {
        Euro gesamt = gruppe.stream().map(Angriff::getErfolg).reduce(Euro.ZERO_CENTS, (bisher, neu) -> bisher.add((Euro)neu));
        return gesamt;
    }

    public static Angriff.AngriffArt klageOderWiderklage(List<Angriff> gruppe) {
        Beteiligter.BeteiligtenTyp typ = AngriffListe.einheitlicherAngreifer(gruppe);
        return Angriff.AngriffArt.forBeteiligterTyp(typ);
    }

    private static Beteiligter.BeteiligtenTyp einheitlicherAngreifer(List<Angriff> gruppe) {
        Beteiligter.BeteiligtenTyp typ = null;
        for (ParteiBeziehung parteiBeziehung : gruppe) {
            for (Beteiligter angreifer : (List)parteiBeziehung.getAngreifer()) {
                if (typ == null) {
                    typ = angreifer.getTyp();
                    continue;
                }
                if (typ == angreifer.getTyp()) continue;
                return null;
            }
        }
        return typ;
    }

    public static List<Beteiligter> alleBeteiligteAus(List<Angriff> angriffe) {
        if (angriffe instanceof AngriffListe) {
            return ((AngriffListe)angriffe).getBeteiligte();
        }
        AngriffListe liste = new AngriffListe();
        liste.addAll((Collection<? extends Angriff>)angriffe);
        return liste.getBeteiligte();
    }

    public static Euro findeEinheitlichenAntrag(List<Angriff> gruppe) {
        long einheitlicherStreitwertCent = 0L;
        for (AntragErfolgElement antragErfolgElement : gruppe) {
            if (einheitlicherStreitwertCent == 0L) {
                einheitlicherStreitwertCent = antragErfolgElement.getAntrag().getCents();
                continue;
            }
            if (antragErfolgElement.getAntrag().getCents() == 0L || antragErfolgElement.getAntrag().getCents() == einheitlicherStreitwertCent) continue;
            return null;
        }
        return Euro.ofCents(einheitlicherStreitwertCent);
    }

    public static List<List<Angriff>> gruppiereAngriffe(List<Angriff> angriffe) {
        ArrayList<List<Angriff>> liste = new ArrayList<List<Angriff>>();
        ArrayList<Integer> ueberspringbare = new ArrayList<Integer>();
        int i = 0;
        while (i < angriffe.size()) {
            if (!ueberspringbare.contains(i)) {
                AngriffListe gruppe = new AngriffListe();
                ParteiBeziehung gruppenAngriff = angriffe.get(i);
                int j = i;
                while (j < angriffe.size()) {
                    Angriff angriff = angriffe.get(j);
                    if (j == i) {
                        gruppe.add(angriff);
                    } else if (angriff.getAngreifer().equals(gruppenAngriff.getAngreifer()) && ((List)gruppenAngriff.getGegner()).containsAll((Collection<?>)angriff.getGegner())) {
                        gruppe.add(angriff);
                        ueberspringbare.add(j);
                    }
                    ++j;
                }
                liste.add(gruppe);
            }
            ++i;
        }
        return liste;
    }

    private static Collection<? extends Angriff> angriffeUmklammern(List<Angriff> angriffe) {
        ArrayList<Angriff> liste = new ArrayList<Angriff>();
        ArrayList<Beteiligter> angreiferlein = new ArrayList<Beteiligter>();
        for (ParteiBeziehung parteiBeziehung : angriffe) {
            for (Beteiligter angreifer : (List)parteiBeziehung.getAngreifer()) {
                if (angreiferlein.contains(angreifer)) continue;
                angreiferlein.add(angreifer);
            }
        }
        for (Beteiligter beteiligter : angreiferlein) {
            boolean bl;
            Angriff klammer = new Angriff();
            klammer.getAngreifer().add(beteiligter);
            klammer.setAntrag(Euro.ZERO_CENTS);
            klammer.setErfolg(Euro.ZERO_CENTS);
            klammer.setGesamtSchuldnerisch(false);
            for (ParteiBeziehung parteiBeziehung : angriffe) {
                if (!((List)parteiBeziehung.getAngreifer()).contains(beteiligter)) continue;
                for (Beteiligter gegner : (List)parteiBeziehung.getGegner()) {
                    if (klammer.getGegner().contains(gegner)) continue;
                    klammer.getGegner().add(gegner);
                }
            }
            boolean bl2 = false;
            for (ParteiBeziehung parteiBeziehung : angriffe) {
                if (!((List)parteiBeziehung.getAngreifer()).contains(beteiligter) || !((List)parteiBeziehung.getGegner()).containsAll((Collection<?>)klammer.getGegner())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            liste.add(klammer);
        }
        return liste;
    }

    private static BaumbachBeteiligter findeWiderklaeger(BaumbachBeteiligtenListe baumbachBeteiligtenListe) {
        int[] bereich = baumbachBeteiligtenListe.minUndMax(Beteiligter.BeteiligtenTyp.BEKLAGTE);
        int i = bereich[0];
        while (i <= bereich[1]) {
            if (((BaumbachBeteiligter)baumbachBeteiligtenListe.get(i)).isAnWiderklageBeteiligt()) {
                BaumbachBeteiligter angreifer = (BaumbachBeteiligter)baumbachBeteiligtenListe.get(i);
                return angreifer;
            }
            ++i;
        }
        return null;
    }

    private static BaumbachBeteiligter findeKlaeger(BaumbachBeteiligtenListe beteiligte) {
        if (beteiligte.getTypFor(0) == Beteiligter.BeteiligtenTyp.KLAEGER) {
            return (BaumbachBeteiligter)beteiligte.get(0);
        }
        return null;
    }

    private static BaumbachBeteiligter findeAngreifer(BaumbachBeteiligtenListe beteiligte, BaumbachBeteiligter gegner) {
        if (gegner.getTyp() == Beteiligter.BeteiligtenTyp.BEKLAGTE) {
            return AngriffListe.findeKlaeger(beteiligte);
        }
        if (gegner.isAnWiderklageBeteiligt()) {
            return AngriffListe.findeWiderklaeger(beteiligte);
        }
        return null;
    }
}

