/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.baumbach;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class BaumbachGesamtschuldnerschaft
extends BaumbachBeteiligter {
    private static final long serialVersionUID = -323033831927041650L;
    private static final String GESAMTSCHULDNERISCH = " gesamtschuldnerisch";
    @XmlTransient
    private BaumbachBeteiligtenListe baumbachBeteiligtenListe;
    @XmlElementWrapper(name="aufzaehlung")
    @XmlElement(name="position")
    private int[] aufzaehlung;

    public BaumbachGesamtschuldnerschaft(Beteiligter.BeteiligtenTyp typ, Beteiligter.GenusNumerus genusNumerus, Euro unterliegen, boolean anWiderklageBeteiligt, int[] aufzaehlung, BaumbachBeteiligtenListe baumbachBeteiligtenListe) {
        super(typ, genusNumerus, Euro.ZERO_CENTS, unterliegen, anWiderklageBeteiligt);
        this.baumbachBeteiligtenListe = baumbachBeteiligtenListe;
        this.aufzaehlung = aufzaehlung;
    }

    public BaumbachGesamtschuldnerschaft() {
    }

    @Override
    @XmlTransient
    public Euro getAntrag() {
        return Euro.ZERO_CENTS;
    }

    public BaumbachBeteiligtenListe getBaumbachBeteiligtenListe() {
        return this.baumbachBeteiligtenListe;
    }

    public void setBaumbachBeteiligtenListe(BaumbachBeteiligtenListe baumbachBeteiligtenListe) {
        if (baumbachBeteiligtenListe != null) {
            this.baumbachBeteiligtenListe = baumbachBeteiligtenListe;
        }
    }

    public int[] getAufzaehlung() {
        return this.aufzaehlung;
    }

    public void setAufzaehlung(int[] aufzaehlung) {
        if (aufzaehlung != null) {
            this.aufzaehlung = aufzaehlung;
        }
    }

    @Override
    public boolean isGesamtschuldnerschaft() {
        return true;
    }

    @Override
    public String parteiBezeichner(Beteiligter.Casus casus, int laufendeNummer, boolean einzigerSeinerArt) {
        return this.parteiBezeichner(casus);
    }

    @Override
    public String kurzBezeichner(Beteiligter.Casus casus) {
        return String.valueOf(this.baumbachBeteiligtenListe.kurzBezeichnerListe(casus, this.getAufzaehlung())) + GESAMTSCHULDNERISCH;
    }

    @Deprecated
    public String kurzBezeichner(int casus) {
        return this.kurzBezeichner(Beteiligter.Casus.values()[casus]);
    }

    @Override
    public String langBezeichnung() {
        return String.valueOf(this.baumbachBeteiligtenListe.parteiBezeichnerListe(Beteiligter.Casus.NOMINATIV, this.getAufzaehlung())) + GESAMTSCHULDNERISCH;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString().replace("BaumbachBeteiligter ", "BaumbachGesamtschuldnerschaft ").replace("]", ", "));
        if (this.aufzaehlung != null) {
            builder.append("aufzaehlung=");
            builder.append(Arrays.toString(this.aufzaehlung));
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean contains(Beteiligter.BeteiligtenTyp beteiligtenTyp, int laufendeNummer) {
        boolean zwischen = false;
        int[] nArray = this.aufzaehlung;
        int n = this.aufzaehlung.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (this.baumbachBeteiligtenListe.ermittleLaufendeNummerFuerBeteiligtenTyp(i) == laufendeNummer && ((BaumbachBeteiligter)this.baumbachBeteiligtenListe.get(i)).getTyp() == beteiligtenTyp) {
                zwischen = true;
            }
            ++n2;
        }
        return zwischen;
    }

    @Deprecated
    public boolean contains(int beteiligtenTyp, int laufendeNummer) {
        return this.contains(Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp], laufendeNummer);
    }

    @Override
    public boolean isPlural() {
        return this.aufzaehlung != null && this.aufzaehlung.length > 1;
    }

    boolean istGleicherTyp(Beteiligter.BeteiligtenTyp beteiligtenTyp, int laufendeNummer) {
        return ((BaumbachBeteiligter)this.baumbachBeteiligtenListe.get(laufendeNummer)).getTyp() == beteiligtenTyp || ((BaumbachBeteiligter)this.baumbachBeteiligtenListe.get(laufendeNummer)).getTyp() == Beteiligter.BeteiligtenTyp.KLAEGER && beteiligtenTyp == Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE || ((BaumbachBeteiligter)this.baumbachBeteiligtenListe.get(laufendeNummer)).getTyp() == Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE && beteiligtenTyp == Beteiligter.BeteiligtenTyp.KLAEGER;
    }

    @Deprecated
    boolean istGleicherTyp(int beteiligtenTyp, int laufendeNummer) {
        return this.istGleicherTyp(Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp], laufendeNummer);
    }

    int getAnzahl() {
        return this.getAufzaehlung().length;
    }

    private String parteiBezeichner(Beteiligter.Casus casus) {
        return String.valueOf(this.baumbachBeteiligtenListe.parteiBezeichnerListe(casus, this.aufzaehlung)) + GESAMTSCHULDNERISCH;
    }
}

