/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.baumbach;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Vollstreckbarkeit;

public class BaumbachVollstreckbarkeit
extends Vollstreckbarkeit {
    private final Beteiligter glaeubiger;
    private final Beteiligter schuldner;

    public BaumbachVollstreckbarkeit(Vollstreckbarkeit vo, Beteiligter glaeubiger, Beteiligter schuldner) throws IllegalArgumentException {
        this(vo.isB708(), vo.isB709s1(), vo.isB709s2(), vo.isB711(), vo.isB713(), glaeubiger, schuldner);
    }

    BaumbachVollstreckbarkeit(boolean b708, boolean b709s1, boolean b709s2, boolean b711, boolean b713, Beteiligter glaeubiger, Beteiligter schuldner) throws IllegalArgumentException {
        super(b708, b709s1, b709s2, b711, b713);
        this.glaeubiger = glaeubiger;
        this.schuldner = schuldner;
    }

    BaumbachVollstreckbarkeit(Beteiligter glaeubiger, Beteiligter schuldner) {
        this.glaeubiger = glaeubiger;
        this.schuldner = schuldner;
    }

    public Beteiligter getGlaeubiger() {
        return this.glaeubiger;
    }

    public Beteiligter getSchuldner() {
        return this.schuldner;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.glaeubiger.parteiBezeichner(Beteiligter.Casus.NOMINATIV, this.glaeubiger.getLfdNr(), false) + " ./. " + this.schuldner.parteiBezeichner(Beteiligter.Casus.NOMINATIV, this.glaeubiger.getLfdNr(), false) + ")";
    }

    public String benenneParteien(BaumbachBeteiligtenListe baumbachBeteiligtenListe) {
        boolean glaeubigerEinziger = baumbachBeteiligtenListe.isEinzigerSeinerArt(this.glaeubiger);
        boolean schuldnerEinziger = baumbachBeteiligtenListe.isEinzigerSeinerArt(this.schuldner);
        return String.valueOf(this.glaeubiger.parteiBezeichner(Beteiligter.Casus.GENITIV, this.glaeubiger.getLfdNr(), glaeubigerEinziger)) + " gegen " + this.schuldner.parteiBezeichner(Beteiligter.Casus.AKKUSATIV, this.schuldner.getLfdNr(), schuldnerEinziger);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.glaeubiger == null ? 0 : this.glaeubiger.hashCode());
        result = 31 * result + (this.schuldner == null ? 0 : this.schuldner.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaumbachVollstreckbarkeit other = (BaumbachVollstreckbarkeit)obj;
        if (this.schuldner == null ? other.schuldner != null : !this.schuldner.equals(other.schuldner)) {
            return false;
        }
        return !(this.glaeubiger == null ? other.glaeubiger != null : !this.glaeubiger.equals(other.glaeubiger));
    }

    @Override
    public int compareTo(Vollstreckbarkeit other) {
        if (this.equals(other)) {
            return 0;
        }
        if (super.compareTo(other) != 0) {
            return super.compareTo(other);
        }
        if (other instanceof BaumbachVollstreckbarkeit) {
            BaumbachVollstreckbarkeit bvOther = (BaumbachVollstreckbarkeit)other;
            if (this.getSchuldner().compareTo(bvOther.getSchuldner()) != 0) {
                return this.getSchuldner().compareTo(bvOther.getSchuldner());
            }
            return this.getGlaeubiger().compareTo(bvOther.getGlaeubiger());
        }
        return 0;
    }

    public static BaumbachVollstreckbarkeit pruefeSicherheitsleistung(long hauptsache, long kosten, Beteiligter glaeubiger, Beteiligter schuldner) throws IllegalArgumentException {
        return new BaumbachVollstreckbarkeit(Vollstreckbarkeit.pruefeSicherheitsleistung(Euro.of(hauptsache, 0), Euro.of(kosten, 0)), glaeubiger, schuldner);
    }
}

