/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.forderungen;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.EuroAdapter;
import eu.gronos.kostenrechner.interfaces.AntragErfolgElement;
import eu.gronos.kostenrechner.interfaces.Hinzufuegbar;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(propOrder={"antrag", "erfolg"})
public abstract class Forderung
implements Serializable,
AntragErfolgElement,
Hinzufuegbar {
    private static final long serialVersionUID = 5194917413163124727L;
    private boolean gegenforderung;
    private Euro antrag;
    private Euro erfolg;

    Forderung(boolean gegenforderung, Euro antrag, Euro erfolg) throws IllegalArgumentException {
        this.gegenforderung = gegenforderung;
        this.antrag = antrag;
        this.setErfolg(erfolg);
    }

    public Forderung() {
    }

    @XmlAttribute(name="gegenforderung")
    public boolean isGegenforderung() {
        return this.gegenforderung;
    }

    public void setGegenforderung(boolean gegenforderung) {
        this.gegenforderung = gegenforderung;
    }

    @Override
    @XmlAttribute(name="wert")
    @XmlJavaTypeAdapter(value=EuroAdapter.class)
    public Euro getAntrag() {
        return this.antrag;
    }

    @Override
    public void setAntrag(Euro antrag) {
        this.antrag = antrag;
    }

    @Override
    @XmlAttribute(name="erfolg")
    @XmlJavaTypeAdapter(value=EuroAdapter.class)
    public Euro getErfolg() {
        return this.erfolg;
    }

    @Override
    public void setErfolg(Euro erfolg) {
        this.erfolg = erfolg;
    }

    public abstract String getBeschreibung();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Forderung [");
        if (this.getBeschreibung() != null) {
            builder.append("getBeschreibung()=");
            builder.append(this.getBeschreibung());
            builder.append(", ");
        }
        builder.append("gegenforderung=");
        builder.append(this.gegenforderung);
        builder.append(", wert=");
        builder.append(this.antrag);
        builder.append(", erfolg=");
        builder.append(this.erfolg);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String langBezeichnung() {
        String isGegenforderung = this.gegenforderung ? "Gegenforderung" : "Forderung";
        return String.format("%s (%s) in H\u00f6he von %s, davon %s begr\u00fcndet", this.getBeschreibung(), isGegenforderung, this.antrag, this.erfolg);
    }
}

