/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTabelle;
import eu.gronos.kostenrechner.interfaces.GebuehrenMitAnzahlLinear;
import javax.xml.bind.annotation.XmlAttribute;

public class GebuehrenErhoehungsTatbestand
extends GebuehrenSatzTatbestand
implements Cloneable,
GebuehrenMitAnzahlLinear<Double> {
    private static final long serialVersionUID = -2255864991661667203L;
    private double jeweils;
    private double maxSatz;
    public static final String ART = "Mehrvertretungsgeb\u00fchr";
    private int anzahl;
    private String einheit;
    private boolean berechnet;

    public GebuehrenErhoehungsTatbestand(String vorschrift, String bezeichnung, double jeweils, double maxSatz, int anzahl, String einheit, Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
        super(vorschrift, bezeichnung, -1.0, gebuehrenKlasse);
        this.jeweils = jeweils;
        this.maxSatz = maxSatz;
        this.anzahl = anzahl;
        this.einheit = einheit;
        this.berechnet = false;
    }

    public GebuehrenErhoehungsTatbestand(String vorschrift, String bezeichnung, double jeweils, double maxSatz, String einheit, Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
        this(vorschrift, bezeichnung, jeweils, maxSatz, -1, einheit, gebuehrenKlasse);
    }

    public GebuehrenErhoehungsTatbestand() {
    }

    @Override
    @XmlAttribute(name="anzahl")
    public int getAnzahl() {
        return this.anzahl;
    }

    @Override
    public void setAnzahl(int anzahl) {
        this.berechnet = false;
        this.anzahl = anzahl;
    }

    @Override
    @XmlAttribute(name="je")
    public Double getJeweils() {
        return new Double(this.jeweils);
    }

    @Override
    public void setJeweils(Double jeweils) {
        this.berechnet = false;
        this.jeweils = jeweils;
    }

    @XmlAttribute(name="max")
    public double getMaxSatz() {
        return this.maxSatz;
    }

    public void setMaxSatz(double maxSatz) {
        this.berechnet = false;
        this.maxSatz = maxSatz;
    }

    @Override
    public double getSatz() {
        if (!this.berechnet) {
            this.berechne();
        }
        return super.getSatz();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.anzahl;
        long temp = Double.doubleToLongBits(this.jeweils);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxSatz);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GebuehrenErhoehungsTatbestand)) {
            return false;
        }
        GebuehrenErhoehungsTatbestand other = (GebuehrenErhoehungsTatbestand)obj;
        if (this.anzahl != other.anzahl) {
            return false;
        }
        if (Double.doubleToLongBits(this.jeweils) != Double.doubleToLongBits(other.jeweils)) {
            return false;
        }
        return Double.doubleToLongBits(this.maxSatz) == Double.doubleToLongBits(other.maxSatz);
    }

    @Override
    public String toString() {
        return String.format("GebuehrenErhoehungsTatbestand [vorschrift=%s, bezeichnung=%s, gebuehrenKlasse=%s, satz=%s, jeweils=%s, maxSatz=%s, anzahl=%s, einheit=%s]", this.getVorschrift(), this.getBezeichnung(), this.getGebuehrenKlasse(), this.getSatz(), this.jeweils, this.maxSatz, this.anzahl, this.einheit);
    }

    public GebuehrenErhoehungsTatbestand clone() {
        GebuehrenErhoehungsTatbestand other = new GebuehrenErhoehungsTatbestand(this.getVorschrift(), this.getBezeichnung(), this.getJeweils(), this.getMaxSatz(), this.anzahl, this.getEinheit(), this.getGebuehrenKlasse());
        other.setSatz(this.getSatz());
        return other;
    }

    @Override
    @XmlAttribute(name="einheit")
    public String getEinheit() {
        return this.einheit;
    }

    @Override
    public void setEinheit(String einheit) {
        this.einheit = einheit;
    }

    private double berechne() {
        double satz = (double)this.getAnzahl() * this.getJeweils();
        if (this.getAnzahl() < 0) {
            satz = 0.0;
            this.setSatz(satz);
        } else if (satz < this.getMaxSatz()) {
            satz = (double)this.getAnzahl() * this.getJeweils();
            this.setSatz(satz);
        } else {
            this.setSatz(this.getMaxSatz());
        }
        this.berechnet = true;
        return satz;
    }
}

