/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTabelle;
import javax.xml.bind.annotation.XmlAttribute;

public class GebuehrenRahmenTatbestand
extends GebuehrenSatzTatbestand
implements Cloneable {
    public static final String ART = "Geb\u00fchrenrahmen";
    private static final long serialVersionUID = 1682428886423302356L;
    private double untergrenze;
    private double obergrenze;
    private double mittel;

    public GebuehrenRahmenTatbestand() {
    }

    public GebuehrenRahmenTatbestand(String vorschrift, String bezeichnung, double untergrenze, double obergrenze, Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
        this(vorschrift, bezeichnung, untergrenze, obergrenze, GebuehrenRahmenTatbestand.mittle(untergrenze, obergrenze), gebuehrenKlasse);
    }

    public GebuehrenRahmenTatbestand(String vorschrift, String bezeichnung, double untergrenze, double obergrenze, double mittel, Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
        super(vorschrift, bezeichnung, mittel, gebuehrenKlasse);
        this.setUntergrenze(untergrenze);
        this.setObergrenze(obergrenze);
        this.setMittel(mittel);
    }

    @XmlAttribute(name="untergrenze")
    public double getUntergrenze() {
        return this.untergrenze;
    }

    public void setUntergrenze(double untergrenze) {
        this.untergrenze = untergrenze;
    }

    @XmlAttribute(name="obergrenze")
    public double getObergrenze() {
        return this.obergrenze;
    }

    public void setObergrenze(double obergrenze) {
        this.obergrenze = obergrenze;
    }

    @XmlAttribute(name="mittelGebuehr")
    public double getMittel() {
        return this.mittel;
    }

    public void setMittel(double mittel) {
        this.mittel = mittel;
    }

    @Override
    public String toString() {
        return String.format("GebuehrenRahmenTatbestand [vorschrift=%s, bezeichnung=%s, untergrenze=%s, obergrenze=%s, mittel=%s, gebuehrenKlasse=%s]", this.getVorschrift(), this.getBezeichnung(), this.untergrenze, this.obergrenze, this.mittel, this.getGebuehrenKlasse());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.mittel);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.obergrenze);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.untergrenze);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GebuehrenRahmenTatbestand)) {
            return false;
        }
        GebuehrenRahmenTatbestand other = (GebuehrenRahmenTatbestand)obj;
        if (Double.doubleToLongBits(this.mittel) != Double.doubleToLongBits(other.mittel)) {
            return false;
        }
        if (Double.doubleToLongBits(this.obergrenze) != Double.doubleToLongBits(other.obergrenze)) {
            return false;
        }
        return Double.doubleToLongBits(this.untergrenze) == Double.doubleToLongBits(other.untergrenze);
    }

    public GebuehrenRahmenTatbestand clone() {
        return new GebuehrenRahmenTatbestand(this.getVorschrift(), this.getBezeichnung(), this.getUntergrenze(), this.getObergrenze(), this.getMittel(), this.getGebuehrenKlasse());
    }

    private static double mittle(double untergrenze, double obergrenze) {
        return (untergrenze + obergrenze) / 2.0;
    }
}

