/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import javax.xml.bind.annotation.XmlAttribute;

public class GebuehrenSatzTatbestand
extends GebuehrenTatbestand {
    private static final long serialVersionUID = -3368857385467838790L;
    public static final String ART = "Geb\u00fchrensatz";
    private double satz;

    public GebuehrenSatzTatbestand(String vorschrift, String bezeichnung, double satz, Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
        super(vorschrift, bezeichnung, gebuehrenKlasse);
        this.satz = satz;
    }

    public GebuehrenSatzTatbestand() {
    }

    @XmlAttribute(name="satz")
    public double getSatz() {
        return this.satz;
    }

    public void setSatz(double satz) {
        this.satz = satz;
    }

    @Override
    public String toString() {
        return String.format("GebuehrenSatzTatbestand [vorschrift=%s, bezeichnung=%s, gebuehrenKlasse=%s, satz=%s]", this.getVorschrift(), this.getBezeichnung(), this.getGebuehrenKlasse(), this.satz);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.satz);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GebuehrenSatzTatbestand)) {
            return false;
        }
        GebuehrenSatzTatbestand other = (GebuehrenSatzTatbestand)obj;
        if (Double.doubleToLongBits(this.satz) != Double.doubleToLongBits(other.satz)) {
            return false;
        }
        if (this.getBezeichnung() == null ? other.getBezeichnung() != null : !this.getBezeichnung().equals(other.getBezeichnung())) {
            return false;
        }
        return !(this.getGebuehrenKlasse() == null ? other.getGebuehrenKlasse() != null : !this.getGebuehrenKlasse().equals(other.getGebuehrenKlasse()));
    }
}

