/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAttribute;

public class GebuehrenVerzeichnis
extends TreeMap<String, GebuehrenTatbestand> {
    private static final long serialVersionUID = -934035989553745462L;
    private String title = new String();

    public GebuehrenAuflistung getAll(String ... vorschriften) throws IllegalArgumentException {
        return Stream.of(vorschriften).map(key -> this.getNonNull((String)key)).collect(this.collector());
    }

    public GebuehrenAuflistung filter(String term) {
        return this.entrySet().stream().filter((? super T map) -> ((GebuehrenTatbestand)map.getValue()).toString().toLowerCase().contains(term.toLowerCase())).map(Map.Entry::getValue).collect(this.collector());
    }

    @XmlAttribute(name="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private GebuehrenTatbestand getNonNull(String vorschrift) throws IllegalArgumentException {
        GebuehrenTatbestand gt = (GebuehrenTatbestand)this.get(vorschrift);
        if (gt == null) {
            throw new IllegalArgumentException(String.format("Geb\u00fchrentatbestand nicht im Verzeichnis: %s!", vorschrift));
        }
        return gt;
    }

    private Collector<GebuehrenTatbestand, ?, GebuehrenAuflistung> collector() {
        return Collectors.toCollection(GebuehrenAuflistung::new);
    }
}

