/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.PauschalTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.EuroAdapter;
import eu.gronos.kostenrechner.interfaces.GebuehrenMitAnzahlLinear;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class MehrfachPauschalTatbestand
extends PauschalTatbestand
implements GebuehrenMitAnzahlLinear<Euro>,
Cloneable {
    private static final long serialVersionUID = -785436174722370248L;
    public static final String ART = "mehrfache Pauschale";
    private int anzahl;
    private Euro jeweils;
    private String einheit;
    private boolean berechnet;

    public MehrfachPauschalTatbestand(String vorschrift, String bezeichnung, Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
        super(vorschrift, bezeichnung, gebuehrenKlasse);
        this.berechnet = false;
    }

    public MehrfachPauschalTatbestand(String vorschrift, String bezeichnung, int anzahl, Euro einheitsPreisJeweils, String einheit, Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
        super(vorschrift, bezeichnung, gebuehrenKlasse);
        this.setAnzahl(anzahl);
        this.setJeweils(einheitsPreisJeweils);
        this.setEinheit(einheit);
        this.berechne();
    }

    public MehrfachPauschalTatbestand() {
        this.berechnet = false;
    }

    @Override
    public Euro getBetrag() {
        if (!this.berechnet) {
            this.berechne();
        }
        return super.getBetrag();
    }

    @Override
    @XmlAttribute(name="anzahl")
    public int getAnzahl() {
        return this.anzahl;
    }

    @Override
    public void setAnzahl(int anzahl) {
        this.anzahl = anzahl;
        this.berechnet = false;
    }

    @Override
    @XmlAttribute(name="je")
    @XmlJavaTypeAdapter(value=EuroAdapter.class)
    public Euro getJeweils() {
        return this.jeweils;
    }

    @Override
    public void setJeweils(Euro jeweils) {
        if (jeweils == null || jeweils.compareTo(Euro.ofCents(0L)) < 0) {
            jeweils = null;
        }
        this.jeweils = jeweils;
        this.berechnet = false;
    }

    @Override
    @XmlAttribute(name="einheit")
    public String getEinheit() {
        return this.einheit;
    }

    @Override
    public void setEinheit(String einheit) {
        this.einheit = einheit;
    }

    public MehrfachPauschalTatbestand clone() {
        return new MehrfachPauschalTatbestand(this.getVorschrift(), this.getBezeichnung(), this.getAnzahl(), this.getJeweils(), this.getEinheit(), this.getGebuehrenKlasse());
    }

    @Override
    public String toString() {
        return String.format("MehrfachPauschalTatbestand [vorschrift=%s, bezeichnung=%s, gebuehrenKlasse=%s, anzahl=%s, einheitsPreis=%s, einheit=%s]", this.getVorschrift(), this.getBezeichnung(), this.getGebuehrenKlasse(), this.getAnzahl(), this.getJeweils(), this.getEinheit());
    }

    private HtmlRtfFormattierend berechne() {
        if (this.getAnzahl() < 0) {
            this.setBetrag(Euro.ofCents(0L));
        } else {
            this.setBetrag(this.getJeweils().multiply(Double.valueOf(this.getAnzahl())));
        }
        this.berechnet = true;
        return this.getBetrag();
    }
}

