/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.tenordaten;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="zeile")
public class BegruendungsZahlenZeile
extends ArrayList<Number> {
    private static final long serialVersionUID = 6397831147537226777L;

    public BegruendungsZahlenZeile() {
    }

    public BegruendungsZahlenZeile(ArrayList<? extends Number> dv) {
        super(dv.size());
        super.addAll(dv);
    }

    public BegruendungsZahlenZeile(int size) {
        super(size);
    }

    @XmlAttribute(name="spalten")
    public String getZeile() {
        return this.toString();
    }

    public void setZeile(String zeile) {
        if (zeile == null || zeile.isEmpty()) {
            return;
        }
        Arrays.stream(zeile.trim().split("\\s+")).filter(s -> s != null && !s.trim().isEmpty()).map(String::trim).map(this::spalteToNumber).forEach(this::add);
    }

    @Override
    public String toString() {
        return super.stream().map(this::numberToSpalte).reduce("", (bisher, dazu) -> String.valueOf(bisher) + (!bisher.isEmpty() ? ",\t" : "\t") + dazu);
    }

    public String tabSeparatedValues() {
        return String.valueOf(super.stream().map(this::numberToSpalte).collect(Collectors.joining("\t"))) + "\n";
    }

    public String numberToSpalte(Number n) {
        if (n instanceof Euro) {
            return String.valueOf(((HtmlRtfFormattierend)((Object)n)).toString()) + "\u20ac";
        }
        if (n instanceof Double) {
            return String.format("%,.2f ", n);
        }
        return n.toString();
    }

    private Number spalteToNumber(String s) {
        if (s.endsWith("\u20ac")) {
            return Euro.valueOf(s.substring(0, s.length() - 1).trim());
        }
        if (s.contains("/")) {
            return Fraction.valueOf(s);
        }
        return Double.parseDouble(s.replace(",", "."));
    }
}

