/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.tenordaten;

import eu.gronos.kostenrechner.data.tenordaten.BeteiligtenTypAdapter;
import eu.gronos.kostenrechner.data.tenordaten.GenusNumerusAdapter;
import eu.gronos.kostenrechner.interfaces.Hinzufuegbar;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Beteiligter
implements Comparable<Beteiligter>,
Serializable,
Hinzufuegbar {
    private static final long serialVersionUID = -6275833726367356470L;
    private static int zaehler = Integer.MIN_VALUE;
    private GenusNumerus genusNumerus;
    private BeteiligtenTyp typ;
    private int lfdNr = -1;
    private int tempNr = zaehler++;

    public Beteiligter(BeteiligtenTyp beteiligtenTyp, GenusNumerus genusNumerus) {
        this();
        this.setTyp(beteiligtenTyp);
        this.setGenusNumerus(genusNumerus);
    }

    public Beteiligter(Beteiligter beteiligter) {
        this();
        this.setTyp(beteiligter.getTyp());
        this.setGenusNumerus(beteiligter.getGenusNumerus());
    }

    public Beteiligter() {
        if (this.tempNr >= 0) {
            zaehler = Integer.MIN_VALUE;
            this.tempNr = Integer.MIN_VALUE;
        }
    }

    public static String parteiBezeichner(BeteiligtenTyp beteiligtenTyp, GenusNumerus genusNumerus, int laufendeNummer, Casus casus, boolean einzigerSeinerArt) {
        return String.valueOf(beteiligtenTyp.beuge(genusNumerus, casus)) + (einzigerSeinerArt ? "" : Beteiligter.fuegeLaufendeNummerHinzu(laufendeNummer));
    }

    @XmlAttribute(name="typ")
    @XmlJavaTypeAdapter(value=BeteiligtenTypAdapter.class)
    public BeteiligtenTyp getTyp() {
        return this.typ;
    }

    public void setTyp(BeteiligtenTyp typ) {
        this.typ = typ;
    }

    @XmlAttribute(name="genusNumerus")
    @XmlJavaTypeAdapter(value=GenusNumerusAdapter.class)
    public GenusNumerus getGenusNumerus() {
        return this.genusNumerus;
    }

    public void setGenusNumerus(GenusNumerus genusNumerus) {
        this.genusNumerus = genusNumerus;
    }

    public boolean isPlural() {
        if (this.genusNumerus == null) {
            return false;
        }
        return this.genusNumerus.getNumerus() == GenusNumerus.Numerus.PLURAL;
    }

    @XmlAttribute(name="laufendeNummer")
    public int getLfdNr() {
        return this.lfdNr;
    }

    public void setLfdNr(int lfdNr) {
        this.lfdNr = lfdNr;
    }

    protected int getTempNr() {
        return this.tempNr;
    }

    @XmlAttribute(name="id")
    @XmlID
    public String getId() {
        if (this.typ == null) {
            return null;
        }
        if (this.lfdNr > 0) {
            return "" + this.typ.kurz() + this.lfdNr;
        }
        return "" + this.typ.kurz() + this.tempNr;
    }

    public void setId(String id) {
        if (id == null || id.length() < 2) {
            return;
        }
        this.setTyp(BeteiligtenTyp.of(id.charAt(0)));
        int nr = Integer.parseInt(id.substring(1));
        if (nr > 0) {
            this.setLfdNr(nr);
        }
    }

    public String parteiBezeichner(Casus casus, int laufendeNummer, boolean einzigerSeinerArt) {
        this.setLfdNr(laufendeNummer);
        return Beteiligter.parteiBezeichner(this.getTyp(), this.getGenusNumerus(), laufendeNummer, casus, einzigerSeinerArt);
    }

    public static String fuegeLaufendeNummerHinzu(int laufendeNummer) {
        return String.format(" zu %d.)", laufendeNummer);
    }

    public static Beteiligter[] getBeteiligtenAuswahlListe(BeteiligtenTyp beteiligtenTyp, boolean mitPlural) {
        Beteiligter[] zwischen = mitPlural ? new Beteiligter[]{new Beteiligter(beteiligtenTyp, GenusNumerus.MAENNLICH_SINGULAR), new Beteiligter(beteiligtenTyp, GenusNumerus.WEIBLICH_SINGULAR), new Beteiligter(beteiligtenTyp, GenusNumerus.MAENNLICH_PLURAL), new Beteiligter(beteiligtenTyp, GenusNumerus.WEIBLICH_PLURAL)} : new Beteiligter[]{new Beteiligter(beteiligtenTyp, GenusNumerus.MAENNLICH_SINGULAR), new Beteiligter(beteiligtenTyp, GenusNumerus.WEIBLICH_SINGULAR)};
        Beteiligter[] beteiligterArray = zwischen;
        int n = zwischen.length;
        int n2 = 0;
        while (n2 < n) {
            Beteiligter b = beteiligterArray[n2];
            b.setLfdNr(b.getGenusNumerus().ordinal());
            ++n2;
        }
        return zwischen[0] == null ? null : zwischen;
    }

    public String kurzBezeichner(Casus casus) {
        String zwischen = this.getTyp().getBeugung()[casus.ordinal()][this.getGenusNumerus().ordinal()];
        return zwischen.substring(4, zwischen.length());
    }

    @Override
    public String langBezeichnung() {
        return this.kurzBezeichner(Casus.NOMINATIV);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Beteiligter [typ=");
        builder.append((Object)this.typ);
        builder.append(", lfdNr=");
        builder.append(this.lfdNr);
        builder.append(", genusNumerus=");
        builder.append((Object)this.genusNumerus);
        builder.append("(isPlural=");
        builder.append(String.valueOf(this.isPlural()) + ")");
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Beteiligter)) {
            return false;
        }
        Beteiligter other = (Beteiligter)obj;
        if (this.lfdNr != other.lfdNr) {
            return false;
        }
        return this.typ == other.typ;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lfdNr;
        result = 31 * result + (this.typ == null ? 0 : this.typ.hashCode());
        return result;
    }

    @Override
    public int compareTo(Beteiligter andererBeteiligter) {
        if (this.equals(andererBeteiligter)) {
            return 0;
        }
        if (this.getTyp() == andererBeteiligter.getTyp()) {
            return new Integer(this.getLfdNr()).compareTo(new Integer(andererBeteiligter.getLfdNr()));
        }
        return this.getTyp().compareTo(andererBeteiligter.getTyp());
    }

    public static enum BeteiligtenTyp {
        KLAEGER('k', new String[][]{{"der Kl\u00e4ger", "die Kl\u00e4gerin", "die Kl\u00e4ger", "die Kl\u00e4gerinnen"}, {"des Kl\u00e4gers", "der Kl\u00e4gerin", "der Kl\u00e4ger", "der Kl\u00e4gerinnen"}, {"dem Kl\u00e4ger", "der Kl\u00e4gerin", "den Kl\u00e4gern", "den Kl\u00e4gerinnen"}, {"den Kl\u00e4ger", "die Kl\u00e4gerin", "die Kl\u00e4ger", "die Kl\u00e4gerinnen"}}),
        DRITTWIDERBEKLAGTE('d', new String[][]{{"der Drittwiderbeklagte", "die Drittwiderbeklagte", "die Drittwiderbeklagten", "die Drittwiderbeklagten"}, {"des Drittwiderbeklagten", "der Drittwiderbeklagten", "der Drittwiderbeklagten", "der Drittwiderbeklagten"}, {"dem Drittwiderbeklagte", "der Drittwiderbeklagten", "den Drittwiderbeklagten", "den Drittwiderbeklagten"}, {"den Drittwiderbeklagten", "die Drittwiderbeklagte", "die Drittwiderbeklagten", "die Drittwiderbeklagten"}}),
        BEKLAGTE('b', new String[][]{{"der Beklagte", "die Beklagte", "die Beklagten", "die Beklagten"}, {"des Beklagten", "der Beklagten", "der Beklagten", "der Beklagten"}, {"dem Beklagten", "der Beklagten", "den Beklagten", "den Beklagten"}, {"den Beklagten", "die Beklagte", "die Beklagten", "die Beklagten"}}),
        GERICHTSKOSTEN('g', new String[][]{{"das Gericht", "das Gericht", "die Gerichte", "die Gerichte"}, {"des Gerichts", "des Gerichts", "der Gerichte", "der Gerichte"}, {"dem Gericht", "dem Gericht", "den Gerichten", "den Gerichten"}, {"das Gericht", "das Gericht", "die Gerichte", "die Gerichte"}});

        private final String[][] beugung;
        private final char kurz;

        private BeteiligtenTyp(char kurz, String[][] beugung) {
            this.beugung = beugung;
            this.kurz = kurz;
        }

        public String[][] getBeugung() {
            return this.beugung;
        }

        public String beuge(GenusNumerus genusNumerus, Casus casus) {
            return this.getBeugung()[casus.ordinal()][genusNumerus.ordinal()];
        }

        public static BeteiligtenTyp of(int typ) {
            if (typ == 8) {
                return GERICHTSKOSTEN;
            }
            if (typ < BeteiligtenTyp.values().length) {
                return BeteiligtenTyp.values()[typ];
            }
            return null;
        }

        public static BeteiligtenTyp of(char kurz) {
            BeteiligtenTyp[] beteiligtenTypArray = BeteiligtenTyp.values();
            int n = beteiligtenTypArray.length;
            int n2 = 0;
            while (n2 < n) {
                BeteiligtenTyp typ = beteiligtenTypArray[n2];
                if (typ.kurz() == kurz) {
                    return typ;
                }
                ++n2;
            }
            return null;
        }

        public char kurz() {
            return this.kurz;
        }
    }

    public static enum Casus {
        NOMINATIV,
        GENITIV,
        DATIV,
        AKKUSATIV;

    }

    public static enum GenusNumerus {
        MAENNLICH_SINGULAR(Genus.MAENNLICH, Numerus.SINGULAR),
        WEIBLICH_SINGULAR(Genus.WEIBLICH, Numerus.SINGULAR),
        MAENNLICH_PLURAL(Genus.MAENNLICH, Numerus.PLURAL),
        WEIBLICH_PLURAL(Genus.WEIBLICH, Numerus.PLURAL);

        private final Genus genus;
        private final Numerus numerus;

        private GenusNumerus(Genus genus, Numerus numerus) {
            this.genus = genus;
            this.numerus = numerus;
        }

        public static GenusNumerus of(Genus genus, Numerus numerus) {
            switch (genus) {
                case MAENNLICH: {
                    switch (numerus) {
                        case SINGULAR: {
                            return MAENNLICH_SINGULAR;
                        }
                        case PLURAL: {
                            return MAENNLICH_PLURAL;
                        }
                    }
                }
                case WEIBLICH: {
                    switch (numerus) {
                        case SINGULAR: {
                            return WEIBLICH_SINGULAR;
                        }
                        case PLURAL: {
                            return WEIBLICH_PLURAL;
                        }
                    }
                }
            }
            return null;
        }

        public Genus getGenus() {
            return this.genus;
        }

        public Numerus getNumerus() {
            return this.numerus;
        }

        public static GenusNumerus of(int ordinal) {
            if (ordinal < GenusNumerus.values().length) {
                return GenusNumerus.values()[ordinal];
            }
            return null;
        }

        public static enum Genus {
            MAENNLICH,
            WEIBLICH;

        }

        public static enum Numerus {
            SINGULAR,
            PLURAL;

        }
    }
}

