/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.tenordaten;

import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.baumbach.StreitgenossenAngriffe;
import eu.gronos.kostenrechner.data.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.data.gebuehren.StreitwertReduktionen;
import eu.gronos.kostenrechner.data.gebuehren.Teilklageruecknahme;
import eu.gronos.kostenrechner.data.tenordaten.Allgemein;
import eu.gronos.kostenrechner.data.tenordaten.BegruendungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.Dateikopf;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckungsVerhaeltnis;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="SchustersStrukturierteTenordaten", namespace="https://www.kostentenor.de/SchustersStrukturierteTenordaten")
public class TenorDatenContainer
extends VerfahrensDatenContainer {
    @XmlElement
    public String berechnungsTyp;
    @XmlElements(value={@XmlElement(name="swrn", type=StreitwertReduktionen.class), @XmlElement(name="streit", type=StreitgenossenAngriffe.class)})
    public UnterContainerKlasse erweiterteKlasse;
    @XmlElement(name="hauptsache")
    public EntscheidungsListenElemente<HauptsacheVerhaeltnis> hauptsacheEntscheidung;
    @XmlElement(name="kosten")
    public EntscheidungsListenElemente<KostenTragungsVerhaeltnis> kostenEntscheidung;
    @XmlElement(name="vorlaeufigVollstreckbar")
    public EntscheidungsListenElemente<VollstreckungsVerhaeltnis> vollstreckbarkeitsEntscheidung;
    @XmlElement(name="streitwertEntscheidung")
    public StreitwertEntscheidungsElemente streitwertEntscheidung;
    @XmlElement(name="sonstiges")
    public EntscheidungsElemente sonstigeEntscheidung;
    @XmlElement(name="begruendung")
    public BegruendungsElemente begruendung;

    public TenorDatenContainer() {
        this.dateikopf = new Dateikopf();
        this.hauptsacheEntscheidung = new EntscheidungsListenElemente();
        this.kostenEntscheidung = new EntscheidungsListenElemente();
        this.vollstreckbarkeitsEntscheidung = new EntscheidungsListenElemente();
        this.streitwertEntscheidung = new StreitwertEntscheidungsElemente();
        this.sonstigeEntscheidung = new EntscheidungsElemente();
        this.begruendung = new BegruendungsElemente();
    }

    public TenorDatenContainer(VerfahrensDatenContainer container) {
        this();
        this.allgemein = container.allgemein;
        this.teilklageruecknahme = container.teilklageruecknahme;
        this.streitgenossen = container.streitgenossen;
        this.staffelung = container.staffelung;
        this.gebuehrenBerechnung = container.gebuehrenBerechnung;
    }

    public TenorDatenContainer(UnterContainerKlasse ... unters) {
        this();
        UnterContainerKlasse[] unterContainerKlasseArray = unters;
        int n = unters.length;
        int n2 = 0;
        while (n2 < n) {
            UnterContainerKlasse unter = unterContainerKlasseArray[n2];
            if (unter instanceof Allgemein) {
                this.allgemein = (Allgemein)unter;
            } else if (unter instanceof Teilklageruecknahme) {
                this.teilklageruecknahme = (Teilklageruecknahme)unter;
            } else if (unter instanceof Streitgenossen) {
                this.streitgenossen = (Streitgenossen)unter;
            } else if (unter instanceof ForderungsStaffelung) {
                this.staffelung = (ForderungsStaffelung)unter;
            } else if (unter instanceof GebuehrenBerechnung) {
                this.gebuehrenBerechnung = (GebuehrenBerechnung)unter;
            }
            ++n2;
        }
    }
}

