/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.Vollstreckbarkeit;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckbarkeitsListe;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckungsVerhaeltnis;
import java.util.ArrayList;
import java.util.List;

public class VollstreckbarkeitsHelfer {
    private final List<HauptsacheVerhaeltnis> hauptsacheVerhaeltnisse;
    private final List<KostenTragungsVerhaeltnis> kostenTragungsVerhaeltnisse;

    public VollstreckbarkeitsHelfer(List<HauptsacheVerhaeltnis> hauptsacheVerhaeltnisse, List<KostenTragungsVerhaeltnis> kostenTragungsVerhaeltnisse) {
        this.hauptsacheVerhaeltnisse = hauptsacheVerhaeltnisse;
        this.kostenTragungsVerhaeltnisse = kostenTragungsVerhaeltnisse;
    }

    public List<VollstreckungsVerhaeltnis> toVollstreckbarkeitsVerhaeltnisse(Beteiligter klaeger, Beteiligter beklagter, VollstreckbarkeitsListe vollstreckbarkeitsListe) {
        Vollstreckbarkeit voBk;
        if (vollstreckbarkeitsListe == null || vollstreckbarkeitsListe.isEmpty()) {
            throw new IllegalArgumentException("Die Vollstreckbarkeitsliste darf nicht null oder leer sein!");
        }
        ArrayList<VollstreckungsVerhaeltnis> liste = new ArrayList<VollstreckungsVerhaeltnis>();
        if (vollstreckbarkeitsListe.sindAlle708iVm713()) {
            return this.errechneAlleVollstreckungsVerhaeltnisse((Vollstreckbarkeit)vollstreckbarkeitsListe.get(0));
        }
        Vollstreckbarkeit voKl = (Vollstreckbarkeit)vollstreckbarkeitsListe.get(1);
        if (voKl.hatEintraege()) {
            VollstreckungsVerhaeltnis vollstreckungsVerhaeltnis = new VollstreckungsVerhaeltnis(klaeger, beklagter, voKl);
            Kostenrechner.getLogger().info(vollstreckungsVerhaeltnis.toString());
            liste.add(vollstreckungsVerhaeltnis);
        }
        if ((voBk = (Vollstreckbarkeit)vollstreckbarkeitsListe.get(2)).hatEintraege()) {
            VollstreckungsVerhaeltnis vollstreckungsVerhaeltnis = new VollstreckungsVerhaeltnis(beklagter, klaeger, voBk);
            Kostenrechner.getLogger().info(vollstreckungsVerhaeltnis.toString());
            liste.add(vollstreckungsVerhaeltnis);
        }
        return liste;
    }

    public List<VollstreckungsVerhaeltnis> errechneAlleVollstreckungsVerhaeltnisse(Vollstreckbarkeit vollstreckbarkeit) {
        VollstreckungsVerhaeltnis vollstreckungsVerhaeltnis;
        ArrayList<VollstreckungsVerhaeltnis> liste = new ArrayList<VollstreckungsVerhaeltnis>();
        if (this.hauptsacheVerhaeltnisse != null && !this.hauptsacheVerhaeltnisse.isEmpty()) {
            for (HauptsacheVerhaeltnis hauptsacheVerhaeltnis : this.hauptsacheVerhaeltnisse) {
                if (!hauptsacheVerhaeltnis.getVerurteilung().greaterThan(Euro.ZERO_CENTS)) continue;
                vollstreckungsVerhaeltnis = new VollstreckungsVerhaeltnis(hauptsacheVerhaeltnis.getGlaeubiger(), hauptsacheVerhaeltnis.getSchuldner(), vollstreckbarkeit);
                vollstreckungsVerhaeltnis.setDarueberHinaus(hauptsacheVerhaeltnis.isDarueberHinaus());
                liste.add(vollstreckungsVerhaeltnis);
                Kostenrechner.getLogger().info(vollstreckungsVerhaeltnis.toString());
            }
        }
        if (this.kostenTragungsVerhaeltnisse != null && !this.kostenTragungsVerhaeltnisse.isEmpty()) {
            for (KostenTragungsVerhaeltnis kostenTragungsVerhaeltnis : this.kostenTragungsVerhaeltnisse) {
                if (!kostenTragungsVerhaeltnis.getKostenBruchteil().greaterThan(Fraction.ZERO) || this.enthaeltPaarung(liste, kostenTragungsVerhaeltnis.getGlaeubiger(), kostenTragungsVerhaeltnis.getSchuldner())) continue;
                vollstreckungsVerhaeltnis = new VollstreckungsVerhaeltnis(kostenTragungsVerhaeltnis.getGlaeubiger(), kostenTragungsVerhaeltnis.getSchuldner(), vollstreckbarkeit);
                vollstreckungsVerhaeltnis.setDarueberHinaus(kostenTragungsVerhaeltnis.isDarueberHinaus());
                liste.add(vollstreckungsVerhaeltnis);
                Kostenrechner.getLogger().info(vollstreckungsVerhaeltnis.toString());
            }
        }
        return liste;
    }

    private boolean enthaeltPaarung(List<VollstreckungsVerhaeltnis> vollstreckungsVerhaeltnisse, Beteiligter glaeubiger, Beteiligter schuldner) {
        if (!vollstreckungsVerhaeltnisse.isEmpty()) {
            for (VollstreckungsVerhaeltnis vollstreckungsVerhaeltnis : vollstreckungsVerhaeltnisse) {
                if (!vollstreckungsVerhaeltnis.getGlaeubiger().equals(glaeubiger) || !vollstreckungsVerhaeltnis.getSchuldner().equals(schuldner)) continue;
                return true;
            }
        }
        return false;
    }
}

