/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.baumbach;

import eu.gronos.kostenrechner.data.baumbach.Angriff;
import eu.gronos.kostenrechner.data.baumbach.GerichtsKostenBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.ImUebrigen;
import eu.gronos.kostenrechner.data.baumbach.MehrfachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.StreitgenossenAngriffe;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckbarkeitsListe;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckungsVerhaeltnis;
import eu.gronos.kostenrechner.logic.TenorTexter;
import eu.gronos.kostenrechner.logic.TenorToken;
import eu.gronos.kostenrechner.util.VerlusteBank;
import eu.gronos.kostenrechner.util.baumbach.BeteiligteInAngreiferGegnerReihenfolge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BaumbachTexter
extends TenorTexter<StreitgenossenAngriffe> {
    private final StreitgenossenAngriffe streit;
    private List<List<Angriff>> gruppen;
    private List<ImUebrigen> imUebrigen;
    private Map<Beteiligter, VerlusteBank> bereinigteQuoten;

    public BaumbachTexter(StreitgenossenAngriffe streit, boolean alsBruch) {
        super(alsBruch);
        this.streit = streit;
    }

    @Override
    public String texteHauptsache(EntscheidungsListenElemente<HauptsacheVerhaeltnis> hauptsache) {
        StringBuilder tenor = new StringBuilder();
        for (List<Angriff> gruppe : this.gruppen) {
            ImUebrigen iue = this.imUebrigen.get(this.gruppen.indexOf(gruppe));
            for (Angriff angriff : gruppe) {
                for (HauptsacheVerhaeltnis verhaeltnis : hauptsache.prozessverhaeltnisse) {
                    if (!this.equals(verhaeltnis, angriff)) continue;
                    Beteiligter glaeubiger = verhaeltnis.getGlaeubiger();
                    Beteiligter schuldner = verhaeltnis.getSchuldner();
                    if (iue.getAngriffArt() == Angriff.AngriffArt.WIDERKLAGE) {
                        tenor.append(String.valueOf(TenorToken.AUF_DIE_WIDERKLAGE.toString()) + TenorToken.LEER);
                        tenor.append(super.verbessereGesamtschuldner(String.valueOf(super.getWirdWerden(schuldner.isPlural())) + TenorToken.LEER + schuldner.parteiBezeichner(Beteiligter.Casus.NOMINATIV, schuldner.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(schuldner, this.streit.beteiligte))));
                    } else {
                        tenor.append(String.valueOf(this.satzBeginn(schuldner.parteiBezeichner(Beteiligter.Casus.NOMINATIV, schuldner.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(schuldner, this.streit.beteiligte)))) + TenorToken.LEER + super.getWirdWerden(schuldner.isPlural()));
                    }
                    if (verhaeltnis.isDarueberHinaus()) {
                        tenor.append(TenorToken.LEER);
                        tenor.append(TenorToken.DARUEBER_HINAUS);
                    }
                    tenor.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.VERURTEILT + TenorToken.KOMMA_LEER + angriff.getErfolg().toString() + TenorToken.LEER + TenorToken.EURO + TenorToken.LEER + TenorToken.AN + TenorToken.LEER + glaeubiger.parteiBezeichner(Beteiligter.Casus.AKKUSATIV, glaeubiger.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(glaeubiger, this.streit.beteiligte)) + TenorToken.LEER + TenorToken.ZU_ZAHLEN + TenorToken.PUNKT_ABSATZ);
                }
            }
            String abweisungsString = iue.toAbweisungsString();
            tenor.append(abweisungsString);
        }
        return this.verbessereGesamtschuldner(tenor.toString());
    }

    @Override
    public String texteKostenentscheidung(EntscheidungsListenElemente<KostenTragungsVerhaeltnis> elemente) {
        StringBuilder tenor = new StringBuilder();
        StringBuilder satz = new StringBuilder();
        ArrayList<Beteiligter> ueberspringen = new ArrayList<Beteiligter>();
        List<List<Beteiligter>> gleichlautendezeilen = this.findeGleichlautendeQuoten(this.bereinigteQuoten);
        boolean alleKostenGleich = this.alleKostenGleich(gleichlautendezeilen);
        Beteiligter glaeubiger = null;
        for (KostenTragungsVerhaeltnis verhaeltnis : elemente.prozessverhaeltnisse) {
            boolean gewechselt = !verhaeltnis.getGlaeubiger().equals(glaeubiger);
            glaeubiger = verhaeltnis.getGlaeubiger();
            if (ueberspringen.contains(glaeubiger)) continue;
            if (gewechselt) {
                if (satz.length() >= 1) {
                    tenor.append(super.hatStattHaben(BaumbachTexter.undStattKomma(BaumbachTexter.letztesKommaWeg(satz.toString()))));
                    tenor.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.ZU_TRAGEN + TenorToken.PUNKT_ABSATZ);
                    satz.delete(0, satz.length());
                }
                List<Beteiligter> mehrere = null;
                for (List<Beteiligter> multi : gleichlautendezeilen) {
                    if (!multi.contains(glaeubiger)) continue;
                    mehrere = multi;
                }
                if (alleKostenGleich) {
                    satz.append(TenorToken.DIE_KOSTEN_DES_RECHTSSTREITS);
                    satz.append(TenorToken.LEER);
                    this.fuelleUeberspringen(this.streit.beteiligte, ueberspringen, glaeubiger);
                } else if (mehrere != null) {
                    if (glaeubiger instanceof GerichtsKostenBeteiligter) {
                        satz.append(TenorToken.DIE_GERICHTSKOSTEN);
                        satz.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.UND_DIE + TenorToken.LEER + TenorToken.AUSSERGERICHTLICHEN_KOSTEN + TenorToken.LEER);
                        ArrayList<Beteiligter> mehrerere = new ArrayList<Beteiligter>();
                        this.fuelleUeberspringen(mehrere, mehrerere, glaeubiger);
                        satz.append(MehrfachBeteiligter.parteiBezeichnerListe(this.streit.beteiligte, mehrerere, Beteiligter.Casus.GENITIV));
                    } else {
                        satz.append(String.valueOf(TenorToken.DIE.toString()) + TenorToken.LEER + TenorToken.AUSSERGERICHTLICHEN_KOSTEN + TenorToken.LEER);
                        satz.append(MehrfachBeteiligter.parteiBezeichnerListe(this.streit.beteiligte, mehrere, Beteiligter.Casus.GENITIV));
                    }
                    this.fuelleUeberspringen(mehrere, ueberspringen, glaeubiger);
                } else if (glaeubiger instanceof GerichtsKostenBeteiligter) {
                    satz.append(TenorToken.DIE_GERICHTSKOSTEN);
                } else {
                    satz.append(TenorToken.DIE + TenorToken.LEER.toString() + TenorToken.AUSSERGERICHTLICHEN_KOSTEN + TenorToken.LEER);
                    satz.append(glaeubiger.parteiBezeichner(Beteiligter.Casus.GENITIV, glaeubiger.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(glaeubiger, this.streit.beteiligte)));
                }
                satz.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.HABEN + TenorToken.LEER);
            }
            satz.append(verhaeltnis.getSchuldner().parteiBezeichner(Beteiligter.Casus.NOMINATIV, verhaeltnis.getSchuldner().getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(verhaeltnis.getSchuldner(), this.streit.beteiligte)));
            if (verhaeltnis.isDarueberHinaus()) {
                satz.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.DARUEBER_HINAUS + TenorToken.LEER);
            }
            Fraction kostenBruchteil = verhaeltnis.getKostenBruchteil();
            Fraction bruch = this.bruchteilAus(glaeubiger, verhaeltnis.getSchuldner());
            if (kostenBruchteil.lessThan(Fraction.ONE)) {
                satz.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.ZU + TenorToken.LEER);
                if (this.alsBruch) {
                    satz.append(bruch);
                } else {
                    satz.append(bruch.toPercentString());
                }
            }
            satz.append(TenorToken.KOMMA_LEER);
        }
        if (satz.length() >= 1) {
            tenor.append(super.hatStattHaben(BaumbachTexter.undStattKomma(BaumbachTexter.letztesKommaWeg(satz.toString()))));
            tenor.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.ZU_TRAGEN);
            satz.delete(0, satz.length());
            tenor.append(TenorToken.PUNKT_ABSATZ);
        }
        if (!alleKostenGleich) {
            tenor.append(TenorToken.KOSTENTRAGUNG_SELBST);
            tenor.append(TenorToken.PUNKT_ABSATZ);
        }
        return tenor.toString().replace("  ", TenorToken.LEER);
    }

    private Fraction bruchteilAus(Beteiligter glaeubiger, Beteiligter schuldner) {
        List<Beteiligter> schuldner2;
        VerlusteBank bank = this.bereinigteQuoten.get(glaeubiger);
        if (bank == null || bank.keySet().isEmpty()) {
            throw new NullPointerException("Keine Bank f\u00fcr " + glaeubiger);
        }
        if (schuldner instanceof MehrfachBeteiligter) {
            schuldner2 = ((MehrfachBeteiligter)schuldner).getBeteiligte();
        } else {
            schuldner2 = new ArrayList<Beteiligter>();
            schuldner2.add(schuldner);
        }
        if (bank.get(schuldner2) != null) {
            return bank.getFractionFor(schuldner2);
        }
        throw new NullPointerException("Kein Konto f\u00fcr " + schuldner);
    }

    @Override
    public String texteVollstreckbarkeit(EntscheidungsListenElemente<VollstreckungsVerhaeltnis> elemente, VollstreckbarkeitsListe liste) {
        String schuldner = TenorToken.JEWEILIGER_VOLLSTRECKUNGSSCHULDNER.toString();
        String glaeubiger = TenorToken.JEWEILIGER_VOLLSTRECKUNGSGLAEUBIGER.toString();
        if (liste.sindAlle708iVm713()) {
            return String.valueOf(TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR.toString()) + TenorToken.PUNKT_ABSATZ;
        }
        if (liste.sindAlle709()) {
            return String.valueOf(TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR_709.toString()) + TenorToken.PUNKT_ABSATZ;
        }
        if (liste.sindAlle708iVm711()) {
            if (1 == this.zaehle708iVm711(elemente.prozessverhaeltnisse)) {
                Beteiligter schuldnerBeteiligter = ((VollstreckungsVerhaeltnis)elemente.prozessverhaeltnisse.get(0)).getSchuldner();
                Beteiligter glaeubigerBeteiligter = ((VollstreckungsVerhaeltnis)elemente.prozessverhaeltnisse.get(0)).getGlaeubiger();
                schuldner = schuldnerBeteiligter.parteiBezeichner(Beteiligter.Casus.DATIV, schuldnerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(schuldnerBeteiligter, this.streit.beteiligte));
                glaeubiger = glaeubigerBeteiligter.parteiBezeichner(Beteiligter.Casus.NOMINATIV, glaeubigerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(glaeubigerBeteiligter, this.streit.beteiligte));
            }
            return String.valueOf(TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR.toString()) + TenorToken.PUNKT_ABSATZ + this.satzBeginn(schuldner) + TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_1 + glaeubiger + TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_2 + TenorToken.PUNKT_ABSATZ;
        }
        StringBuffer tenor = new StringBuffer(TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR);
        tenor.append(TenorToken.PUNKT_ABSATZ);
        StringBuffer tenor709 = new StringBuffer();
        StringBuffer tenor708 = new StringBuffer();
        int size709 = this.zaehle709(elemente.prozessverhaeltnisse);
        int size708u711 = this.zaehle708iVm711(elemente.prozessverhaeltnisse);
        if (size709 > 1) {
            tenor709 = new StringBuffer(TenorToken.HINSICHTLICH_DES_JEWEILIGEN_VOLLSTRECKUNGSVERHAELTNISSES);
            tenor709.append(TenorToken.LEER);
        }
        if (size708u711 > 1) {
            tenor708 = new StringBuffer(TenorToken.HINSICHTLICH_DES_JEWEILIGEN_VOLLSTRECKUNGSVERHAELTNISSES);
            tenor708.append(TenorToken.LEER);
        }
        for (VollstreckungsVerhaeltnis verhaeltnis : elemente.prozessverhaeltnisse) {
            Beteiligter schuldnerBeteiligter = verhaeltnis.getSchuldner();
            Beteiligter glaeubigerBeteiligter = verhaeltnis.getGlaeubiger();
            if (verhaeltnis.getVollstreckbarkeit().isB709s1()) {
                if (size709 == 1) {
                    schuldner = schuldnerBeteiligter.parteiBezeichner(Beteiligter.Casus.DATIV, schuldnerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(schuldnerBeteiligter, this.streit.beteiligte));
                    glaeubiger = glaeubigerBeteiligter.parteiBezeichner(Beteiligter.Casus.AKKUSATIV, glaeubigerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(glaeubigerBeteiligter, this.streit.beteiligte));
                    tenor709 = new StringBuffer(String.valueOf(TenorToken.FUER.toString()) + TenorToken.LEER + glaeubiger + TenorToken.LEER + TenorToken.GEGENUEBER + TenorToken.LEER + schuldner);
                    continue;
                }
                glaeubiger = glaeubigerBeteiligter.parteiBezeichner(Beteiligter.Casus.GENITIV, glaeubigerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(glaeubigerBeteiligter, this.streit.beteiligte));
                schuldner = schuldnerBeteiligter.parteiBezeichner(Beteiligter.Casus.AKKUSATIV, schuldnerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(schuldnerBeteiligter, this.streit.beteiligte));
                tenor709.append(String.valueOf(glaeubiger) + TenorToken.LEER + TenorToken.GEGEN + TenorToken.LEER + schuldner + TenorToken.KOMMA_LEER);
                continue;
            }
            if (!verhaeltnis.getVollstreckbarkeit().isB711()) continue;
            if (size708u711 == 1) {
                schuldner = schuldnerBeteiligter.parteiBezeichner(Beteiligter.Casus.DATIV, schuldnerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(schuldnerBeteiligter, this.streit.beteiligte));
                glaeubiger = glaeubigerBeteiligter.parteiBezeichner(Beteiligter.Casus.NOMINATIV, glaeubigerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(glaeubigerBeteiligter, this.streit.beteiligte));
                tenor708 = new StringBuffer(String.valueOf(this.satzBeginn(schuldner)) + TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_1 + glaeubiger + TenorToken.LEER + TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_2 + TenorToken.PUNKT_ABSATZ);
                continue;
            }
            glaeubiger = glaeubigerBeteiligter.parteiBezeichner(Beteiligter.Casus.GENITIV, glaeubigerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(glaeubigerBeteiligter, this.streit.beteiligte));
            schuldner = schuldnerBeteiligter.parteiBezeichner(Beteiligter.Casus.AKKUSATIV, schuldnerBeteiligter.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(schuldnerBeteiligter, this.streit.beteiligte));
            tenor708.append(String.valueOf(glaeubiger) + TenorToken.LEER + TenorToken.GEGEN + TenorToken.LEER + schuldner + TenorToken.KOMMA_LEER);
        }
        if (size709 > 0) {
            if (1 == size709) {
                tenor.append(tenor709);
            } else {
                tenor.append(TenorTexter.undStattKomma(TenorTexter.letztesKommaWeg(tenor709.toString())));
            }
            tenor.append(TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR_709_EINZELN);
            tenor.append(TenorToken.PUNKT_ABSATZ);
        }
        if (size708u711 == 1) {
            tenor.append(tenor708);
        } else if (size708u711 > 1) {
            tenor.append(String.valueOf(TenorTexter.undStattKomma(TenorTexter.letztesKommaWeg(tenor708.toString()))) + TenorToken.LEER + TenorToken.WIRD + TenorToken.LEER + TenorToken.JEWEILIGER_VOLLSTRECKUNGSSCHULDNER + TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_WERIST_1 + TenorToken.JEWEILIGER_VOLLSTRECKUNGSGLAEUBIGER + TenorToken.URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_WERIST_2 + TenorToken.PUNKT_ABSATZ);
        }
        return tenor.toString();
    }

    @Override
    public String texteStreitwert(StreitwertEntscheidungsElemente elemente) {
        StringBuilder builder = new StringBuilder(String.valueOf(TenorToken.STREITWERT_WIRD_AUF.toString()) + TenorToken.LEER);
        if (elemente.streitwerte.size() > 1) {
            builder.append(Euro.formatRealEuros(elemente.streitwerte.get(0).longValue()));
            builder.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.EURO + TenorToken.KOMMA_LEER + TenorToken.DAVON_FD_KLAGE);
            builder.append(Euro.formatRealEuros(elemente.streitwerte.get(1).longValue()));
            builder.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.EURO + TenorToken.LEER + TenorToken.UND_FD_WIDERKLAGE + TenorToken.LEER);
            builder.append(Euro.formatRealEuros(elemente.streitwerte.get(2).longValue()));
        } else {
            builder.append(Euro.formatRealEuros(elemente.streitwerte.get(0).longValue()));
        }
        builder.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.EURO + TenorToken.LEER + TenorToken.FESTGESETZT + "\n");
        return builder.toString();
    }

    public void setBereinigteQuoten(Map<Beteiligter, VerlusteBank> bereinigteQuoten) {
        this.bereinigteQuoten = bereinigteQuoten;
    }

    public void setGruppen(List<List<Angriff>> gruppen) {
        this.gruppen = gruppen;
    }

    public void setImUebrigen(List<ImUebrigen> imUebrigen) {
        this.imUebrigen = imUebrigen;
    }

    private boolean alleKostenGleich(List<List<Beteiligter>> gleichlautendezeilen) {
        ArrayList<Beteiligter> alleGlaeubiger = new ArrayList<Beteiligter>();
        for (List<Beteiligter> glaeubiger : gleichlautendezeilen) {
            for (Beteiligter einzelne : glaeubiger) {
                if (alleGlaeubiger.contains(einzelne)) continue;
                alleGlaeubiger.add(einzelne);
            }
        }
        return alleGlaeubiger.size() == this.bereinigteQuoten.keySet().size();
    }

    private boolean equals(HauptsacheVerhaeltnis verhaeltnis, Angriff angriff) {
        boolean gleicherAngreifer = this.equals(verhaeltnis.getGlaeubiger(), (List<Beteiligter>)angriff.getAngreifer());
        boolean gleicherGegner = this.equals(verhaeltnis.getSchuldner(), (List<Beteiligter>)angriff.getGegner());
        boolean gleicheHoehe = verhaeltnis.getVerurteilung().equals(angriff.getErfolg());
        return gleicherAngreifer && gleicherGegner && gleicheHoehe;
    }

    private boolean equals(Beteiligter beteiligter, List<Beteiligter> liste) {
        if (beteiligter instanceof MehrfachBeteiligter) {
            return ((MehrfachBeteiligter)beteiligter).listEquals(liste);
        }
        return liste.size() == 1 && liste.contains(beteiligter);
    }

    private List<List<Beteiligter>> findeGleichlautendeQuoten(Map<Beteiligter, VerlusteBank> quoten) {
        ArrayList<List<Beteiligter>> listen = new ArrayList<List<Beteiligter>>();
        if (quoten == null || quoten.isEmpty()) {
            return listen;
        }
        for (Beteiligter a : quoten.keySet()) {
            if (a == null || quoten.get(a) == null) continue;
            for (Beteiligter b : quoten.keySet()) {
                ArrayList<Beteiligter> beteiligte = new ArrayList<Beteiligter>();
                beteiligte.add(a);
                if (b == null || quoten.get(b) == null || a.equals(b)) continue;
                if (quoten.get(a).equals(quoten.get(b))) {
                    beteiligte.add(b);
                }
                if (beteiligte.size() <= 1) continue;
                Collections.sort(beteiligte, new BeteiligteInAngreiferGegnerReihenfolge());
                if (listen.contains(beteiligte)) continue;
                listen.add(beteiligte);
            }
        }
        return listen;
    }

    private void fuelleUeberspringen(List<Beteiligter> source, List<Beteiligter> target, Beteiligter exception) {
        for (Beteiligter einzelner : source) {
            if (exception.equals(einzelner)) continue;
            target.add(einzelner);
        }
    }

    private int zaehle708iVm711(List<VollstreckungsVerhaeltnis> verhaeltnisse) {
        int size = 0;
        for (VollstreckungsVerhaeltnis verhaeltnis : verhaeltnisse) {
            if (!verhaeltnis.getVollstreckbarkeit().isB711()) continue;
            ++size;
        }
        return size;
    }

    private int zaehle709(List<VollstreckungsVerhaeltnis> verhaeltnisse) {
        int size = 0;
        for (VollstreckungsVerhaeltnis verhaeltnis : verhaeltnisse) {
            if (!verhaeltnis.getVollstreckbarkeit().isB709s1()) continue;
            ++size;
        }
        return size;
    }
}

