/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.forderungen;

import eu.gronos.kostenrechner.data.KostenZweierquote;
import eu.gronos.kostenrechner.data.forderungen.Angriffserfolg;
import eu.gronos.kostenrechner.data.forderungen.AufrechnungsForderung;
import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.data.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.data.forderungen.KlageForderung;
import eu.gronos.kostenrechner.data.tenordaten.Allgemein;
import eu.gronos.kostenrechner.data.tenordaten.BegruendungsZahlenZeile;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.Vollstreckbarkeit;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckbarkeitsListe;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckungsVerhaeltnis;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.interfaces.TenorVorbereitend;
import eu.gronos.kostenrechner.logic.TenorTexter;
import eu.gronos.kostenrechner.logic.VollstreckbarkeitsHelfer;
import eu.gronos.kostenrechner.logic.forderungen.AngriffsTexter;
import eu.gronos.kostenrechner.util.BegruendungsZahlenTabelle;
import eu.gronos.kostenrechner.util.VerlusteBank;
import eu.gronos.kostenrechner.util.forderungen.ForderungsStaffelungPruefer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AngriffsVerteidigungsmittelStaffelung
implements TenorVorbereitend {
    private final TenorDatenContainer container;
    private static final String[] COLUMN_HEADERS = new String[]{"Angriffs-/Verteidigungsmittel", "H\u00f6he der Forderung (EUR)", "Erh\u00f6ht den Streitwert um (EUR)", "Davon begr\u00fcndet (EUR)", "(verbleibende) Klageforderung"};
    private static final String GRUENDE_START_ANGRIFFS_VERTEIDIGUNGS_MITTEL = "Denn das Verh\u00e4ltnis von Obsiegen und Unterliegen bemisst sich anhand folgender Angriffs- und Verteidigungsmittel:\n";
    private static final String BESCHREIBUNG = "Tenor bei Klage/Hilfsaufrechnung (Hauptsachetenor, Kostentenor, Vollstreckbarkeitstenor und Streitwertbeschluss)";
    private final Beteiligter klaeger;
    private final Beteiligter beklagter;
    private Angriffserfolg hauptsache = null;
    private KostenZweierquote kosten = null;
    private Allgemein allgemein;
    private ForderungsStaffelung staffelung;
    private StringBuilder gruende = new StringBuilder();
    private BegruendungsZahlenTabelle zeilen;
    private VollstreckbarkeitsListe vollstreckbarkeitsListe;
    private final AngriffsTexter texter;
    private final Pruefend<ForderungsStaffelung> pruefer = new ForderungsStaffelungPruefer();
    private ArrayList<Beteiligter> klaegerlein;
    private ArrayList<Beteiligter> beklagte;
    private final VerlusteBank unterliegen;

    public AngriffsVerteidigungsmittelStaffelung(VerfahrensDatenContainer verfahrensDaten) throws IllegalArgumentException {
        this.staffelung = verfahrensDaten.staffelung;
        this.pruefer.pruefeEingabe(this.staffelung);
        this.setzeForderungenZurueck(this.staffelung.forderungen);
        this.klaeger = (Beteiligter)this.staffelung.parteien.get(0);
        this.beklagter = (Beteiligter)this.staffelung.parteien.get(1);
        this.klaegerlein = new ArrayList(this.staffelung.parteien.subList(0, 1));
        this.beklagte = new ArrayList(this.staffelung.parteien.subList(1, this.staffelung.parteien.size()));
        this.allgemein = verfahrensDaten.allgemein;
        this.texter = new AngriffsTexter(this.allgemein.alsBruch);
        this.container = new TenorDatenContainer(verfahrensDaten);
        this.allgemein.streitwert = null;
        this.unterliegen = new VerlusteBank();
    }

    @Override
    public EntscheidungsListenElemente<HauptsacheVerhaeltnis> erzeugeHauptsacheEntscheidung() {
        EntscheidungsListenElemente<HauptsacheVerhaeltnis> entscheidung = new EntscheidungsListenElemente<HauptsacheVerhaeltnis>();
        if (this.hauptsache == null) {
            this.hauptsache = this.berechneHauptsache();
        }
        entscheidung.prozessverhaeltnisse.clear();
        entscheidung.prozessverhaeltnisse.add(new HauptsacheVerhaeltnis(this.klaeger, this.beklagter, false, this.hauptsache.getErfolg()));
        this.texter.setGanz(this.hauptsache.getVolleForderung());
        entscheidung.text = this.texter.texteHauptsache(entscheidung);
        return entscheidung;
    }

    @Override
    public EntscheidungsListenElemente<KostenTragungsVerhaeltnis> erzeugeKostenEntscheidung() {
        EntscheidungsListenElemente<KostenTragungsVerhaeltnis> kostenEntscheidung = new EntscheidungsListenElemente<KostenTragungsVerhaeltnis>();
        kostenEntscheidung.prozessverhaeltnisse.clear();
        Fraction fract92ii = Fraction.valueOf(this.allgemein.vomHundert92ii, 100L);
        if (this.kosten == null) {
            this.kosten = this.berechneKostenverteilung();
        }
        if (this.kosten.getKlaegerQuote().lessThanOrEqualTo(Fraction.ZERO) && !this.allgemein.b92ii || this.kosten.getKlaegerQuote().lessThan(fract92ii) && this.allgemein.b92ii) {
            kostenEntscheidung.prozessverhaeltnisse.add(new KostenTragungsVerhaeltnis(this.klaeger, this.beklagter, false, Fraction.ONE));
        } else if (this.kosten.getBeklagtenQuote().lessThanOrEqualTo(Fraction.ZERO) && !this.allgemein.b92ii || this.kosten.getBeklagtenQuote().lessThan(fract92ii) && this.allgemein.b92ii) {
            kostenEntscheidung.prozessverhaeltnisse.add(new KostenTragungsVerhaeltnis(this.beklagter, this.klaeger, false, Fraction.ONE));
        } else {
            kostenEntscheidung.prozessverhaeltnisse.add(new KostenTragungsVerhaeltnis(this.beklagter, this.klaeger, false, this.kosten.getKlaegerQuote()));
            kostenEntscheidung.prozessverhaeltnisse.add(new KostenTragungsVerhaeltnis(this.klaeger, this.beklagter, false, this.kosten.getBeklagtenQuote()));
        }
        if (this.kosten.getKlaegerQuote().lessThanOrEqualTo(Fraction.ZERO) || this.kosten.getBeklagtenQuote().lessThanOrEqualTo(Fraction.ZERO)) {
            this.starteGruende("Die Kostenentscheidung beruht auf \u00a7 91 ZPO.\n");
        } else if (this.allgemein.b92ii && (this.kosten.getKlaegerQuote().lessThanOrEqualTo(fract92ii) || this.kosten.getBeklagtenQuote().lessThanOrEqualTo(fract92ii))) {
            this.starteGruende("Die Kostenentscheidung beruht auf \u00a7\u00a7 91, 92 Abs. 2 ZPO.\n");
        } else {
            this.starteGruende("Die Kostenentscheidung beruht auf \u00a7 92 Abs. 1 ZPO.\n");
        }
        this.erweitereGruende(GRUENDE_START_ANGRIFFS_VERTEIDIGUNGS_MITTEL);
        this.zeilen.toStringBuilder(this.gruende);
        kostenEntscheidung.text = this.texter.texteKostenentscheidung(kostenEntscheidung);
        return kostenEntscheidung;
    }

    @Override
    public EntscheidungsListenElemente<VollstreckungsVerhaeltnis> erzeugeVollstreckbarkeitsEntscheidung() {
        EntscheidungsListenElemente<VollstreckungsVerhaeltnis> vollEntscheidung = new EntscheidungsListenElemente<VollstreckungsVerhaeltnis>();
        if (this.vollstreckbarkeitsListe == null) {
            this.vollstreckbarkeitsListe = this.berechneVollstreckbarkeit();
        }
        this.erweitereGruende(this.vollstreckbarkeitsListe.toString());
        VollstreckbarkeitsHelfer helfer = new VollstreckbarkeitsHelfer(this.container.hauptsacheEntscheidung.prozessverhaeltnisse, this.container.kostenEntscheidung.prozessverhaeltnisse);
        vollEntscheidung.prozessverhaeltnisse = helfer.toVollstreckbarkeitsVerhaeltnisse(this.klaeger, this.beklagter, this.vollstreckbarkeitsListe);
        vollEntscheidung.text = this.texter.texteVollstreckbarkeit(vollEntscheidung, this.vollstreckbarkeitsListe);
        return vollEntscheidung;
    }

    @Override
    public StreitwertEntscheidungsElemente erzeugeStreitwertEntscheidung() {
        StreitwertEntscheidungsElemente swe = new StreitwertEntscheidungsElemente();
        if (this.allgemein.streitwert == null || this.allgemein.streitwert.lessThan(Euro.ZERO_CENTS)) {
            this.allgemein.streitwert = this.berechneStreitwert();
        }
        swe.streitwerte.add(this.allgemein.streitwert);
        swe.text = this.texter.texteStreitwert(swe);
        return swe;
    }

    @Override
    public EntscheidungsElemente erzeugeSonstigeEntscheidung() {
        EntscheidungsElemente sonstige = new EntscheidungsElemente();
        sonstige.text = "";
        return sonstige;
    }

    @Override
    public String getGruende() {
        return this.gruende.toString();
    }

    @Override
    public TenorDatenContainer erzeugeContainer() {
        this.container.berechnungsTyp = this.getBerechnungsTyp();
        this.container.hauptsacheEntscheidung = this.erzeugeHauptsacheEntscheidung();
        this.container.kostenEntscheidung = this.erzeugeKostenEntscheidung();
        this.container.vollstreckbarkeitsEntscheidung = this.erzeugeVollstreckbarkeitsEntscheidung();
        this.container.streitwertEntscheidung = this.erzeugeStreitwertEntscheidung();
        this.container.sonstigeEntscheidung = this.erzeugeSonstigeEntscheidung();
        this.container.begruendung = this.zeilen.toBegruendungsElemente(this.getGruende());
        this.container.allgemein.selectedPanel = 2;
        return this.container;
    }

    @Override
    public String getBerechnungsTyp() {
        return BESCHREIBUNG;
    }

    public static Euro berechneEffektivenWert(AufrechnungsForderung aufrechnung, Euro verbliebeneKlageforderung) {
        aufrechnung.setEffektiverWert(Euro.min(verbliebeneKlageforderung, aufrechnung.getAntrag()));
        return aufrechnung.getEffektiverWert().get();
    }

    public static Euro berechneEffektivenErfolg(AufrechnungsForderung aufrechnung, Euro verbliebeneKlageforderung) {
        aufrechnung.setEffektiverErfolg(Euro.min(verbliebeneKlageforderung, aufrechnung.getErfolg()));
        return aufrechnung.getEffektiverErfolg().get();
    }

    private void setzeForderungenZurueck(List<Forderung> liste) {
        for (Forderung forderung : liste) {
            if (!(forderung instanceof AufrechnungsForderung)) continue;
            AufrechnungsForderung aufrechnung = (AufrechnungsForderung)forderung;
            aufrechnung.setzeEffektivenErfolgZurueck();
            aufrechnung.setzeEffektivenWertZurueck();
        }
    }

    private Angriffserfolg berechneHauptsache() {
        Euro verbleibend = Euro.ZERO_CENTS;
        Euro volleForderung = Euro.ZERO_CENTS;
        for (Forderung f : this.staffelung.forderungen) {
            if (f instanceof KlageForderung) {
                verbleibend = verbleibend.add(f.getErfolg());
                if (((KlageForderung)f).isWirtschaftlichIdentisch()) continue;
                volleForderung = volleForderung.add(f.getAntrag());
                continue;
            }
            if (!(f instanceof AufrechnungsForderung)) continue;
            AufrechnungsForderung af = (AufrechnungsForderung)f;
            verbleibend = !af.getEffektiverErfolg().isPresent() ? verbleibend.subtract(AngriffsVerteidigungsmittelStaffelung.berechneEffektivenErfolg(af, verbleibend)) : verbleibend.subtract(af.getEffektiverErfolg().get());
        }
        return new Angriffserfolg(volleForderung, verbleibend);
    }

    private KostenZweierquote berechneKostenverteilung() {
        if (this.allgemein.streitwert == null || this.allgemein.streitwert.lessThan(Euro.ZERO_CENTS)) {
            this.allgemein.streitwert = this.berechneStreitwert();
        }
        Euro verbleibend = Euro.ZERO_CENTS;
        int aufrechnungen = 0;
        this.zeilen = new BegruendungsZahlenTabelle();
        this.zeilen.add(new ArrayList<String>(Arrays.asList(COLUMN_HEADERS)));
        for (Forderung f : this.staffelung.forderungen) {
            String beschreibung;
            BegruendungsZahlenZeile zahlenZeile = new BegruendungsZahlenZeile(4);
            if (f instanceof KlageForderung) {
                beschreibung = f.getBeschreibung();
                verbleibend = verbleibend.add(f.getErfolg());
                this.unterliegen.add(this.klaegerlein, f.getAntrag().subtract(f.getErfolg()));
                this.unterliegen.add(this.beklagte, f.getErfolg());
                zahlenZeile.add(f.getAntrag());
                zahlenZeile.add(f.getAntrag());
                zahlenZeile.add(f.getErfolg());
                zahlenZeile.add(verbleibend);
                this.zeilen.add(beschreibung, zahlenZeile);
                continue;
            }
            if (!(f instanceof AufrechnungsForderung)) continue;
            beschreibung = String.format("%d. %s", ++aufrechnungen, f.getBeschreibung());
            AufrechnungsForderung af = (AufrechnungsForderung)f;
            Euro effektiverErfolg = !af.getEffektiverErfolg().isPresent() ? AngriffsVerteidigungsmittelStaffelung.berechneEffektivenErfolg(af, verbleibend) : af.getEffektiverErfolg().get();
            Euro effektiverWert = !af.getEffektiverWert().isPresent() ? AngriffsVerteidigungsmittelStaffelung.berechneEffektivenWert(af, verbleibend) : af.getEffektiverWert().get();
            verbleibend = verbleibend.subtract(effektiverErfolg);
            this.unterliegen.add(this.klaegerlein, effektiverErfolg);
            this.unterliegen.add(this.beklagte, effektiverWert.subtract(effektiverErfolg));
            zahlenZeile.add(f.getAntrag());
            zahlenZeile.add((Number)af.getEffektiverWert().get());
            zahlenZeile.add((Number)af.getEffektiverErfolg().get());
            zahlenZeile.add(verbleibend);
            this.zeilen.add(beschreibung, zahlenZeile);
        }
        System.out.println("Fiktiver Streitwert:" + this.unterliegen.getFiktiverStreitwert() + ";Fraction Kl:" + this.unterliegen.getFractionFor(this.klaegerlein) + ";Bk:" + this.unterliegen.getFractionFor(this.beklagte));
        return new KostenZweierquote(this.unterliegen.getFractionFor(this.klaegerlein), this.unterliegen.getFractionFor(this.beklagte));
    }

    private VollstreckbarkeitsListe berechneVollstreckbarkeit() {
        VollstreckbarkeitsListe vollstreckbarkeitsListe = new VollstreckbarkeitsListe();
        if (this.kosten == null) {
            this.kosten = this.berechneKostenverteilung();
        }
        Vollstreckbarkeit unanfechtbarkeit = this.pruefeUnanfechtbarkeit(this.unterliegen);
        vollstreckbarkeitsListe.add(unanfechtbarkeit);
        if (unanfechtbarkeit.isB713()) {
            return vollstreckbarkeitsListe;
        }
        vollstreckbarkeitsListe.add(Vollstreckbarkeit.pruefeSicherheitsleistung(this.hauptsache.getErfolg(), TenorTexter.getKostenKlaeger().errechneGebuehrenSumme(this.allgemein.streitwert).multiply(this.kosten.getBeklagtenQuote())));
        vollstreckbarkeitsListe.add(Vollstreckbarkeit.pruefeSicherheitsleistung(Euro.ZERO_CENTS, TenorTexter.getKostenBeklagter().errechneGebuehrenSumme(this.allgemein.streitwert).multiply(this.kosten.getKlaegerQuote())));
        return vollstreckbarkeitsListe;
    }

    private Vollstreckbarkeit pruefeUnanfechtbarkeit(VerlusteBank unterliegen) {
        Vollstreckbarkeit unanfechtbarkeit = new Vollstreckbarkeit();
        Euro streitwert = unterliegen.getFiktiverStreitwert();
        if (streitwert.compareTo(TenorTexter.BERUFUNGS_GRENZE) <= 0) {
            unanfechtbarkeit = new Vollstreckbarkeit(true, false, false, false, true);
        } else if (streitwert.compareTo(TenorTexter.BERUFUNGS_GRENZE.multiply(2.0)) <= 0 && unterliegen.get(this.klaegerlein).compareTo(TenorTexter.BERUFUNGS_GRENZE) <= 0 && unterliegen.get(this.beklagte).compareTo(TenorTexter.BERUFUNGS_GRENZE) <= 0) {
            unanfechtbarkeit = new Vollstreckbarkeit(true, false, false, false, true);
        }
        return unanfechtbarkeit;
    }

    private Euro berechneStreitwert() {
        Euro wert = Euro.ZERO_CENTS;
        Euro verbleibend = Euro.ZERO_CENTS;
        for (Forderung f : this.staffelung.forderungen) {
            if (f instanceof KlageForderung) {
                verbleibend = verbleibend.add(f.getErfolg());
                if (((KlageForderung)f).isWirtschaftlichIdentisch()) continue;
                wert = wert.add(f.getAntrag());
                continue;
            }
            if (!(f instanceof AufrechnungsForderung)) continue;
            AufrechnungsForderung af = (AufrechnungsForderung)f;
            wert = wert.add(!af.getEffektiverWert().isPresent() ? AngriffsVerteidigungsmittelStaffelung.berechneEffektivenWert(af, verbleibend) : af.getEffektiverWert().get());
            verbleibend = verbleibend.subtract(!af.getEffektiverErfolg().isPresent() ? AngriffsVerteidigungsmittelStaffelung.berechneEffektivenErfolg(af, verbleibend) : af.getEffektiverErfolg().get());
        }
        return wert;
    }

    private void starteGruende(CharSequence text) {
        if (this.gruende.length() > 0) {
            this.gruende.delete(0, this.gruende.length());
        }
        this.erweitereGruende(text);
    }

    private void erweitereGruende(CharSequence text) {
        this.gruende.append(text);
    }
}

